/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.SerialCallbackContext;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.misc.JavaOISAccess;
import sun.misc.ObjectInputFilter;
import sun.misc.ObjectStreamClassValidator;
import sun.misc.SharedSecrets;
import sun.misc.VM;
import sun.reflect.misc.ReflectUtil;
import sun.util.logging.PlatformLogger;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker = new Object();
    private static final HashMap<String, Class<?>> primClasses = new HashMap(8, 1.0f);
    private final BlockDataInputStream bin;
    private final ValidationList vlist;
    private long depth;
    private long totalObjectRefs;
    private boolean closed;
    private final HandleTable handles;
    private int passHandle = -1;
    private boolean defaultDataEnd = false;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableResolve;
    private SerialCallbackContext curContext;
    private ObjectInputFilter serialFilter;
    private volatile ObjectStreamClassValidator validator;

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
        JavaOISAccess javaOISAccess = new JavaOISAccess(){

            @Override
            public void setObjectInputFilter(ObjectInputStream stream, ObjectInputFilter filter) {
                stream.setInternalObjectInputFilter(filter);
            }

            @Override
            public ObjectInputFilter getObjectInputFilter(ObjectInputStream stream) {
                return stream.getInternalObjectInputFilter();
            }

            @Override
            public void checkArray(ObjectInputStream stream, Class<?> arrayType, int arrayLength) throws InvalidClassException {
                stream.checkArray(arrayType, arrayLength);
            }
        };
        SharedSecrets.setJavaOISAccess(javaOISAccess);
        SharedSecrets.setJavaObjectInputStreamAccess(ObjectInputStream::setValidator);
    }

    public ObjectInputStream(InputStream in) throws IOException {
        this.verifySubclass();
        this.bin = new BlockDataInputStream(in);
        this.handles = new HandleTable(10);
        this.vlist = new ValidationList();
        this.serialFilter = ObjectInputFilter.Config.getSerialFilter();
        this.enableOverride = false;
        this.readStreamHeader();
        this.bin.setBlockDataMode(true);
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bin = null;
        this.handles = null;
        this.vlist = null;
        this.serialFilter = ObjectInputFilter.Config.getSerialFilter();
        this.enableOverride = true;
    }

    @Override
    public final Object readObject() throws IOException, ClassNotFoundException {
        if (this.enableOverride) {
            return this.readObjectOverride();
        }
        int outerHandle = this.passHandle;
        try {
            Object obj = this.readObject0(false);
            this.handles.markDependency(outerHandle, this.passHandle);
            ClassNotFoundException ex = this.handles.lookupException(this.passHandle);
            if (ex != null) {
                throw ex;
            }
            if (this.depth == 0L) {
                this.vlist.doCallbacks();
            }
            Object object = obj;
            return object;
        }
        finally {
            this.passHandle = outerHandle;
            if (this.closed && this.depth == 0L) {
                this.clear();
            }
        }
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return null;
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        int outerHandle = this.passHandle;
        try {
            Object obj = this.readObject0(true);
            this.handles.markDependency(outerHandle, this.passHandle);
            ClassNotFoundException ex = this.handles.lookupException(this.passHandle);
            if (ex != null) {
                throw ex;
            }
            if (this.depth == 0L) {
                this.vlist.doCallbacks();
            }
            Object object = obj;
            return object;
        }
        finally {
            this.passHandle = outerHandle;
            if (this.closed && this.depth == 0L) {
                this.clear();
            }
        }
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        ClassNotFoundException ex;
        SerialCallbackContext ctx = this.curContext;
        if (ctx == null) {
            throw new NotActiveException("not in call to readObject");
        }
        Object curObj = ctx.getObj();
        ObjectStreamClass curDesc = ctx.getDesc();
        this.bin.setBlockDataMode(false);
        this.defaultReadFields(curObj, curDesc);
        this.bin.setBlockDataMode(true);
        if (!curDesc.hasWriteObjectData()) {
            this.defaultDataEnd = true;
        }
        if ((ex = this.handles.lookupException(this.passHandle)) != null) {
            throw ex;
        }
    }

    public GetField readFields() throws IOException, ClassNotFoundException {
        SerialCallbackContext ctx = this.curContext;
        if (ctx == null) {
            throw new NotActiveException("not in call to readObject");
        }
        Object curObj = ctx.getObj();
        ObjectStreamClass curDesc = ctx.getDesc();
        this.bin.setBlockDataMode(false);
        GetFieldImpl getField = new GetFieldImpl(curDesc);
        getField.readFields();
        this.bin.setBlockDataMode(true);
        if (!curDesc.hasWriteObjectData()) {
            this.defaultDataEnd = true;
        }
        return getField;
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        if (this.depth == 0L) {
            throw new NotActiveException("stream inactive");
        }
        this.vlist.register(obj, prio);
    }

    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        try {
            return Class.forName(name, false, ObjectInputStream.latestUserDefinedLoader());
        }
        catch (ClassNotFoundException ex) {
            Class<?> cl = primClasses.get(name);
            if (cl != null) {
                return cl;
            }
            throw ex;
        }
    }

    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader latestLoader = ObjectInputStream.latestUserDefinedLoader();
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            Class<?> cl = Class.forName(interfaces[i], false, latestLoader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i] = cl;
            ++i;
        }
        try {
            return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : latestLoader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable == this.enableResolve) {
            return enable;
        }
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableResolve = enable;
        return !this.enableResolve;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short s0 = this.bin.readShort();
        short s1 = this.bin.readShort();
        if (s0 != -21267 || s1 != 5) {
            throw new StreamCorruptedException(String.format("invalid stream header: %04X%04X", s0, s1));
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass desc = new ObjectStreamClass();
        desc.readNonProxy(this);
        return desc;
    }

    @Override
    public int read() throws IOException {
        return this.bin.read();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.bin.read(buf, off, len, false);
    }

    @Override
    public int available() throws IOException {
        return this.bin.available();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.depth == 0L) {
            this.clear();
        }
        this.bin.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.bin.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.bin.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.bin.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.bin.readChar();
    }

    @Override
    public short readShort() throws IOException {
        return this.bin.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.bin.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.bin.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.bin.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.bin.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.bin.readDouble();
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.bin.readFully(buf, 0, buf.length, false);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bin.readFully(buf, off, len, false);
    }

    @Override
    public int skipBytes(int len) throws IOException {
        return this.bin.skipBytes(len);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.bin.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.bin.readUTF();
    }

    private final ObjectInputFilter getInternalObjectInputFilter() {
        return this.serialFilter;
    }

    private final void setInternalObjectInputFilter(ObjectInputFilter filter) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SerializablePermission("serialFilter"));
        }
        if (this.serialFilter != null && this.serialFilter != ObjectInputFilter.Config.getSerialFilter()) {
            throw new IllegalStateException("filter can not be set more than once");
        }
        this.serialFilter = filter;
    }

    private void filterCheck(Class<?> clazz, int arrayLength) throws InvalidClassException {
        if (this.serialFilter != null) {
            ObjectInputFilter.Status status;
            RuntimeException ex = null;
            long bytesRead = this.bin == null ? 0L : this.bin.getBytesRead();
            try {
                status = this.serialFilter.checkInput(new FilterValues(clazz, arrayLength, this.totalObjectRefs, this.depth, bytesRead));
            }
            catch (RuntimeException e) {
                status = ObjectInputFilter.Status.REJECTED;
                ex = e;
            }
            if (status == null || status == ObjectInputFilter.Status.REJECTED) {
                if (Logging.infoLogger != null) {
                    Logging.infoLogger.info("ObjectInputFilter {0}: {1}, array length: {2}, nRefs: {3}, depth: {4}, bytes: {5}, ex: {6}", new Object[]{status, clazz, arrayLength, this.totalObjectRefs, this.depth, bytesRead, Objects.toString(ex, "n/a")});
                }
                InvalidClassException ice = new InvalidClassException("filter status: " + (Object)((Object)status));
                ice.initCause(ex);
                throw ice;
            }
            if (Logging.traceLogger != null) {
                Logging.traceLogger.finer("ObjectInputFilter {0}: {1}, array length: {2}, nRefs: {3}, depth: {4}, bytes: {5}, ex: {6}", new Object[]{status, clazz, arrayLength, this.totalObjectRefs, this.depth, bytesRead, Objects.toString(ex, "n/a")});
            }
        }
    }

    private void checkArray(Class<?> arrayType, int arrayLength) throws InvalidClassException {
        Objects.requireNonNull(arrayType);
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("not an array type");
        }
        if (arrayLength < 0) {
            throw new NegativeArraySizeException();
        }
        this.filterCheck(arrayType, arrayLength);
    }

    private void verifySubclass() {
        Class<?> cl = this.getClass();
        if (cl == ObjectInputStream.class) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        ObjectStreamClass.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        ObjectStreamClass.WeakClassKey key = new ObjectStreamClass.WeakClassKey(cl, Caches.subclassAuditsQueue);
        Boolean result = (Boolean)Caches.subclassAudits.get(key);
        if (result == null) {
            result = ObjectInputStream.auditSubclass(cl);
            Caches.subclassAudits.putIfAbsent(key, result);
        }
        if (result.booleanValue()) {
            return;
        }
        sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
    }

    private static boolean auditSubclass(final Class<?> subcl) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Class cl = subcl;
                while (cl != ObjectInputStream.class) {
                    try {
                        cl.getDeclaredMethod("readUnshared", null);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            cl.getDeclaredMethod("readFields", null);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            cl = cl.getSuperclass();
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return result;
    }

    private void clear() {
        this.handles.clear();
        this.vlist.clear();
    }

    /*
     * Exception decompiling
     */
    private Object readObject0(boolean unshared) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CASE]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object checkResolve(Object obj) throws IOException {
        if (!this.enableResolve || this.handles.lookupException(this.passHandle) != null) {
            return obj;
        }
        Object rep = this.resolveObject(obj);
        if (rep != obj) {
            if (rep != null) {
                if (rep.getClass().isArray()) {
                    this.filterCheck(rep.getClass(), Array.getLength(rep));
                } else {
                    this.filterCheck(rep.getClass(), -1);
                }
            }
            this.handles.setObject(this.passHandle, rep);
        }
        return rep;
    }

    String readTypeString() throws IOException {
        int oldHandle = this.passHandle;
        try {
            byte tc = this.bin.peekByte();
            switch (tc) {
                case 112: {
                    String string = (String)this.readNull();
                    return string;
                }
                case 113: {
                    String string = (String)this.readHandle(false);
                    return string;
                }
                case 116: 
                case 124: {
                    String string = this.readString(false);
                    return string;
                }
            }
            throw new StreamCorruptedException(String.format("invalid type code: %02X", tc));
        }
        finally {
            this.passHandle = oldHandle;
        }
    }

    private Object readNull() throws IOException {
        if (this.bin.readByte() != 112) {
            throw new InternalError();
        }
        this.passHandle = -1;
        return null;
    }

    private Object readHandle(boolean unshared) throws IOException {
        if (this.bin.readByte() != 113) {
            throw new InternalError();
        }
        this.passHandle = this.bin.readInt() - 0x7E0000;
        if (this.passHandle < 0 || this.passHandle >= this.handles.size()) {
            throw new StreamCorruptedException(String.format("invalid handle value: %08X", this.passHandle + 0x7E0000));
        }
        if (unshared) {
            throw new InvalidObjectException("cannot read back reference as unshared");
        }
        Object obj = this.handles.lookupObject(this.passHandle);
        if (obj == unsharedMarker) {
            throw new InvalidObjectException("cannot read back reference to unshared object");
        }
        this.filterCheck(null, -1);
        return obj;
    }

    private Class<?> readClass(boolean unshared) throws IOException {
        if (this.bin.readByte() != 118) {
            throw new InternalError();
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        Class<?> cl = desc.forClass();
        this.passHandle = this.handles.assign(unshared ? unsharedMarker : cl);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(this.passHandle, resolveEx);
        }
        this.handles.finish(this.passHandle);
        return cl;
    }

    private ObjectStreamClass readClassDesc(boolean unshared) throws IOException {
        ObjectStreamClass descriptor;
        byte tc = this.bin.peekByte();
        switch (tc) {
            case 112: {
                descriptor = (ObjectStreamClass)this.readNull();
                break;
            }
            case 113: {
                descriptor = (ObjectStreamClass)this.readHandle(unshared);
                break;
            }
            case 125: {
                descriptor = this.readProxyDesc(unshared);
                break;
            }
            case 114: {
                descriptor = this.readNonProxyDesc(unshared);
                break;
            }
            default: {
                throw new StreamCorruptedException(String.format("invalid type code: %02X", tc));
            }
        }
        if (descriptor != null) {
            this.validateDescriptor(descriptor);
        }
        return descriptor;
    }

    private boolean isCustomSubclass() {
        return this.getClass().getClassLoader() != ObjectInputStream.class.getClassLoader();
    }

    private ObjectStreamClass readProxyDesc(boolean unshared) throws IOException {
        if (this.bin.readByte() != 125) {
            throw new InternalError();
        }
        ObjectStreamClass desc = new ObjectStreamClass();
        int descHandle = this.handles.assign(unshared ? unsharedMarker : desc);
        this.passHandle = -1;
        int numIfaces = this.bin.readInt();
        if (numIfaces > 65535) {
            throw new InvalidObjectException("interface limit exceeded: " + numIfaces);
        }
        String[] ifaces = new String[numIfaces];
        int i = 0;
        while (i < numIfaces) {
            ifaces[i] = this.bin.readUTF();
            ++i;
        }
        Class<?> cl = null;
        ClassNotFoundException resolveEx = null;
        this.bin.setBlockDataMode(true);
        try {
            cl = this.resolveProxyClass(ifaces);
            if (cl == null) {
                resolveEx = new ClassNotFoundException("null class");
            } else {
                if (!Proxy.isProxyClass(cl)) {
                    throw new InvalidClassException("Not a proxy");
                }
                ReflectUtil.checkProxyPackageAccess(this.getClass().getClassLoader(), cl.getInterfaces());
                Class<?>[] classArray = cl.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> clazz = classArray[n2];
                    this.filterCheck(clazz, -1);
                    ++n2;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            resolveEx = ex;
        }
        this.filterCheck(cl, -1);
        this.skipCustomData();
        try {
            ++this.totalObjectRefs;
            ++this.depth;
            desc.initProxy(cl, resolveEx, this.readClassDesc(false));
        }
        finally {
            --this.depth;
        }
        this.handles.finish(descHandle);
        this.passHandle = descHandle;
        return desc;
    }

    private ObjectStreamClass readNonProxyDesc(boolean unshared) throws IOException {
        if (this.bin.readByte() != 114) {
            throw new InternalError();
        }
        ObjectStreamClass desc = new ObjectStreamClass();
        int descHandle = this.handles.assign(unshared ? unsharedMarker : desc);
        this.passHandle = -1;
        ObjectStreamClass readDesc = null;
        try {
            readDesc = this.readClassDescriptor();
        }
        catch (ClassNotFoundException ex) {
            throw (IOException)new InvalidClassException("failed to read class descriptor").initCause(ex);
        }
        Class<?> cl = null;
        ClassNotFoundException resolveEx = null;
        this.bin.setBlockDataMode(true);
        boolean checksRequired = this.isCustomSubclass();
        try {
            cl = this.resolveClass(readDesc);
            if (cl == null) {
                resolveEx = new ClassNotFoundException("null class");
            } else if (checksRequired) {
                ReflectUtil.checkPackageAccess(cl);
            }
        }
        catch (ClassNotFoundException ex) {
            resolveEx = ex;
        }
        this.filterCheck(cl, -1);
        this.skipCustomData();
        try {
            ++this.totalObjectRefs;
            ++this.depth;
            desc.initNonProxy(readDesc, cl, resolveEx, this.readClassDesc(false));
        }
        finally {
            --this.depth;
        }
        this.handles.finish(descHandle);
        this.passHandle = descHandle;
        return desc;
    }

    private String readString(boolean unshared) throws IOException {
        String str;
        byte tc = this.bin.readByte();
        switch (tc) {
            case 116: {
                str = this.bin.readUTF();
                break;
            }
            case 124: {
                str = this.bin.readLongUTF();
                break;
            }
            default: {
                throw new StreamCorruptedException(String.format("invalid type code: %02X", tc));
            }
        }
        this.passHandle = this.handles.assign(unshared ? unsharedMarker : str);
        this.handles.finish(this.passHandle);
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readArray(boolean unshared) throws IOException {
        if (Boolean.getBoolean("object.input.stream.read.array.log")) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".readArray(" + unshared + ")");
        }
        if (this.bin.readByte() != 117) {
            throw new InternalError();
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        int len = this.bin.readInt();
        this.filterCheck(desc.forClass(), len);
        Object array = null;
        Class<?> ccl = null;
        Class<?> cl = desc.forClass();
        if (cl != null) {
            ccl = cl.getComponentType();
            array = Array.newInstance(ccl, len);
        }
        int arrayHandle = this.handles.assign(unshared ? unsharedMarker : array);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(arrayHandle, resolveEx);
        }
        if (ccl == null) {
            int i = 0;
            while (i < len) {
                this.readObject0(false);
                ++i;
            }
        } else if (ccl.isPrimitive()) {
            if (ccl == Integer.TYPE) {
                this.bin.readInts((int[])array, 0, len);
            } else if (ccl == Byte.TYPE) {
                this.bin.readFully((byte[])array, 0, len, true);
            } else if (ccl == Long.TYPE) {
                this.bin.readLongs((long[])array, 0, len);
            } else if (ccl == Float.TYPE) {
                this.bin.readFloats((float[])array, 0, len);
            } else if (ccl == Double.TYPE) {
                this.bin.readDoubles((double[])array, 0, len);
            } else if (ccl == Short.TYPE) {
                this.bin.readShorts((short[])array, 0, len);
            } else if (ccl == Character.TYPE) {
                this.bin.readChars((char[])array, 0, len);
            } else {
                if (ccl != Boolean.TYPE) throw new InternalError();
                this.bin.readBooleans((boolean[])array, 0, len);
            }
        } else {
            Object[] oa = (Object[])array;
            int i = 0;
            while (i < len) {
                oa[i] = this.readObject0(false);
                this.handles.markDependency(arrayHandle, this.passHandle);
                ++i;
            }
        }
        this.handles.finish(arrayHandle);
        this.passHandle = arrayHandle;
        return array;
    }

    private Enum<?> readEnum(boolean unshared) throws IOException {
        if (this.bin.readByte() != 126) {
            throw new InternalError();
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        if (!desc.isEnum()) {
            throw new InvalidClassException("non-enum class: " + desc);
        }
        int enumHandle = this.handles.assign(unshared ? unsharedMarker : null);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(enumHandle, resolveEx);
        }
        String name = this.readString(false);
        Enum<?> result = null;
        Class<?> cl = desc.forClass();
        if (cl != null) {
            try {
                Object en = Enum.valueOf(cl, name);
                result = (Enum<?>)en;
            }
            catch (IllegalArgumentException ex) {
                throw (IOException)new InvalidObjectException("enum constant " + name + " does not exist in " + cl).initCause(ex);
            }
            if (!unshared) {
                this.handles.setObject(enumHandle, result);
            }
        }
        this.handles.finish(enumHandle);
        this.passHandle = enumHandle;
        return result;
    }

    private Object readOrdinaryObject(boolean unshared) throws IOException {
        Object obj;
        if (this.bin.readByte() != 115) {
            throw new InternalError();
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        desc.checkDeserialize();
        Class<?> cl = desc.forClass();
        if (cl == String.class || cl == Class.class || cl == ObjectStreamClass.class) {
            throw new InvalidClassException("invalid class descriptor");
        }
        try {
            obj = desc.isInstantiable() ? desc.newInstance() : null;
        }
        catch (Exception ex) {
            throw (IOException)new InvalidClassException(desc.forClass().getName(), "unable to create instance").initCause(ex);
        }
        this.passHandle = this.handles.assign(unshared ? unsharedMarker : obj);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(this.passHandle, resolveEx);
        }
        if (desc.isExternalizable()) {
            this.readExternalData((Externalizable)obj, desc);
        } else {
            this.readSerialData(obj, desc);
        }
        this.handles.finish(this.passHandle);
        if (obj != null && this.handles.lookupException(this.passHandle) == null && desc.hasReadResolveMethod()) {
            Object rep = desc.invokeReadResolve(obj);
            if (unshared && rep.getClass().isArray()) {
                rep = ObjectInputStream.cloneArray(rep);
            }
            if (rep != obj) {
                if (rep != null) {
                    if (rep.getClass().isArray()) {
                        this.filterCheck(rep.getClass(), Array.getLength(rep));
                    } else {
                        this.filterCheck(rep.getClass(), -1);
                    }
                }
                obj = rep;
                this.handles.setObject(this.passHandle, obj);
            }
        }
        return obj;
    }

    private void readExternalData(Externalizable obj, ObjectStreamClass desc) throws IOException {
        SerialCallbackContext oldContext = this.curContext;
        if (oldContext != null) {
            oldContext.check();
        }
        this.curContext = null;
        try {
            boolean blocked = desc.hasBlockExternalData();
            if (blocked) {
                this.bin.setBlockDataMode(true);
            }
            if (obj != null) {
                try {
                    obj.readExternal(this);
                }
                catch (ClassNotFoundException ex) {
                    this.handles.markException(this.passHandle, ex);
                }
            }
            if (blocked) {
                this.skipCustomData();
            }
        }
        finally {
            if (oldContext != null) {
                oldContext.check();
            }
            this.curContext = oldContext;
        }
    }

    private void readSerialData(Object obj, ObjectStreamClass desc) throws IOException {
        ObjectStreamClass.ClassDataSlot[] slots = desc.getClassDataLayout();
        int i = 0;
        while (i < slots.length) {
            ObjectStreamClass slotDesc = slots[i].desc;
            if (slots[i].hasData) {
                if (obj == null || this.handles.lookupException(this.passHandle) != null) {
                    this.defaultReadFields(null, slotDesc);
                } else if (slotDesc.hasReadObjectMethod()) {
                    block31: {
                        ThreadDeath t = null;
                        boolean reset = false;
                        SerialCallbackContext oldContext = this.curContext;
                        if (oldContext != null) {
                            oldContext.check();
                        }
                        try {
                            try {
                                this.curContext = new SerialCallbackContext(obj, slotDesc);
                                this.bin.setBlockDataMode(true);
                                slotDesc.invokeReadObject(obj, this);
                            }
                            catch (ClassNotFoundException ex) {
                                this.handles.markException(this.passHandle, ex);
                                do {
                                    try {
                                        this.curContext.setUsed();
                                        if (oldContext != null) {
                                            oldContext.check();
                                        }
                                        this.curContext = oldContext;
                                        reset = true;
                                    }
                                    catch (ThreadDeath x) {
                                        t = x;
                                    }
                                } while (!reset);
                                if (t != null) {
                                    throw t;
                                }
                                break block31;
                            }
                        }
                        catch (Throwable throwable) {
                            do {
                                try {
                                    this.curContext.setUsed();
                                    if (oldContext != null) {
                                        oldContext.check();
                                    }
                                    this.curContext = oldContext;
                                    reset = true;
                                }
                                catch (ThreadDeath x) {
                                    t = x;
                                }
                            } while (!reset);
                            if (t != null) {
                                throw t;
                            }
                            throw throwable;
                        }
                        do {
                            try {
                                this.curContext.setUsed();
                                if (oldContext != null) {
                                    oldContext.check();
                                }
                                this.curContext = oldContext;
                                reset = true;
                            }
                            catch (ThreadDeath x) {
                                t = x;
                            }
                        } while (!reset);
                        if (t != null) {
                            throw t;
                        }
                    }
                    this.defaultDataEnd = false;
                } else {
                    this.defaultReadFields(obj, slotDesc);
                }
                if (slotDesc.hasWriteObjectData()) {
                    this.skipCustomData();
                } else {
                    this.bin.setBlockDataMode(false);
                }
            } else if (obj != null && slotDesc.hasReadObjectNoDataMethod() && this.handles.lookupException(this.passHandle) == null) {
                slotDesc.invokeReadObjectNoData(obj);
            }
            ++i;
        }
    }

    private void skipCustomData() throws IOException {
        int oldHandle = this.passHandle;
        block4: while (true) {
            if (this.bin.getBlockDataMode()) {
                this.bin.skipBlockData();
                this.bin.setBlockDataMode(false);
            }
            switch (this.bin.peekByte()) {
                case 119: 
                case 122: {
                    this.bin.setBlockDataMode(true);
                    continue block4;
                }
                case 120: {
                    this.bin.readByte();
                    this.passHandle = oldHandle;
                    return;
                }
            }
            this.readObject0(false);
        }
    }

    private void defaultReadFields(Object obj, ObjectStreamClass desc) throws IOException {
        Class<?> cl = desc.forClass();
        if (cl != null && obj != null && !cl.isInstance(obj)) {
            throw new ClassCastException();
        }
        int primDataSize = desc.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < primDataSize) {
            this.primVals = new byte[primDataSize];
        }
        this.bin.readFully(this.primVals, 0, primDataSize, false);
        if (obj != null) {
            desc.setPrimFieldValues(obj, this.primVals);
        }
        int objHandle = this.passHandle;
        ObjectStreamField[] fields = desc.getFields(false);
        Object[] objVals = new Object[desc.getNumObjFields()];
        int numPrimFields = fields.length - objVals.length;
        int i = 0;
        while (i < objVals.length) {
            ObjectStreamField f = fields[numPrimFields + i];
            objVals[i] = this.readObject0(f.isUnshared());
            if (f.getField() != null) {
                this.handles.markDependency(objHandle, this.passHandle);
            }
            ++i;
        }
        if (obj != null) {
            desc.setObjFieldValues(obj, objVals);
        }
        this.passHandle = objHandle;
    }

    private IOException readFatalException() throws IOException {
        if (this.bin.readByte() != 123) {
            throw new InternalError();
        }
        this.clear();
        return (IOException)this.readObject0(false);
    }

    private void handleReset() throws StreamCorruptedException {
        if (this.depth > 0L) {
            throw new StreamCorruptedException("unexpected reset; recursion depth: " + this.depth);
        }
        this.clear();
    }

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    private static ClassLoader latestUserDefinedLoader() {
        return VM.latestUserDefinedLoader();
    }

    private static Object cloneArray(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).clone();
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).clone();
        }
        if (array instanceof byte[]) {
            return ((byte[])array).clone();
        }
        if (array instanceof char[]) {
            return ((char[])array).clone();
        }
        if (array instanceof double[]) {
            return ((double[])array).clone();
        }
        if (array instanceof float[]) {
            return ((float[])array).clone();
        }
        if (array instanceof int[]) {
            return ((int[])array).clone();
        }
        if (array instanceof long[]) {
            return ((long[])array).clone();
        }
        if (array instanceof short[]) {
            return ((short[])array).clone();
        }
        throw new AssertionError();
    }

    private void validateDescriptor(ObjectStreamClass descriptor) {
        ObjectStreamClassValidator validating = this.validator;
        if (validating != null) {
            validating.validateDescriptor(descriptor);
        }
    }

    private static void setValidator(ObjectInputStream ois, ObjectStreamClassValidator validator) {
        ois.validator = validator;
    }

    private class BlockDataInputStream
    extends InputStream
    implements DataInput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private static final int HEADER_BLOCKED = -2;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private int end = -1;
        private int unread = 0;
        private final PeekInputStream in;
        private final DataInputStream din;

        BlockDataInputStream(InputStream in) {
            this.in = new PeekInputStream(in);
            this.din = new DataInputStream(this);
        }

        boolean setBlockDataMode(boolean newmode) throws IOException {
            if (this.blkmode == newmode) {
                return this.blkmode;
            }
            if (newmode) {
                this.pos = 0;
                this.end = 0;
                this.unread = 0;
            } else if (this.pos < this.end) {
                throw new IllegalStateException("unread block data");
            }
            this.blkmode = newmode;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        /*
         * Unable to fully structure code
         */
        void skipBlockData() throws IOException {
            if (this.blkmode) ** GOTO lbl4
            throw new IllegalStateException("not in block data mode");
lbl-1000:
            // 1 sources

            {
                this.refill();
lbl4:
                // 2 sources

                ** while (this.end >= 0)
            }
lbl5:
            // 1 sources

        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int readBlockHeader(boolean canBlock) throws IOException {
            if (ObjectInputStream.this.defaultDataEnd) {
                return -1;
            }
            try {
                int tc;
                block7: while (true) {
                    int avail;
                    int n = avail = canBlock ? Integer.MAX_VALUE : this.in.available();
                    if (avail == 0) {
                        return -2;
                    }
                    tc = this.in.peek();
                    switch (tc) {
                        case 119: {
                            if (avail < 2) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 2);
                            return this.hbuf[1] & 0xFF;
                        }
                        case 122: {
                            if (avail < 5) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 5);
                            int len = Bits.getInt(this.hbuf, 1);
                            if (len < 0) {
                                throw new StreamCorruptedException("illegal block data header length: " + len);
                            }
                            return len;
                        }
                        case 121: {
                            this.in.read();
                            ObjectInputStream.this.handleReset();
                            continue block7;
                        }
                    }
                    break;
                }
                if (tc >= 0 && (tc < 112 || tc > 126)) {
                    throw new StreamCorruptedException(String.format("invalid type code: %02X", tc));
                }
                return -1;
            }
            catch (EOFException ex) {
                throw new StreamCorruptedException("unexpected EOF while reading block data header");
            }
        }

        private void refill() throws IOException {
            try {
                do {
                    int n;
                    this.pos = 0;
                    if (this.unread > 0) {
                        n = this.in.read(this.buf, 0, Math.min(this.unread, 1024));
                        if (n >= 0) {
                            this.end = n;
                            this.unread -= n;
                            continue;
                        }
                        throw new StreamCorruptedException("unexpected EOF in middle of data block");
                    }
                    n = this.readBlockHeader(true);
                    if (n >= 0) {
                        this.end = 0;
                        this.unread = n;
                        continue;
                    }
                    this.end = -1;
                    this.unread = 0;
                } while (this.pos == this.end);
            }
            catch (IOException ex) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
                throw ex;
            }
        }

        int currentBlockRemaining() {
            if (this.blkmode) {
                return this.end >= 0 ? this.end - this.pos + this.unread : 0;
            }
            throw new IllegalStateException();
        }

        int peek() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos] & 0xFF : -1;
            }
            return this.in.peek();
        }

        byte peekByte() throws IOException {
            int val = this.peek();
            if (val < 0) {
                throw new EOFException();
            }
            return (byte)val;
        }

        @Override
        public int read() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos++] & 0xFF : -1;
            }
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.read(b, off, len, false);
        }

        @Override
        public long skip(long len) throws IOException {
            long remain = len;
            while (remain > 0L) {
                int nread;
                if (this.blkmode) {
                    if (this.pos == this.end) {
                        this.refill();
                    }
                    if (this.end < 0) break;
                    nread = (int)Math.min(remain, (long)(this.end - this.pos));
                    remain -= (long)nread;
                    this.pos += nread;
                    continue;
                }
                nread = (int)Math.min(remain, 1024L);
                if ((nread = this.in.read(this.buf, 0, nread)) < 0) break;
                remain -= (long)nread;
            }
            return len - remain;
        }

        @Override
        public int available() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end && this.unread == 0) {
                    int n;
                    while ((n = this.readBlockHeader(false)) == 0) {
                    }
                    switch (n) {
                        case -2: {
                            break;
                        }
                        case -1: {
                            this.pos = 0;
                            this.end = -1;
                            break;
                        }
                        default: {
                            this.pos = 0;
                            this.end = 0;
                            this.unread = n;
                        }
                    }
                }
                int unreadAvail = this.unread > 0 ? Math.min(this.in.available(), this.unread) : 0;
                return this.end >= 0 ? this.end - this.pos + unreadAvail : 0;
            }
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            if (this.blkmode) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
            }
            this.in.close();
        }

        int read(byte[] b, int off, int len, boolean copy) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                if (this.end < 0) {
                    return -1;
                }
                int nread = Math.min(len, this.end - this.pos);
                System.arraycopy(this.buf, this.pos, b, off, nread);
                this.pos += nread;
                return nread;
            }
            if (copy) {
                int nread = this.in.read(this.buf, 0, Math.min(len, 1024));
                if (nread > 0) {
                    System.arraycopy(this.buf, 0, b, off, nread);
                }
                return nread;
            }
            return this.in.read(b, off, len);
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length, false);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.readFully(b, off, len, false);
        }

        public void readFully(byte[] b, int off, int len, boolean copy) throws IOException {
            while (len > 0) {
                int n = this.read(b, off, len, copy);
                if (n < 0) {
                    throw new EOFException();
                }
                off += n;
                len -= n;
            }
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return this.din.skipBytes(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            int v = this.read();
            if (v < 0) {
                throw new EOFException();
            }
            return v != 0;
        }

        @Override
        public byte readByte() throws IOException {
            int v = this.read();
            if (v < 0) {
                throw new EOFException();
            }
            return (byte)v;
        }

        @Override
        public int readUnsignedByte() throws IOException {
            int v = this.read();
            if (v < 0) {
                throw new EOFException();
            }
            return v;
        }

        @Override
        public char readChar() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readChar();
            }
            char v = Bits.getChar(this.buf, this.pos);
            this.pos += 2;
            return v;
        }

        @Override
        public short readShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readShort();
            }
            short v = Bits.getShort(this.buf, this.pos);
            this.pos += 2;
            return v;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readUnsignedShort();
            }
            int v = Bits.getShort(this.buf, this.pos) & 0xFFFF;
            this.pos += 2;
            return v;
        }

        @Override
        public int readInt() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readInt();
            }
            int v = Bits.getInt(this.buf, this.pos);
            this.pos += 4;
            return v;
        }

        @Override
        public float readFloat() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readFloat();
            }
            float v = Bits.getFloat(this.buf, this.pos);
            this.pos += 4;
            return v;
        }

        @Override
        public long readLong() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readLong();
            }
            long v = Bits.getLong(this.buf, this.pos);
            this.pos += 8;
            return v;
        }

        @Override
        public double readDouble() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readDouble();
            }
            double v = Bits.getDouble(this.buf, this.pos);
            this.pos += 8;
            return v;
        }

        @Override
        public String readUTF() throws IOException {
            return this.readUTFBody(this.readUnsignedShort());
        }

        @Override
        public String readLine() throws IOException {
            return this.din.readLine();
        }

        void readBooleans(boolean[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 1024);
                    this.in.readFully(this.buf, 0, span);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 1) {
                        v[off++] = this.din.readBoolean();
                        continue;
                    }
                    stop = Math.min(endoff, off + this.end - this.pos);
                }
                while (off < stop) {
                    v[off++] = Bits.getBoolean(this.buf, this.pos++);
                }
            }
        }

        void readChars(char[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 512);
                    this.in.readFully(this.buf, 0, span << 1);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        v[off++] = this.din.readChar();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 1));
                }
                while (off < stop) {
                    v[off++] = Bits.getChar(this.buf, this.pos);
                    this.pos += 2;
                }
            }
        }

        void readShorts(short[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 512);
                    this.in.readFully(this.buf, 0, span << 1);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        v[off++] = this.din.readShort();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 1));
                }
                while (off < stop) {
                    v[off++] = Bits.getShort(this.buf, this.pos);
                    this.pos += 2;
                }
            }
        }

        void readInts(int[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 256);
                    this.in.readFully(this.buf, 0, span << 2);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        v[off++] = this.din.readInt();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 2));
                }
                while (off < stop) {
                    v[off++] = Bits.getInt(this.buf, this.pos);
                    this.pos += 4;
                }
            }
        }

        void readFloats(float[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int span;
                if (!this.blkmode) {
                    span = Math.min(endoff - off, 256);
                    this.in.readFully(this.buf, 0, span << 2);
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        v[off++] = this.din.readFloat();
                        continue;
                    }
                    span = Math.min(endoff - off, this.end - this.pos >> 2);
                }
                ObjectInputStream.bytesToFloats(this.buf, this.pos, v, off, span);
                off += span;
                this.pos += span << 2;
            }
        }

        void readLongs(long[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 128);
                    this.in.readFully(this.buf, 0, span << 3);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        v[off++] = this.din.readLong();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 3));
                }
                while (off < stop) {
                    v[off++] = Bits.getLong(this.buf, this.pos);
                    this.pos += 8;
                }
            }
        }

        void readDoubles(double[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int span;
                if (!this.blkmode) {
                    span = Math.min(endoff - off, 128);
                    this.in.readFully(this.buf, 0, span << 3);
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        v[off++] = this.din.readDouble();
                        continue;
                    }
                    span = Math.min(endoff - off, this.end - this.pos >> 3);
                }
                ObjectInputStream.bytesToDoubles(this.buf, this.pos, v, off, span);
                off += span;
                this.pos += span << 3;
            }
        }

        String readLongUTF() throws IOException {
            return this.readUTFBody(this.readLong());
        }

        private String readUTFBody(long utflen) throws IOException {
            StringBuilder sbuf = new StringBuilder();
            if (!this.blkmode) {
                this.pos = 0;
                this.end = 0;
            }
            while (utflen > 0L) {
                int avail = this.end - this.pos;
                if (avail >= 3 || (long)avail == utflen) {
                    utflen -= this.readUTFSpan(sbuf, utflen);
                    continue;
                }
                if (this.blkmode) {
                    utflen -= (long)this.readUTFChar(sbuf, utflen);
                    continue;
                }
                if (avail > 0) {
                    System.arraycopy(this.buf, this.pos, this.buf, 0, avail);
                }
                this.pos = 0;
                this.end = (int)Math.min(1024L, utflen);
                this.in.readFully(this.buf, avail, this.end - avail);
            }
            return sbuf.toString();
        }

        private long readUTFSpan(StringBuilder sbuf, long utflen) throws IOException {
            int start;
            int cpos;
            block16: {
                cpos = 0;
                start = this.pos;
                int avail = Math.min(this.end - this.pos, 256);
                int stop = this.pos + (utflen > (long)avail ? avail - 2 : (int)utflen);
                boolean outOfBounds = false;
                try {
                    try {
                        while (this.pos < stop) {
                            int b1 = this.buf[this.pos++] & 0xFF;
                            switch (b1 >> 4) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    this.cbuf[cpos++] = (char)b1;
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    byte b2 = this.buf[this.pos++];
                                    if ((b2 & 0xC0) != 128) {
                                        throw new UTFDataFormatException();
                                    }
                                    this.cbuf[cpos++] = (char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0);
                                    break;
                                }
                                case 14: {
                                    byte b3 = this.buf[this.pos + 1];
                                    byte b2 = this.buf[this.pos + 0];
                                    this.pos += 2;
                                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                                        throw new UTFDataFormatException();
                                    }
                                    this.cbuf[cpos++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0);
                                    break;
                                }
                                default: {
                                    throw new UTFDataFormatException();
                                }
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        outOfBounds = true;
                        if (outOfBounds || (long)(this.pos - start) > utflen) {
                            this.pos = start + (int)utflen;
                            throw new UTFDataFormatException();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (outOfBounds || (long)(this.pos - start) > utflen) {
                        this.pos = start + (int)utflen;
                        throw new UTFDataFormatException();
                    }
                    throw throwable;
                }
                if (outOfBounds || (long)(this.pos - start) > utflen) {
                    this.pos = start + (int)utflen;
                    throw new UTFDataFormatException();
                }
            }
            sbuf.append(this.cbuf, 0, cpos);
            return this.pos - start;
        }

        private int readUTFChar(StringBuilder sbuf, long utflen) throws IOException {
            int b1 = this.readByte() & 0xFF;
            switch (b1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    sbuf.append((char)b1);
                    return 1;
                }
                case 12: 
                case 13: {
                    if (utflen < 2L) {
                        throw new UTFDataFormatException();
                    }
                    byte b2 = this.readByte();
                    if ((b2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    sbuf.append((char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0));
                    return 2;
                }
                case 14: {
                    if (utflen < 3L) {
                        if (utflen == 2L) {
                            this.readByte();
                        }
                        throw new UTFDataFormatException();
                    }
                    byte b2 = this.readByte();
                    byte b3 = this.readByte();
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    sbuf.append((char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0));
                    return 3;
                }
            }
            throw new UTFDataFormatException();
        }

        long getBytesRead() {
            return this.in.getBytesRead();
        }
    }

    private static class Caches {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<ObjectStreamClass.WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }
    }

    static class FilterValues
    implements ObjectInputFilter.FilterInfo {
        final Class<?> clazz;
        final long arrayLength;
        final long totalObjectRefs;
        final long depth;
        final long streamBytes;

        public FilterValues(Class<?> clazz, long arrayLength, long totalObjectRefs, long depth, long streamBytes) {
            this.clazz = clazz;
            this.arrayLength = arrayLength;
            this.totalObjectRefs = totalObjectRefs;
            this.depth = depth;
            this.streamBytes = streamBytes;
        }

        @Override
        public Class<?> serialClass() {
            return this.clazz;
        }

        @Override
        public long arrayLength() {
            return this.arrayLength;
        }

        @Override
        public long references() {
            return this.totalObjectRefs;
        }

        @Override
        public long depth() {
            return this.depth;
        }

        @Override
        public long streamBytes() {
            return this.streamBytes;
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException;

        public abstract boolean get(String var1, boolean var2) throws IOException;

        public abstract byte get(String var1, byte var2) throws IOException;

        public abstract char get(String var1, char var2) throws IOException;

        public abstract short get(String var1, short var2) throws IOException;

        public abstract int get(String var1, int var2) throws IOException;

        public abstract long get(String var1, long var2) throws IOException;

        public abstract float get(String var1, float var2) throws IOException;

        public abstract double get(String var1, double var2) throws IOException;

        public abstract Object get(String var1, Object var2) throws IOException;
    }

    private class GetFieldImpl
    extends GetField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;
        private final int[] objHandles;

        GetFieldImpl(ObjectStreamClass desc) {
            this.desc = desc;
            this.primVals = new byte[desc.getPrimDataSize()];
            this.objVals = new Object[desc.getNumObjFields()];
            this.objHandles = new int[this.objVals.length];
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return this.desc;
        }

        @Override
        public boolean defaulted(String name) throws IOException {
            return this.getFieldOffset(name, null) < 0;
        }

        @Override
        public boolean get(String name, boolean val) throws IOException {
            int off = this.getFieldOffset(name, Boolean.TYPE);
            return off >= 0 ? Bits.getBoolean(this.primVals, off) : val;
        }

        @Override
        public byte get(String name, byte val) throws IOException {
            int off = this.getFieldOffset(name, Byte.TYPE);
            return off >= 0 ? this.primVals[off] : val;
        }

        @Override
        public char get(String name, char val) throws IOException {
            int off = this.getFieldOffset(name, Character.TYPE);
            return off >= 0 ? Bits.getChar(this.primVals, off) : val;
        }

        @Override
        public short get(String name, short val) throws IOException {
            int off = this.getFieldOffset(name, Short.TYPE);
            return off >= 0 ? Bits.getShort(this.primVals, off) : val;
        }

        @Override
        public int get(String name, int val) throws IOException {
            int off = this.getFieldOffset(name, Integer.TYPE);
            return off >= 0 ? Bits.getInt(this.primVals, off) : val;
        }

        @Override
        public float get(String name, float val) throws IOException {
            int off = this.getFieldOffset(name, Float.TYPE);
            return off >= 0 ? Bits.getFloat(this.primVals, off) : val;
        }

        @Override
        public long get(String name, long val) throws IOException {
            int off = this.getFieldOffset(name, Long.TYPE);
            return off >= 0 ? Bits.getLong(this.primVals, off) : val;
        }

        @Override
        public double get(String name, double val) throws IOException {
            int off = this.getFieldOffset(name, Double.TYPE);
            return off >= 0 ? Bits.getDouble(this.primVals, off) : val;
        }

        @Override
        public Object get(String name, Object val) throws IOException {
            int off = this.getFieldOffset(name, Object.class);
            if (off >= 0) {
                int objHandle = this.objHandles[off];
                ObjectInputStream.this.handles.markDependency(ObjectInputStream.this.passHandle, objHandle);
                return ObjectInputStream.this.handles.lookupException(objHandle) == null ? this.objVals[off] : null;
            }
            return val;
        }

        void readFields() throws IOException {
            ObjectInputStream.this.bin.readFully(this.primVals, 0, this.primVals.length, false);
            int oldHandle = ObjectInputStream.this.passHandle;
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            int i = 0;
            while (i < this.objVals.length) {
                this.objVals[i] = ObjectInputStream.this.readObject0(fields[numPrimFields + i].isUnshared());
                this.objHandles[i] = ObjectInputStream.this.passHandle;
                ++i;
            }
            ObjectInputStream.this.passHandle = oldHandle;
        }

        private int getFieldOffset(String name, Class<?> type) {
            ObjectStreamField field = this.desc.getField(name, type);
            if (field != null) {
                return field.getOffset();
            }
            if (this.desc.getLocalDesc().getField(name, type) != null) {
                return -1;
            }
            throw new IllegalArgumentException("no such field " + name + " with type " + type);
        }
    }

    private static class HandleTable {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep = -1;
        int size = 0;

        HandleTable(int initialCapacity) {
            this.status = new byte[initialCapacity];
            this.entries = new Object[initialCapacity];
            this.deps = new HandleList[initialCapacity];
        }

        int assign(Object obj) {
            if (this.size >= this.entries.length) {
                this.grow();
            }
            this.status[this.size] = 2;
            this.entries[this.size] = obj;
            return this.size++;
        }

        void markDependency(int dependent, int target) {
            if (dependent == -1 || target == -1) {
                return;
            }
            block0 : switch (this.status[dependent]) {
                case 2: {
                    switch (this.status[target]) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            this.markException(dependent, (ClassNotFoundException)this.entries[target]);
                            break block0;
                        }
                        case 2: {
                            if (this.deps[target] == null) {
                                this.deps[target] = new HandleList();
                            }
                            this.deps[target].add(dependent);
                            if (this.lowDep >= 0 && this.lowDep <= target) break block0;
                            this.lowDep = target;
                            break block0;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void markException(int handle, ClassNotFoundException ex) {
            switch (this.status[handle]) {
                case 2: {
                    this.status[handle] = 3;
                    this.entries[handle] = ex;
                    HandleList dlist = this.deps[handle];
                    if (dlist == null) break;
                    int ndeps = dlist.size();
                    int i = 0;
                    while (i < ndeps) {
                        this.markException(dlist.get(i), ex);
                        ++i;
                    }
                    this.deps[handle] = null;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void finish(int handle) {
            int end;
            if (this.lowDep < 0) {
                end = handle + 1;
            } else if (this.lowDep >= handle) {
                end = this.size;
                this.lowDep = -1;
            } else {
                return;
            }
            int i = handle;
            while (i < end) {
                switch (this.status[i]) {
                    case 2: {
                        this.status[i] = 1;
                        this.deps[i] = null;
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                ++i;
            }
        }

        void setObject(int handle, Object obj) {
            switch (this.status[handle]) {
                case 1: 
                case 2: {
                    this.entries[handle] = obj;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        Object lookupObject(int handle) {
            return handle != -1 && this.status[handle] != 3 ? this.entries[handle] : null;
        }

        ClassNotFoundException lookupException(int handle) {
            return handle != -1 && this.status[handle] == 3 ? (ClassNotFoundException)this.entries[handle] : null;
        }

        void clear() {
            Arrays.fill(this.status, 0, this.size, (byte)0);
            Arrays.fill(this.entries, 0, this.size, null);
            Arrays.fill(this.deps, 0, this.size, null);
            this.lowDep = -1;
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void grow() {
            int newCapacity = (this.entries.length << 1) + 1;
            byte[] newStatus = new byte[newCapacity];
            Object[] newEntries = new Object[newCapacity];
            HandleList[] newDeps = new HandleList[newCapacity];
            System.arraycopy(this.status, 0, newStatus, 0, this.size);
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            System.arraycopy(this.deps, 0, newDeps, 0, this.size);
            this.status = newStatus;
            this.entries = newEntries;
            this.deps = newDeps;
        }

        private static class HandleList {
            private int[] list = new int[4];
            private int size = 0;

            public void add(int handle) {
                if (this.size >= this.list.length) {
                    int[] newList = new int[this.list.length << 1];
                    System.arraycopy(this.list, 0, newList, 0, this.list.length);
                    this.list = newList;
                }
                this.list[this.size++] = handle;
            }

            public int get(int index) {
                if (index >= this.size) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.list[index];
            }

            public int size() {
                return this.size;
            }
        }
    }

    private static class Logging {
        private static final PlatformLogger traceLogger;
        private static final PlatformLogger infoLogger;

        static {
            PlatformLogger filterLog = PlatformLogger.getLogger("java.io.serialization");
            infoLogger = filterLog != null && filterLog.isLoggable(PlatformLogger.Level.INFO) ? filterLog : null;
            traceLogger = filterLog != null && filterLog.isLoggable(PlatformLogger.Level.FINER) ? filterLog : null;
        }

        private Logging() {
        }
    }

    private static class PeekInputStream
    extends InputStream {
        private final InputStream in;
        private int peekb = -1;
        private long totalBytesRead = 0L;

        PeekInputStream(InputStream in) {
            this.in = in;
        }

        int peek() throws IOException {
            if (this.peekb >= 0) {
                return this.peekb;
            }
            this.peekb = this.in.read();
            this.totalBytesRead += (long)(this.peekb >= 0 ? 1 : 0);
            return this.peekb;
        }

        @Override
        public int read() throws IOException {
            if (this.peekb >= 0) {
                int v = this.peekb;
                this.peekb = -1;
                return v;
            }
            int nbytes = this.in.read();
            this.totalBytesRead += (long)(nbytes >= 0 ? 1 : 0);
            return nbytes;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nbytes;
            if (len == 0) {
                return 0;
            }
            if (this.peekb < 0) {
                int nbytes2 = this.in.read(b, off, len);
                this.totalBytesRead += (long)(nbytes2 >= 0 ? nbytes2 : 0);
                return nbytes2;
            }
            b[off++] = (byte)this.peekb;
            this.peekb = -1;
            this.totalBytesRead += (long)((nbytes = this.in.read(b, off, --len)) >= 0 ? nbytes : 0);
            return nbytes >= 0 ? nbytes + 1 : 1;
        }

        void readFully(byte[] b, int off, int len) throws IOException {
            int n = 0;
            while (n < len) {
                int count = this.read(b, off + n, len - n);
                if (count < 0) {
                    throw new EOFException();
                }
                n += count;
            }
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int skipped = 0;
            if (this.peekb >= 0) {
                this.peekb = -1;
                ++skipped;
                --n;
            }
            n = (long)skipped + this.in.skip(n);
            this.totalBytesRead += n;
            return n;
        }

        @Override
        public int available() throws IOException {
            return this.in.available() + (this.peekb >= 0 ? 1 : 0);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public long getBytesRead() {
            return this.totalBytesRead;
        }
    }

    private static class ValidationList {
        private Callback list;

        ValidationList() {
        }

        void register(ObjectInputValidation obj, int priority) throws InvalidObjectException {
            if (obj == null) {
                throw new InvalidObjectException("null callback");
            }
            Callback prev = null;
            Callback cur = this.list;
            while (cur != null && priority < cur.priority) {
                prev = cur;
                cur = cur.next;
            }
            AccessControlContext acc = AccessController.getContext();
            if (prev != null) {
                prev.next = new Callback(obj, priority, cur, acc);
            } else {
                this.list = new Callback(obj, priority, this.list, acc);
            }
        }

        void doCallbacks() throws InvalidObjectException {
            try {
                while (this.list != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws InvalidObjectException {
                            ((ValidationList)this).list.obj.validateObject();
                            return null;
                        }
                    }, this.list.acc);
                    this.list = this.list.next;
                }
            }
            catch (PrivilegedActionException ex) {
                this.list = null;
                throw (InvalidObjectException)ex.getException();
            }
        }

        public void clear() {
            this.list = null;
        }

        private static class Callback {
            final ObjectInputValidation obj;
            final int priority;
            Callback next;
            final AccessControlContext acc;

            Callback(ObjectInputValidation obj, int priority, Callback next, AccessControlContext acc) {
                this.obj = obj;
                this.priority = priority;
                this.next = next;
                this.acc = acc;
            }
        }
    }
}

