/*  Copyright (c) 2010 BIZERBA */
package com.bizerba.testjpos.scalecsoem;
import java.awt.event.*;

/**
 * The class extends WindowAdapter which
 * implements the WindowListener interface
 * The method windowClosing is overlayed to
 * close the window and to shut down the application
 * 
 * @author Reiner Moll
 * @version 1 - 25.10.2010
 * 
 */
public class WindowClosingAdapter extends WindowAdapter{
	
	/** Reference to object which implements the shut down interface */
	private ShutDown shutDown;

	/**
	 * construction without call back to shut down interface 
	 */
	public WindowClosingAdapter()
	{
		shutDown = null;		
	}
	
	/**
	 * Construction with call back to shut dwon interface
	 * 
	 * @param shutDown Reference to Object which implements the shut down interface
	 */	
	public WindowClosingAdapter(ShutDown shutDown)
	{
		this.shutDown = shutDown;		
	}
	
	/**
	 * Callback for window event close
	 * @param event Close event
	 * 
	 */	
	public void windowClosing(WindowEvent event)
	{
		event.getWindow().setVisible(false);
		event.getWindow().dispose();
		if(shutDown != null)
		{
			shutDown.shutDownApplication();
		}
	}
}
