/*  Copyright (c) 2010 BIZERBA */
package com.bizerba.testjpos.scalecsoem;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.text.*;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.bizerba.testjpos.scalecsoem.TabbedGUI1;
import com.bizerba.testjpos.scalecsoem.TabbedGUI2;
import com.bizerba.testjpos.scalecsoem.TabbedGUIInput;
import com.bizerba.testjpos.scalecsoem.TabbedGUISelfService;
import com.bizerba.testjpos.scalecsoem.TestBizerbaJposCommands;
import com.bizerba.testjpos.scalecsoem.WindowClosingAdapter;

/** 
 * GUI for sample application
 *              
 * Frame Dialog contains PLU Buttons and Button to 
 * switch the operationg mode
 * Include labels to display the weighing results
 * 
 * @author Reiner Moll
 * @version 1 - 25.10.2010
 *
 */
@SuppressWarnings("serial")
public class TestBizerbaJposGUI extends JFrame  {

//	/** Label to display sync, async mode */
//	private Label mode;
//	/** Panel includes nested labels for results */
	private JPanel result;
    /** Label to display error code */
	private Label error;
	/** Label to display scale status update events */
	private Label statusUpdate;
	/** Label to display additional infos of the update events */
	private Label statusUpdate2;
	/** Label to display fixed states  */
	private Label fixedStates;
	
//	
//
//
//	/** Panel includes nested labels with units */
	private JPanel units;
	/* Label to display the weight */
	private Label weight;
    /** Label to display the tare */
	private Label tare;
	/** Label to display the unit Price */
	private Label basePrice;
	/** Label to display the price */
	private Label price;
	/** Label for weight unit */
	private Label weighUnit;
	/** Label for price unit */
	private Label priceUnit;
	/** Label for weight unit */
	private Label tareUnit;
	/** Label for price unit */
	private Label unitPriceUnit;
	
	/** Display mode sync, async */
	public Label mode;
	
private boolean currentWeightModeIsActive;
		
	
	/** tabbed panel to keep differnt Jpannels and Dialog situations */
	private JTabbedPane tabbedPannel;
	
	/** GUI1 RIK OEM standard dialogs */
	private TabbedGUI1 tabbedGUI1;
	
	/** GUI1 RIK OEM standard dialogs */
	private TabbedGUI2 tabbedGUI2;
	
	/** GUI for self service application */
	private TabbedGUISelfService tabbedGUISelfService;
	
	/** GUI to for Input values */
	private TabbedGUIInput tabbedGUIInput;
	private TabbedGUICurrent tabbedGUICurrent;
		
	public boolean logIsOn = false;
	public boolean labelingIsOn  = false;
	public boolean weightWindowIsHidden  = false;
	public boolean operatorWindowIshidden  = false;
	public boolean switchWindow  = false;
	public boolean priceWasFixed  = false;
	public boolean tareWasLimited  = false;
	public boolean noTarePrio  = false;
	public boolean fsdTareEnable  = false;
	public boolean cycleTestIsOn  = false;
	public boolean tiltIson  = false;
	private boolean asyncmode=false;
	public boolean tareWasFixed=false;
	public String tareLimit = "";
	private boolean currentTabIsActive=false;
	private Button commandButton;
	private Color standardBackgroundColor;
	private static int width = 0;
	private static int height = 0;

	
	
	/**
	 * GUI construction
	 * @param cmd reference to Application Object
	 * The GUI gets a reference to the application object.
	 * The application object implements the ShutDown interface
	 * The WindowClosingAdapter calls back the application ShutDown
	 * when the gui object fires a close event 
	 * 
	 */	
	public TestBizerbaJposGUI(TestBizerbaJposCommands cmd)
	{		
		super("Bizerba JPos Test Application (c) Bizerba 2010-2019 Version 3.02");

		currentWeightModeIsActive = cmd.currentWeightModeIsActive;
		if(currentWeightModeIsActive == true)
		{
			String title = getTitle() + " " + "Current Weight Mode active"; 
			setTitle(title);
		}
		addWindowListener(new WindowClosingAdapter(cmd));
		setBackground(Color.lightGray);
		Rectangle rec = new Rectangle(800,400);
		try
		{
			GraphicsEnvironment ge = GraphicsEnvironment.
			getLocalGraphicsEnvironment();
			rec = ge.getMaximumWindowBounds();
		}
		catch(Exception e)
		{
		
		}
		width =  rec.width;
		height = rec.height;
		
		if(rec.width < 600 )
		{
			rec.width = 600;
		}
		if(rec.height < 400 )
		{
			rec.width = 400;
		}
		
		setSize(rec.width,rec.height/2);
		setLocation(0,rec.height/2);
		setResizable(false);
		
		GridBagLayout gbl = new GridBagLayout();		
		GridBagConstraints gbc;
		setLayout(gbl);
				
		units = new JPanel();
		units.setLayout(new GridLayout(1,0));		
		//Label label;
		
		tareUnit = new Label("Tare",Label.RIGHT);
		units.add(tareUnit);
		
		weighUnit = new Label("-",Label.RIGHT);
		units.add(weighUnit);
		
		
		unitPriceUnit = new Label("-/-",Label.RIGHT);
		units.add(unitPriceUnit);

		priceUnit = new Label("Price",Label.RIGHT);
		units.add(priceUnit);		
		
		
		units.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(20)));
		units.setBackground(Color.GRAY);		
		gbc = new GridBagConstraints(0, 0, 6, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(units, gbc);
		add(units);	
		

		
		result = new JPanel();
		result.setLayout(new GridLayout(1,0));

		tare = new Label("0.000",Label.RIGHT);
		result.add(tare);
		
		weight = new Label("0.000",Label.RIGHT);
		result.add(weight);
		standardBackgroundColor = weight.getBackground();

		basePrice = new Label("0.00",Label.RIGHT);
		result.add(basePrice);
			
		price = new Label("0.00",Label.RIGHT);
		result.add(price);
		
		gbc = new GridBagConstraints(0, 1, 4, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(result, gbc);
		result.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(30)));
		add(result);	
	
		gbc = new GridBagConstraints(0, 2, 4, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		error = new Label("",Label.CENTER);
		gbl.setConstraints(error, gbc);
		error.setBackground((Color.GREEN));
		error.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(16)));
		add(error);	
		

		gbc = new GridBagConstraints(0, 3, 4, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		statusUpdate = new Label("",Label.CENTER);
		gbl.setConstraints(statusUpdate, gbc);
		statusUpdate.setBackground((Color.WHITE));
		statusUpdate.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		add(statusUpdate);	
		
		gbc = new GridBagConstraints(0, 4, 1, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		mode = new Label("Mode",Label.CENTER);
		gbl.setConstraints(mode, gbc);
		mode.setBackground((Color.CYAN));
		mode.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		add(mode);
		
		gbc = new GridBagConstraints(1, 4, 1, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		statusUpdate2 = new Label("",Label.CENTER);
		gbl.setConstraints(statusUpdate2, gbc);
		statusUpdate2.setBackground((Color.WHITE));
		statusUpdate2.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		add(statusUpdate2);
		
		gbc = new GridBagConstraints(2, 4, 1, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		fixedStates = new Label("",Label.CENTER);
		gbl.setConstraints(fixedStates, gbc);
		fixedStates.setBackground((Color.MAGENTA));
		fixedStates.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		add(fixedStates);
		
		tabbedGUI1 = new TabbedGUI1(cmd,currentWeightModeIsActive);
		tabbedGUI2 = new TabbedGUI2(cmd,currentWeightModeIsActive);
		tabbedGUISelfService = new TabbedGUISelfService(cmd);
		tabbedGUIInput = new TabbedGUIInput(cmd);
		tabbedGUICurrent = new TabbedGUICurrent(cmd);
		

		ChangeListener changeListener = new ChangeListener() {
		      public void stateChanged(ChangeEvent changeEvent) {
		        JTabbedPane sourceTabbedPane = (JTabbedPane) changeEvent.getSource();
		        int index = sourceTabbedPane.getSelectedIndex();
		        if(sourceTabbedPane.getComponentAt(index) == tabbedGUICurrent)
		        {
		        	ToggleToCurrent(true);
		        }
		        else
		        {
		        	ToggleToCurrent(false);
		        }
		      }
		    };

		
		tabbedPannel = new JTabbedPane();
		tabbedPannel.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		
		tabbedPannel.addChangeListener(changeListener);
		
		tabbedPannel.addTab( "Input", tabbedGUIInput );
		tabbedPannel.addTab( "Selfservice", tabbedGUISelfService );		
		tabbedPannel.addTab( "OEM1", tabbedGUI1 );
		tabbedPannel.addTab( "OEM2", tabbedGUI2 );
		tabbedPannel.addTab( "Current", tabbedGUICurrent );
		
		gbc = new GridBagConstraints(0, 5, 4, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(tabbedPannel, gbc);
		
		add(tabbedPannel);
		commandButton = new Button("commands");
		commandButton.addActionListener(cmd);
		setVisible(true);
		
	}
	
	/**
	 * Displays the operation mode
	 * 
	 * @param opMode Operatin mode (sync, async)
	 * 
	 */
	public void updateGUISync(int opMode)
	{
		if(opMode == TestBizerbaJposCommands.TRANSASYNC)
		{
			mode.setText("Asynchronus mode");
			mode.setText("Asynchronus mode");
			asyncmode=true;
		}
		else
		{
			mode.setText("Synchronus mode");
			mode.setText("Synchronus mode");
			asyncmode=false;
		}
		updateGUIButtons();
	}
	
	/**
	 * Displays the weighing result
	 * 
	 * @param weight
	 * @param tare
	 * @param basePrice
	 * @param price
	 */
	public void updateGUIResult(float weight, float tare, double basePrice, double price, boolean priceIsvalid, int unit, int precWeight, int precTare)
	{
		DecimalFormat df;
		if(tare != 0)
		{
			switch(precTare)
			{
				case 1:
				df = new DecimalFormat("#0.0");
				break;
				case 2:
				df = new DecimalFormat("#0.00");
				break;
				default:
				df = new DecimalFormat("#0.000");
				break;			
			}						
			this.weight.setText(df.format(weight));						
			this.tare.setText(df.format(tare));
		}
		else
		{
			switch(precWeight)
			{
				case 1:
				df = new DecimalFormat("#0.0");
				break;
				case 2:
				df = new DecimalFormat("#0.00");
				break;
				default:
				df = new DecimalFormat("#0.000");
				break;			
			}			
			this.weight.setText(df.format(weight));						
			this.tare.setText("");
		}
		df = new DecimalFormat("#0.00");
		this.basePrice.setText(df.format(basePrice));
		if(priceIsvalid == true)
		{
			this.price.setBackground(Color.GREEN);
			this.price.setText(df.format(price));
			clearErrMessag();
			
		}			
		else
		{
			this.price.setText("");
			this.price.setBackground(Color.lightGray);
		}
		switch(unit)
		{
			case jpos.ScaleConst.SCAL_WU_KILOGRAM:
			{
				weighUnit.setText("kg");
				unitPriceUnit.setText("€/kg");				
				break;
			}
			case jpos.ScaleConst.SCAL_WU_GRAM:
			{
				weighUnit.setText("g");
				unitPriceUnit.setText("€/g");				
				break;
			}			
			case jpos.ScaleConst.SCAL_WU_POUND:
			{
				weighUnit.setText("lb");
				unitPriceUnit.setText("$/lb");				
				break;
			}
			case jpos.ScaleConst.SCAL_WU_OUNCE:
			{
				weighUnit.setText("oz");
				unitPriceUnit.setText("$/oz");				
				break;
			}	
		}
	}
	
	public void updateLifeWeight(float weight)
	{
		DecimalFormat df;
		df = new DecimalFormat("#0.000");			
		this.weight.setText(df.format(weight));						
	}

	public void updateLifeTare(float tare)
	{
		DecimalFormat df;
		df = new DecimalFormat("#0.000");			
		this.tare.setText(df.format(tare));						
	}

	
	public void clearGUIResult()
	{
		weight.setText("");
		tare.setText("");
		basePrice.setText("");
		price.setText("");
		price.setBackground(Color.lightGray);
		weight.setBackground(standardBackgroundColor);		
	}
	
	public void clearErrMessag()
	{
		error.setBackground(Color.GREEN);
		error.setText("");		
	}

	
	/**
	 * Displays the error message
	 * @param message
	 */
	public void displayError(String message)
	{
		error.setBackground(Color.RED);
		error.setText(message);		
	}
	
	/**
	 * Disable the panel with current weight and angle
	 * 
	 */	
	public void disableCurrentPanel()
	{
		tabbedPannel.remove(tabbedGUICurrent);
	}
	
	/**
	 * Displays the scale state
	 * @param message
	 */
	public void displayScaleState(String message)
	{
		error.setBackground(Color.white);
		error.setText(message);
	}
	
	/**
	 * Displays the status update
	 * @param status
	 */
	public void displayScaleStatusUpdate(String status)
	{		
		statusUpdate.setText(status);
		repaint();
	}
	
	/**
	 * Displays the status update
	 * @param status
	 */
	public void displayScaleStatusUpdate2(String status)
	{
		statusUpdate2.setText(status);
	}	
	
	/**
	 * Displays the status update
	 * @param status
	 */
	public void displayCommandInfo(String status)
	{
		tabbedGUI1.commandInfo.setText(status);
		tabbedGUI2.commandInfo.setText(status);
		tabbedGUIInput.commandInfo.setText(status);
	}	

	/**
	 * Enables disables the buttons
	 * 
	 * @param enable
	 * 
	 * The application disables the buttons, when the weighinh process
	 * was started
	 * 
	 */	
	public void enableGui(boolean enable)
	{
		tabbedGUI1.enableGui(enable);
		tabbedGUI2.enableGui(enable);
	}	
	

	/**
	 * Update log and label on button
	 * 
	 * @param logIsOn
	 * @param labelingIsOn
	 */
	
	public void updateGUIButtons()
	{
		tabbedGUI1.updateGUIButtons(weightWindowIsHidden,  operatorWindowIshidden, priceWasFixed,  tareWasLimited,  noTarePrio,  fsdTareEnable);
		tabbedGUI2.updateGUIButtons(tiltIson, labelingIsOn, switchWindow, cycleTestIsOn,asyncmode);
		tabbedGUIInput.updateGUIButtons(priceWasFixed, tareWasFixed, tareWasLimited, noTarePrio, fsdTareEnable);
		String states = "";
		if(tareWasLimited)
		{
			states = "T-Limit:" + tareLimit + " ";
		}
		if(priceWasFixed == true && tareWasFixed == true)
		{
			states += "Price and tare fix";
        }
		else if(priceWasFixed == true)
		{
			states += "Price fix";
		}
		else if(tareWasFixed == true)
		{
			states += "Tare fix";
		}		
		fixedStates.setText(states);
	}
	
	public void SetTestButtonPLU1()
	{
		tabbedGUI1.SetTestButtonPLU1();
		tabbedGUI2.SetTestButtonPLU1();
	}
	
	public void SetTestButtonPLU2()
	{
		tabbedGUI1.SetTestButtonPLU2();
		tabbedGUI2.SetTestButtonPLU2();
	}
	
	public void SetTestButtonRegister()
	{
		tabbedGUI1.SetTestButtonRegister();
		tabbedGUI2.SetTestButtonPLU2();
	}
	
	private void ToggleToCurrent(boolean isCurrentTab)
	{
		if(currentTabIsActive == false)
		{
			if(isCurrentTab == true)
			{
				/* Switch to show current  */
				clearGUIResult();
				tareUnit.setText("net weight");
				weighUnit.setText("high resolution");				
				unitPriceUnit.setText("Tilt");
				priceUnit.setText("");
				weight.setBackground(Color.lightGray);
				currentTabIsActive = true;
				ActionEvent ae =  new ActionEvent((Object)commandButton, ActionEvent.ACTION_PERFORMED, "SWITCHCURRENTON");				       
				commandButton.dispatchEvent(ae);
			}
		}
		else
		{
			if(isCurrentTab == false)
			{
				/* Switch show current off */
				tareUnit.setText("Tare");
				weighUnit.setText("-");				
				unitPriceUnit.setText("-/-");
				priceUnit.setText("Price");
				clearGUIResult();				
				currentTabIsActive = false;
				ActionEvent ae =  new ActionEvent((Object)commandButton, ActionEvent.ACTION_PERFORMED, "SWITCHCURRENTOFF");				       
				commandButton.dispatchEvent(ae);
			}			
		}		
	}
	
	/**
	 * Displays the current weighing result if current Tab is active
	 * 
	 * @param netweight
	 * @param highprecission
	 * @param tiltangle
	 */
	public void updateGUICurrent(String netweight, String  highprecission, String tiltangle)
	{
		if(currentTabIsActive == true)
		{
			tare.setText(netweight);
			weight.setText(highprecission);						
			basePrice.setText(tiltangle);
		}
		repaint();
	}
	
	
	/**
	 * Scale width to display resolution
	 * 
	 * 
	 * @param toScale
	 * @return
	 */	
	public static int scaleToResolutionWidth(int toScale)
	{
		int ret = toScale * width/800;
		return ret;
	}

	/**
	 * Scale height to display resolution
	 * 
	 * 
	 * @param toScale
	 * @return
	 */	
	public static int scaleToResolutionHeight(int toScale)
	{
		int ret = toScale * height/600;
		return ret;
	}
}


