 /*  Copyright (c) 2010 BIZERBA */
package com.bizerba.testjpos.scalecsoem;
/**
 *  Sample application for Bizerba JPOS driver
 *    
 *  Implements class with main() creates instance with test object
 * 
 * @author  Reiner Moll
 * @version 1 - 25.10.2010
 * 
 ******************************************************************************
 */
public class TestBizerbaJposDriver {
		
	/**
	 * @param args not used
	 */
	public static void main(String[] args) {
		
		System.out.println("Bizerba JPos test application");
		/* Test Instance */
		String deviceName;
		long cycletime = 0;
		boolean enableStatusUpdate = false;
		boolean currentWeightmode = false;
		if(args.length > 0)
		{
			deviceName = args[0];
			if(args.length > 1)
			{
				try
				{
					cycletime = Long.parseLong(args[1]);
				}
				catch (NumberFormatException e)
				{
					System.out.println(e.toString());
					cycletime = 0;					
				}	
			}
			if(args.length > 2)
			{
				try
				{
					long x = Long.parseLong(args[2]);
					if(x > 0)
					{
						enableStatusUpdate = true;
					}					
				}
				catch (NumberFormatException e)
				{
					System.out.println(e.toString());
					cycletime = 0;					
				}				
			}
			if(args.length > 3)
			{
				try
				{
					long x = Long.parseLong(args[2]);
					if(x > 0)
					{
						currentWeightmode = true;
						cycletime = 0;
						
					}					
				}
				catch (NumberFormatException e)
				{
					System.out.println(e.toString());
					cycletime = 0;
					enableStatusUpdate = false;
				}				
			}		
		}
		else
		{
			deviceName = "BizerbaScale";
		}
		TestBizerbaJposCommands jposCmd = new TestBizerbaJposCommands(deviceName,currentWeightmode, cycletime, enableStatusUpdate);
		/* Initial Scale */
		jposCmd.initScale();
	}
}
