/* Copyright (c) 2010 BIZERBA*/
package com.bizerba.testjpos.scalecsoem;
import jpos.*;
import jpos.events.*;

import java.awt.event.*;
import java.math.BigDecimal;
import java.math.MathContext;

import com.bizerba.jpos.scalecsoem.BizerbaScaleConstants;
import com.bizerba.testjpos.scalecsoem.TestBizerbaJposGUI;

/** 
 * Sample application for Bizerba JPOS driver  
 * 
 * The class implements a test application for the Bizerba
 * Jpos driver
 * The method initScale() generates a jpos.Scale object
 * Listens to events from the gui object oft type TestBizerbaJposGUI
 * to start weighing
 *   
 * @author Reiner Moll 
 * @version 2 - 13.08.2014
 * 
 */
public class TestBizerbaJposCommands implements ErrorListener, DataListener,ActionListener,StatusUpdateListener,DirectIOListener,ShutDown{

	/** operation mode wait for data synchronicaly or asynchronicaly in a the datalistener */
	private int opMode;	
	private boolean authenticationDone = false;
	/** the jpos scale instance */
	private jpos.Scale scale;
	/** the gui object */
	private TestBizerbaJposGUI gui;
	/** Operation mode is synchronic waiting for result directly */
	static final int TRANSSYNC = 0;
	/** Operation mode is assynchronic waiting for result in a listener */
	static final int TRANSASYNC = 1;
	/** logical name of the scale */
	private String logicalName;
	/** Display current weight  */
	public boolean currentWeightModeIsActive;
	/** Thread to display current weight */
	CurrentWeightThread currentWeightThread = null;
	/** Thread to call cyclically plus's */
	CycleTestThread cycleTestThread = null;
	/** The unit price */
	long [] unitPrice = new long[1];
	private long cycletime = 3000;
	
	private String lastTouchEvent = "";
	private boolean enableStatusUpdate = false;
	boolean autostarttest = false;
	
	
	
	/**
	 * generate gui instance and set members
	 * delivers the gui the ShutDown instance which is called when the window will be closed
	 * to shutDown the scale 
	 */	
	public TestBizerbaJposCommands(String logicalName)
	{
		opMode = TRANSSYNC;
		currentWeightModeIsActive = false;
		gui = new TestBizerbaJposGUI(this);
		scale = null;
		gui.updateGUISync(opMode);		
		gui.clearErrMessag();
		gui.clearGUIResult();
		this.logicalName = new String(logicalName);
		if(logicalName.equals("BizerbaScaleCS1")
				|| logicalName.equals("BizerbaScaleCS300SD1"))
		{
			System.out.println("selected CS");
			authenticationDone = true;		
		}		
		currentWeightThread = null;
		cycletime = 3000;
	}
	
	public TestBizerbaJposCommands(String logicalName, boolean currentWeightModeIsActive, long cycletime, boolean enableStatusUpdate)
	{
		opMode = TRANSSYNC;
		this.enableStatusUpdate = enableStatusUpdate;
		
		this.currentWeightModeIsActive = currentWeightModeIsActive;
		gui = new TestBizerbaJposGUI(this);
		scale = null;
		gui.updateGUISync(opMode);
		gui.clearErrMessag();
		gui.clearGUIResult();
		this.logicalName = new String(logicalName);
		if(logicalName.equals("BizerbaScaleCS1")
				|| logicalName.equals("BizerbaScaleCS300SD1"))
		{
			System.out.println("selected CS");
			authenticationDone = true;		
		}		
		if(currentWeightModeIsActive == true)
		{
			currentWeightThread = new CurrentWeightThread();
			gui.enableGui(true);
		}
		else
		{
			currentWeightThread = null;
		}
		if(cycletime < 0)
		{
			cycletime *= -1;
			autostarttest = true;			
		}
		if(cycletime < 500)
		{
			cycletime = 0;
			autostarttest = false;
		}
		this.cycletime = cycletime;
	}

	
	/**
	 * Callback from Data Event listener to receive asynchronicaly
	 * the weight
	 */	
	public void dataOccurred(DataEvent e)
	{
		
		System.out.println("Asynch Data aoccured");
		try 
		{
			System.out.println("Asynch: ");
			displayResults(e.getStatus());
		}		
		catch(JposException err)
		{
			System.out.println(err.getErrorCode()+ " " + err.getMessage());
			displayException(err);
		}		
	}
	
	/**
	 * Call back from DirectIO event listener to receive asynchronous directIO events
	 */
	public void directIOOccurred(DirectIOEvent directIOEvent)
	{
		String obj = (String)directIOEvent.getObject();
		String uposstate  = "scale not ready  ";
		switch(directIOEvent.getData())
		{
			case ScaleConst.SCAL_SUE_NOT_READY:
			{
				uposstate = "scale not ready  ";
				break;
			}
			case ScaleConst.SCAL_SUE_STABLE_WEIGHT:
			{
				uposstate = "stable weight    ";
				break;
			}			
			case ScaleConst.SCAL_SUE_WEIGHT_OVERWEIGHT:
			{
				uposstate = "scale over weight";
				break;
			}
			case ScaleConst.SCAL_SUE_WEIGHT_UNDER_ZERO:
			{
				uposstate = "weight under zero";
				break;
			}
			case ScaleConst.SCAL_SUE_WEIGHT_UNSTABLE:
			{
				uposstate = "weight unstable  ";
				break;
			}
			case ScaleConst.SCAL_SUE_WEIGHT_ZERO:
			{
				uposstate = "weight is zero   ";
				break;
			}
		}
		String splitter = ";";
		String splitter2 = "U";
		String parsed[] = obj.split(splitter);
		String netWeight = "";
		String netWeightUnit = "kg";
		String netWeightHighRes = "";
		String netWeightHighResUnit = "kg"; 
		String tareWeight = "";
		String tareWeightUnit = "kg";		
		String scaleFlags1 = "";
		String warmUpTimeCountDown = "";
		String angle = "";		
		for(int i = 0; i < parsed.length; i++)		
		{
			StringBuffer item = new StringBuffer(parsed[i]);			
			char sign = item.charAt(0);
			item.deleteCharAt(0);		
						
			switch(sign)
			{
				case 'N':
				{					
					netWeight = new String(item);
					String parsed2[] = netWeight.split(splitter2);
					netWeight = parsed2[0];
					switch(Integer.parseInt(parsed2[1]))
					{
						case ScaleConst.SCAL_WU_GRAM:
							netWeightUnit = "g";
						break;
						case ScaleConst.SCAL_WU_KILOGRAM:
							netWeightUnit = "kg";
						break;
						case ScaleConst.SCAL_WU_OUNCE:
							netWeightUnit = "oz";							
						break;
						case ScaleConst.SCAL_WU_POUND:
							netWeightUnit = "lb";
						break;				
					}
					break;
				}
				case 'H':
				{					
					netWeightHighRes = new String(item);
					String parsed2[] = netWeightHighRes.split(splitter2);
					netWeightHighRes = parsed2[0];
					switch(Integer.parseInt(parsed2[1]))
					{
						case ScaleConst.SCAL_WU_GRAM:
							netWeightHighResUnit = "g";
						break;
						case ScaleConst.SCAL_WU_KILOGRAM:
							netWeightHighResUnit = "kg";
						break;
						case ScaleConst.SCAL_WU_OUNCE:
							netWeightHighResUnit = "oz";							
						break;
						case ScaleConst.SCAL_WU_POUND:
							netWeightHighResUnit = "lb";
						break;				
					}
					break;
				}				
				case 'T':
				{					
					tareWeight = new String(item);
					String parsed2[] = tareWeight.split(splitter2);
					tareWeight = parsed2[0];
					switch(Integer.parseInt(parsed2[1]))
					{
						case ScaleConst.SCAL_WU_GRAM:
							tareWeightUnit = "g";
						break;
						case ScaleConst.SCAL_WU_KILOGRAM:
							tareWeightUnit = "kg";
						break;
						case ScaleConst.SCAL_WU_OUNCE:
							tareWeightUnit = "oz";							
						break;
						case ScaleConst.SCAL_WU_POUND:
							tareWeightUnit = "lb";
						break;				
					}					
					break;
				}				
				case 'F':
				{
					scaleFlags1 = Long.toHexString(new Long(new String(item)));
					break;
				}
				case 'G':
				{
					lastTouchEvent = new String(item);
					break;
				}
				case 'C':
				{
					warmUpTimeCountDown = new String(item);
					break;
				}
				case 'X':
				{
					angle = new String(item);
					break;
				}

			}
		}
		splitter = "x";
		parsed = lastTouchEvent.split(splitter);		
		String touchField = "";
		String upDown = "";
		if(2 == parsed.length)
		{
			int touchFieldType = BizerbaScaleConstants.POSSCALE_NOFIELD_TOUCH;
			int upDownI = 0;

			try 
			{ 
				touchFieldType = Integer.parseInt(parsed[0]); 
			} 
			catch ( NumberFormatException e ) 
			{ 
				System.err.println( "Number convert error" ); 
			}
			
			try 
			{ 				
				upDownI = Integer.parseInt(parsed[1]); 
			} 
			catch ( NumberFormatException e ) 
			{ 
				System.err.println( "Number convert error" ); 
			}
			
			switch(touchFieldType)
			{
				case BizerbaScaleConstants.POSSCALE_TAREFIELD_TOUCH:
				{
					touchField = "Tare  ";
					break;
				}
				case BizerbaScaleConstants.POSSCALE_WEIGHTFIELD_TOUCH:
				{
					touchField = "Weight";
					break;
				}
				case BizerbaScaleConstants.POSSCALE_BASEFIELD_TOUCH:
				{
					touchField = "Base  ";
					break;
				}
				case BizerbaScaleConstants.POSSCALE_PRICEFIELD_TOUCH:
				{
					touchField = "Price ";
					break;
				}
				case BizerbaScaleConstants.POSSCALE_NOFIELD_TOUCH:
				{
					touchField = "";
					upDown = "";
					break;
				}
			}
			if(1 == upDownI)
			{
				upDown = "down";
			}
			else
			{
				upDown = "up  ";
			}
		}
		gui.displayScaleStatusUpdate("Net:" + netWeight + " " + netWeightUnit + " Hnet:" + netWeightHighRes + " " + netWeightHighResUnit  + " Tare:" + tareWeight + " " + tareWeightUnit + " Flags1:" + scaleFlags1  +  " uposState: " + uposstate + " Last Touch:" + touchField  + " " + upDown );
		gui.updateGUICurrent(netWeight + " " + netWeightUnit, netWeightHighRes + " " + netWeightHighResUnit, angle);
		String warmUpTimeInfo ="";
		if(warmUpTimeCountDown.length() > 0)
		{
			warmUpTimeInfo = "warmup:" + warmUpTimeCountDown;
		}
	    gui.displayScaleStatusUpdate2(warmUpTimeInfo);
	}
	
	/**
	 * Status Update received
	 * 
	 */
	public void statusUpdateOccurred(StatusUpdateEvent statusUpdateEvent)
	{
		String uposstate = "scale not ready";
		switch(statusUpdateEvent.getStatus())
		{
			case ScaleConst.SCAL_SUE_NOT_READY:
			{
				uposstate = "scale not ready";
				break;
			}
			case ScaleConst.SCAL_SUE_STABLE_WEIGHT:
			{
				uposstate = "stable weight";
				break;
			}			
			case ScaleConst.SCAL_SUE_WEIGHT_OVERWEIGHT:
			{
				uposstate = "scale over weight";
				break;
			}
			case ScaleConst.SCAL_SUE_WEIGHT_UNDER_ZERO:
			{
				uposstate = "weight under zero";
				break;
			}
			case ScaleConst.SCAL_SUE_WEIGHT_UNSTABLE:
			{
				uposstate = "weight unstable";
				break;
			}
			case ScaleConst.SCAL_SUE_WEIGHT_ZERO:
			{
				uposstate = "weight is zero";
				break;
			}
		}
		gui.displayScaleStatusUpdate(" uposState: " + uposstate );	
	}

	/**
	 * Create jpos.Scale instance
	 * The JCL must find the entries for 
	 * the Bizerba scal service object in the 
	 * configuration file
	 */		
	public void initScale()
	{		
		if(scale == null)
		{
			scale = new jpos.Scale();
			try
			{
				if(opMode == TRANSSYNC)
				{
					scale.open(logicalName);			
					scale.claim(30000);
					if(true == enableStatusUpdate)
					{
						scale.setStatusNotify(jpos.ScaleConst.SCAL_SN_ENABLED);
					}
					scale.setDeviceEnabled(true);					
				}
				else
				{			
					scale.addDataListener(this);
					scale.addErrorListener(this);
					scale.open(logicalName);			
					scale.claim(30000);
					if(true == enableStatusUpdate)
					{
						scale.setStatusNotify(jpos.ScaleConst.SCAL_SN_ENABLED);
					}					
					scale.setDeviceEnabled(true);
					scale.setDataEventEnabled(true);
					scale.setAsyncMode(true);
				}
				scale.addDirectIOListener(this);
				if(true == enableStatusUpdate)
				{
					scale.addStatusUpdateListener(this);
				}
				DoAuthenticate();
				if(currentWeightModeIsActive == true)
				{					
					currentWeightThread.start();
				}
				if(autostarttest == true)
				{
					cycleTestThread = new CycleTestThread();
					cycleTestThread.start();
				}
			}
			catch(JposException e)
			{
				displayException(e);
			}
		}
	}
	
	/**
	 * Call back for GUI button action
	 */
	public void actionPerformed(ActionEvent event)
	{
		String cmd = event.getActionCommand();
		System.out.println("Action: " + cmd);
		int[] result = new int[2];
		String text = "";
		String param;
		int tare = 0;
		int tarelimit = 500;
		boolean selfService = false;
		boolean pricePer100g = false;
		boolean pricePer500g = false;
		boolean pricePerXlb = false;
		
		gui.displayCommandInfo("");
		if(currentWeightModeIsActive == false)
		{			
			gui.clearErrMessag();			
		}
		String splitter = ";";		
		String subCmd[] = cmd.split(splitter);
		if(subCmd.length == 2)
		{
			cmd = subCmd[0];
			if(subCmd[1].matches("SELF"))
			{
				selfService = true;
			}
			else if(subCmd[0].matches("SETPRESETTARE"))
			{
				BigDecimal dtare = new BigDecimal(subCmd[1],MathContext.DECIMAL32);
				BigDecimal factor = new BigDecimal(1000,MathContext.DECIMAL32);
				dtare = dtare.multiply(factor);
				tare = dtare.intValue();						
			}
			else if(subCmd[0].matches("SETPERCENTTARE"))
			{
				BigDecimal dtare = new BigDecimal(subCmd[1],MathContext.DECIMAL32);
				BigDecimal factor = new BigDecimal(100,MathContext.DECIMAL32);
				dtare = dtare.multiply(factor);
				tare = dtare.intValue();		
			}
			else if(subCmd[0].matches("limitweighttare"))
			{
				gui.tareLimit=subCmd[1];
				BigDecimal dtare = new BigDecimal(subCmd[1],MathContext.DECIMAL32);
				BigDecimal factor = new BigDecimal(1000,MathContext.DECIMAL32);
				dtare = dtare.multiply(factor);
				tarelimit = dtare.intValue();		
			}
			else if(subCmd[0].matches("SETPLUTEXT"))
			{
				text=subCmd[1];
			}		
			
		}		
		if(subCmd.length == 3)			
		{
			cmd = subCmd[0];
			if(subCmd[0].matches("SETUNITPRICE"))
			{
				if(subCmd[1].matches("100G"))
				{
					pricePer100g = true;
				}
				else if(subCmd[1].matches("500G"))
				{
					pricePer500g = true;
				}
				else if(subCmd[1].matches("X=3LB"))
				{
					pricePerXlb = true;
				}
				else
				{
					pricePer100g = false;
					pricePer500g = false;
					pricePerXlb = false;
				}
				
				BigDecimal price = new BigDecimal(subCmd[2],MathContext.DECIMAL64);
				BigDecimal factor = new BigDecimal(10000,MathContext.DECIMAL64);
				price = price.multiply(factor);
				unitPrice[0] = price.longValue();		
			}
		}

		if(cmd == "ID")
		{
			try {
				gui.displayScaleState(scale.getDeviceServiceDescription());
			} catch (JposException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}	
		}
		else if(authenticationDone == false)
		{
			DoAuthenticate();
		}
		else if(cmd.matches("SETUNITPRICE"))
		{			
			try {
				if(pricePer100g == true)
				{
					int weightUnit = jpos.ScaleConst.SCAL_WU_KILOGRAM;
					int weightNumerator = 1;
					int weightDenominator = 10;
					/* set a price per 100 g = 1kg/10 */
					scale.setUnitPriceWithWeightUnit(unitPrice[0], weightUnit, weightNumerator, weightDenominator);
				}
				else if(pricePer500g == true)
				{
					int weightUnit = jpos.ScaleConst.SCAL_WU_KILOGRAM;
					int weightNumerator = 1;
					int weightDenominator = 2;
					/* set a price per 500 g = 1kg/2 */
					scale.setUnitPriceWithWeightUnit(unitPrice[0], weightUnit, weightNumerator, weightDenominator);				
				}
				else if(pricePerXlb == true)
				{
					result[0] = (int)unitPrice[0]; // 
					param = "3";
					gui.displayCommandInfo(subCmd[2] + " $/3lb");
					scale.directIO(2001, result, param);				
				}
				else
				{
					scale.setUnitPrice(unitPrice[0]);
				}
			} catch (JposException e) {
				displayException(e);
			}		
		}
		else if(cmd.matches("SETPRESETTARE"))
		{			
			try
			{
				scale.setSpecialTare(jpos.ScaleConst.SCAL_SST_MANUAL, tare);
			} 
			catch (JposException e)
			{				
				displayException(e);
			}	
			
		}
		else if(cmd.matches("SETPERCENTTARE"))
		{			
			try
			{
				scale.setSpecialTare(jpos.ScaleConst.SCAL_SST_PERCENT, tare);
			} 
			catch (JposException e)
			{				
				displayException(e);
			}	
		}
		else if(cmd.matches("SETWEIGHTEDTARE"))
		{			
			try
			{
				scale.setSpecialTare(jpos.ScaleConst.SCAL_SST_WEIGHTED, tare);
			} 
			catch (JposException e)
			{				
				displayException(e);
			}	
		}
		else if(cmd.matches("SETPLUTEXT"))
		{			
			try
			{
				if(scale.getCapDisplayText() == true)
				{
					scale.displayText(text);
				}		
			} 
			catch (JposException e)
			{				
				displayException(e);
			}	
		}
		else if(cmd.matches("fixt"))
		{
			
			try
			{					
				if(gui.tareWasFixed == false)
				{
					gui.tareWasFixed = true;				
				}
				else
				{
					gui.tareWasFixed = false;
				}
				int item = jpos.ScaleConst.SCAL_SFR_WEIGHTED_TARE | jpos.ScaleConst.SCAL_SFR_MANUAL_TARE | jpos.ScaleConst.SCAL_SFR_PERCENT_TARE;
				boolean freeze = gui.tareWasFixed;
				scale.freezeValue(item, freeze);
				gui.updateGUIButtons();				
			}
			catch(JposException e)
			{
				displayException(e);
			}			
		}
		else if(cmd == "Syn/Asyn Mode")
		{
			ToggleOpMode();
			gui.updateGUISync(opMode);									
		}
		else if(cmd.matches("PLU1") || cmd.matches("PLU2") || cmd.matches("PLU3") || cmd.matches("PLU5") || cmd.matches("PLU6") || cmd.matches("PLU7"))
		{							
			if(currentWeightModeIsActive == false)
			{
				gui.enableGui(false);				
			}
			if((cmd.matches("PLU1") || cmd.matches("PLU2") || cmd.matches("PLU3") || cmd.matches("PLU5") || cmd.matches("PLU6") || cmd.matches("PLU7")) && gui.logIsOn == false )
			{
				// Get weight and price
				// use UPOS methods
				if(cmd.matches("PLU1"))
				{
					synchronized (unitPrice) 
					{
						unitPrice[0] = 150000;
					}
					tare = 0;
					text = "Bananas";
				}
				else if(cmd.matches("PLU2"))
				{
					synchronized (unitPrice)
					{
						unitPrice[0] = 184000;
					}
					tare = 100;
					//text = "Orangen";
					text = "Äpfel";
				}
				else if(cmd.matches("PLU3"))
				{
					tare = 20;
					text = "Pistachios (pr. per 100g)";					
				}				
				else if(cmd.matches("PLU5") || cmd.matches("PLU6"))
				{
					tare = 0;
					text = "Tomatos (graduated price)";
				}
				else if(cmd.matches("PLU7"))
				{
					tare = 10;
					text = "Beans (price per/xlb)";					
				}
				try
				{			
					if(currentWeightModeIsActive == false)
					{			
						if(cmd.matches("PLU3"))
						{
							/* example for a price per 100g this works not for checkout scales */
							long unitPrice = 25500; //2.55 per 100g
							int weightUnit = jpos.ScaleConst.SCAL_WU_KILOGRAM;
							int weightNumerator = 1;
							int weightDenominator = 10;
							/* set a price per 100 g = 1kg/10 */
							scale.setUnitPriceWithWeightUnit(unitPrice, weightUnit, weightNumerator, weightDenominator);
							
						}
						else if (cmd.matches("PLU5"))
						{
							/* example to set a graduated price this works not with a checkout scale */
							result[0] = 5000; // Timeout
							// price = 2.00 from 0... 0.5 kg, price = 1.8 for weights > 0.5 kg							
							param = "1|2.00|0.500-0.100|1.80|1.000|1.6|2.000|1.4|3.000|1.2|4.000|1.0";
							gui.displayCommandInfo("Graduate Mode: " + param);							
							scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_GRADUATED_PRICES_EX, result, param);							
						}
						else if (cmd.matches("PLU6"))
						{
							/* example to set a graduated price this works not with a checkout scale */
							result[0] = 5000; // Timeout
							// price = 2.00 from 0... 0.5 kg, price = 1.8 for weights > 0.5 kg
							param = "2|4.00|1.000|4.50|3.000|5.00|4.000|6.00";
							gui.displayCommandInfo("Slide Graduate Mode:" + param);
							scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_GRADUATED_PRICES_EX, result, param);							
						}						
						else if (cmd.matches("PLU7"))
						{
							result[0] = 37100; // Price 3,72
							param = "3";
							gui.displayCommandInfo("3.71 $/3lb");
							scale.directIO(2001, result, param);					
						}						
						else
						{
							if(scale.getCapSetUnitPriceWithWeightUnit() == true)
							{
								/* To test if the function works */
								int weightUnit = scale.getWeightUnit();
								scale.setUnitPriceWithWeightUnit(unitPrice[0], weightUnit, 1, 1);								
							}
							else
							{
								scale.setUnitPrice(unitPrice[0]);
							}
						}						
						if(scale.getCapDisplayText() == true)
						{
							scale.displayText(text);
						}
						if(selfService == true)
						{
							scale.setSpecialTare(jpos.ScaleConst.SCAL_SST_MANUAL, tare);
							if(opMode == TRANSSYNC && scale != null)
							{
								int nrOfAttempts = 1;
								while(true)
								{
									try
									{							
										doPriceCalcDisplayResults();
										return;
									}
									catch(JposException e)
									{
										
										if(e.getErrorCodeExtended() == 10010 || e.getErrorCodeExtended() == 202)
										{
											try 
											{										    										    
											    if(nrOfAttempts > 0)
											    {
											    	gui.displayScaleState("Load weight");
											    	nrOfAttempts--;										    	
											    	Thread.sleep(100);										    	
											    	continue;
											    }
											    else
											    {
											    	displayException(e);
											    }
											}
											catch (InterruptedException iex) {
											}									
										}
										else
										{
											displayException(e);	
										}
										return;
									}
								}							
							}
							else if(scale != null)
							{
								int[] weightData = new int[1];
								scale.setDataEventEnabled(true);
								scale.readWeight(weightData, 5000);
							}
							
						}
						else
						{							
							scale.setTareWeight(tare);
						}												
					}
					else
					{
						scale.setSpecialTare(jpos.ScaleConst.SCAL_SST_MANUAL, tare);
						if(scale.getCapDisplayText() == true)
						{
							scale.displayText(text);
						}
					}
					
				}
				catch(JposException e)
				{
					displayException(e);
				}
				
			}
		}
		else if(cmd == "REGISTER")
		{
			try
			{
				if(opMode == TRANSSYNC && scale != null)
				{
					int nrOfAttempts = 1;
					while(true)
					{
						try
						{							
							doPriceCalcDisplayResults();
							return;
						}
						catch(JposException e)
						{
							
							if(e.getErrorCodeExtended() == 10010 || e.getErrorCodeExtended() == 202)
							{
								try 
								{										    										    
								    if(nrOfAttempts > 0)
								    {
								    	gui.displayScaleState("Load weight");
								    	nrOfAttempts--;										    	
								    	Thread.sleep(100);										    	
								    	continue;
								    }
								    else
								    {
								    	displayException(e);
								    }
								}
								catch (InterruptedException iex) {
								}									
							}
							else
							{
								displayException(e);	
							}
							return;
						}
					}							
				}
				else if(scale != null)
				{
					int[] weightData = new int[1];
					scale.setDataEventEnabled(true);
					scale.readWeight(weightData, 5000);
				}
			}
			catch(JposException e)
			{
				displayException(e);
			}				
		}
		else if(cmd == "log")
		{			
			// show the logical version number
			// not defined in UPOS use direct IO Command			
			result[0] = 5000; // Timeout			
			if(gui.logIsOn == false)
			{				
				try
				{		
					scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_DISPLAY_VERSION_ON, result, null);
					gui.logIsOn=true;
				}
				catch(JposException e)
				{
					displayException(e);
				}							
			}
			else
			{
				try
				{
					scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_DISPLAY_VERSION_OFF, result, null);
					gui.logIsOn=false;
				}
				catch(JposException e)
				{
					displayException(e);
				}						
			}
			gui.updateGUIButtons();			
		}
		else if(cmd=="tilt")
		{
			result[0] = 5000; // Timeout			
			if(gui.tiltIson == false)
			{				
				try
				{		
					String obj = "0|bool|true";
					scale.directIO(901, result, obj);
					gui.tiltIson=true;
				}
				catch(JposException e)
				{
					displayException(e);
				}							
			}
			else
			{
				try
				{
					String obj = "0|bool|false";
					scale.directIO(901, result, obj);					
					gui.tiltIson=false;
				}
				catch(JposException e)
				{
					displayException(e);
				}						
			}
			gui.updateGUIButtons();	
		}
		else if(cmd == "hideShow")
		{			
			// Show hide weight window 
			// direct IO			
			result[0] = 5000; // Timeout			
			if(gui.weightWindowIsHidden == false)
			{				
				try
				{					
					scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_HIDE_WINDOW, result, null);
					gui.weightWindowIsHidden=true;
				}
				catch(JposException e)
				{
					displayException(e);
				}							
			}
			else
			{
				try
				{
					scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_SHOW_WINDOW, result, null);
					gui.weightWindowIsHidden=false;
				}
				catch(JposException e)
				{
					displayException(e);
				}						
			}
			gui.updateGUIButtons();		
		}
		else if(cmd == "hideShowOpWindow")
		{			
			// Show hide operator weight window 
			// direct IO			
			result[0] = 5000; // Timeout			
			if(gui.operatorWindowIshidden == false)
			{				
				try
				{					
					scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_HIDE_OPERATOR_WINDOW, result, null);
					gui.operatorWindowIshidden=true;
				}
				catch(JposException e)
				{
					displayException(e);
				}							
			}
			else
			{
				try
				{
					scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_SHOW_WINDOW, result, null);
					gui.weightWindowIsHidden=false;
					gui.operatorWindowIshidden = false;
				}
				catch(JposException e)
				{
					displayException(e);
				}						
			}
			gui.updateGUIButtons();			
		}
		else if(cmd == "switchFrames")
		{
			if(gui.switchWindow == false)
			{
				try
				{
					result[0] = 1;
					scale.directIO(905, result, null);
					gui.switchWindow = true;
				}
				catch(JposException e)
				{
					displayException(e);
				}
			}
			else
			{
				try
				{
					result[0] = 0;
					scale.directIO(905, result, null);
					gui.switchWindow = false;					
				}
				catch(JposException e)
				{
					displayException(e);
				}				
			}
			try
			{		
				String[] windowHandle = new String[1];
				windowHandle[0] = "";
				scale.directIO(902, result, windowHandle);				
				gui.displayCommandInfo("HWND: " + windowHandle[0]);
			}
			catch(JposException e)
			{
				displayException(e);
			}
			gui.updateGUIButtons();			
		}
		else if(cmd == "Tare")
		{
			// tare the weight on the scale
			// not defined in UPOS use direct IO Command			
			try
			{	
				int item = jpos.ScaleConst.SCAL_SFR_WEIGHTED_TARE;
				boolean freeze = false;
				scale.freezeValue(item, freeze);
				int mode = jpos.ScaleConst.SCAL_SST_WEIGHTED ;
				int data = 0;
				scale.setSpecialTare(mode, data);
				gui.tareWasFixed = false;
				gui.updateGUIButtons();
			}
			catch(JposException e)
			{
				displayException(e);
			}			
		}
		else if(cmd == "Tare and save")
		{
			// tare the weight on the scale and safe the weight
			// not defined in UPOS use direct IO Command
			try
			{					
				int item = jpos.ScaleConst.SCAL_SFR_WEIGHTED_TARE;
				boolean freeze = true;
				scale.freezeValue(item, freeze);
				gui.tareWasFixed = true;
				gui.updateGUIButtons();				
				int mode = jpos.ScaleConst.SCAL_SST_WEIGHTED ;
				int data = 0;
				scale.setSpecialTare(mode, data);
			}
			catch(JposException e)
			{
				displayException(e);
			}			
		}
		else if(cmd == "Set zero")
		{
			// set scale to zero
			// use UPOS method
			try
			{
				scale.zeroScale();
			}
			catch(JposException e)
			{
				displayException(e);
			}			
		}
		else if(cmd == "labeling")
		{
			// Turn labeling mode on/off
			// not defined in UPOS use direct IO Command
			if(gui.labelingIsOn == true)
			{								
				try
				{			
					int mode = jpos.ScaleConst.SCAL_PCM_OPERATOR;
					scale.setPriceCalculationMode(mode);
					gui.labelingIsOn = false;
				}
				catch(JposException e)
				{
					displayException(e);
				}				
			}
			else
			{								
				try
				{					
					int mode = jpos.ScaleConst.SCAL_PCM_PRICE_LABELING;
					scale.setPriceCalculationMode(mode);
					gui.labelingIsOn = true;
				}
				catch(JposException e)
				{
					displayException(e);
				}				
			}
			gui.updateGUIButtons();			
		}
		else if(cmd == "Scale state")
		{
			// Get scale state
			// not defined in UPOS use direct IO Command
			result[0] = 5000; // Timeout			
			try
			{					
				scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_CURRENT_SCALE_STATE, result, null);
				switch(result[0])
				{
					case BizerbaScaleConstants.BUSCI_STATE_VALID_WEIGHT:
					{
						gui.displayScaleState("State: Weight is valid");
						break;
					}
					case BizerbaScaleConstants.BUSCI_STATE_ERROR:
					{
						gui.displayScaleState("State: Error");
						break;
					}
					case BizerbaScaleConstants.BUSCI_STATE_WEIGHT_UNDERFLOW:
					{
						gui.displayScaleState("State: Weight underflow");
						break;
					}
					case BizerbaScaleConstants.BUSCI_STATE_WEIGHT_OVERFLOW:
					{
						gui.displayScaleState("State: Weight overflow");
						break;						
					}
					case BizerbaScaleConstants.BUSCI_STATE_WEIGHT_IS_ZERO:
					{
						gui.displayScaleState("State: Weight is zero");
						break;
					}			
					case BizerbaScaleConstants.BUSCI_STATE_WEIGHT_NOT_STABLE:
					{
						gui.displayScaleState("State: Weight instable");
						break;
					}
					case BizerbaScaleConstants.BUSCI_STATE_TILT_OVERFLOW:
					{
						gui.displayScaleState("State: Tilt compensation overflow");
						break;
					}
					case BizerbaScaleConstants.BUSCI_STATE_LOAD_CIRCUIT:
					{
						gui.displayScaleState("State: Product extends the load plate");
						break;
					}
					case BizerbaScaleConstants.BUSCI_STATE_DISPLAY_BLANK_MODE:
					{
						gui.displayScaleState("State: Display shows blanks scale not ready");
						break;						
					}		
					case BizerbaScaleConstants.BUSCI_STATE_IN_NW_MODE:
					{
						gui.displayScaleState("State: Display non weight items scale not ready");
						break;						
					}
					case BizerbaScaleConstants.BUSCI_STATE_REG_FIXED:
					{
						gui.displayScaleState("State: Weight fixed after registration");
						break;						
					}
					case BizerbaScaleConstants.BUSCI_STATE_UNLOAD_SCALE:
					{
						gui.displayScaleState("State: Unload scale");
						break;						
					}
					case BizerbaScaleConstants.BUSCI_STATE_SCALE_IN_CALIBRATION_MODE:
					{
						gui.displayScaleState("State: Scale in calibration mode");
						break;
					}
					
					
				}
			}
			catch(JposException e)
			{
				displayException(e);
			} 			
		}
		else if(cmd == "Piece item")
		{	
			// Display piece item
			// not defined in UPOS use direct IO Command
			
			result[0] = 5000; // Timeout			  
			try
			{							
				if(scale.getCapDisplayText() == true)
				{
					// unit price|total price|text
					param = "-2.14|-2.14|Pfand";					
				}
				else
				{
					// unit price|total price
					param = "2.0|4.0";
				}
				scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_DISPLAY_PIECE_ITEM, result, param);				
			}
			catch(JposException e)
			{
				displayException(e);
			}	
			
		}		
		else if(cmd == "Piece item(quantity)")
		{			
			// Display piece item with quantity
			// not defined in UPOS use direct IO Command
			result[0] = 5000; // Timeout

			// quantaty|unit-type|unit price|total price|text			
			param = "2.00|0|2.5|5.0|Potatoes";
			// param = "3|4.1|12.3";
			//param = "2.00|0|2.0|4.0";
			
			try
			{							
				scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_DISPLAY_PIECE_ITEM_PIECE, result, param);				
			}
			catch(JposException e)
			{
				displayException(e);
			}			
		}
		else if(cmd == "Blank screen")
		{
			// Clear the scerren
			// not defined in UPOS use direct IO Command
			result[0] = 5000; // Timeout
			try
			{					
				scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_BLANC_SCREEN, result, null);
			}
			catch(JposException e)
			{
				displayException(e);
			}			
		}		
		else if(cmd == "Delete piece")
		{
			// Delete piece item enable weight mode
			// not defined in UPOS use direct IO Command
			result[0] = 5000; // Timeout
			try
			{					
				scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_DELETE_PIECE_ITEM, result, null);
			}
			catch(JposException e)
			{
				displayException(e);
			}			
		}
		else if(cmd == "lw" )
		{
			try
			{
				int[] weightDataOut = new int[1];
				int[] tareOut = new int[1];
				int timeout = 2500;
				scale.readLiveWeightWithTare(weightDataOut, tareOut, timeout);
				//weightDataOut[0] = scale.getScaleLiveWeight();
				float liveWeight;
				float liveTare;
				liveWeight = (float) weightDataOut[0] / 1000;
				liveTare = (float) tareOut[0] / 1000;
				
				gui.clearErrMessag();
				gui.clearGUIResult();
				gui.updateLifeWeight(liveWeight);
				gui.updateLifeTare(liveTare);
				gui.enableGui(true);		
			}
			catch(JposException e)
			{
				displayException(e);
			}					
		}
		else if(cmd == "fixp")
		{
			if(gui.priceWasFixed == false)
			{
				gui.priceWasFixed = true;				
			}
			else
			{
				gui.priceWasFixed = false;
			}
			try
			{
				scale.freezeValue(jpos.ScaleConst.SCAL_SFR_UNITPRICE, gui.priceWasFixed);
			}
			catch (JposException e) 
			{
				displayException(e);
			}			
			gui.updateGUIButtons();			
		}
		else if(cmd.matches("limitweighttare"))
		{
			try
			{
				if(gui.tareWasLimited == false)
				{
					gui.tareWasLimited = true;
					result[0] = tarelimit;
					scale.directIO(906, result, null);
				}
				else
				{
					gui.tareWasLimited = false;
					result[0] = 999999;					
					scale.directIO(906, result, null);			
				}				
			}
			catch (JposException e) 
			{
				displayException(e);
			}			
			gui.updateGUIButtons();			
		}
		else if(cmd == "tarePrio")
		{
			try
			{
				if(gui.noTarePrio == false)
				{
					gui.noTarePrio = true;
					scale.setTarePrioity(jpos.ScaleConst.SCAL_STP_NONE);
				}
				else
				{
					gui.noTarePrio = false;
					scale.setTarePrioity(jpos.ScaleConst.SCAL_STP_FIRST);					
				}				
			}
			catch (JposException e) 
			{
				displayException(e);
			}			
			gui.updateGUIButtons();			
		}
		else if(cmd == "fsdTare")
		{
			try
			{
				if(gui.fsdTareEnable == false)
				{
					gui.fsdTareEnable = true;
					result[0] = 1;
					scale.directIO(2000, result, null);
				}
				else
				{
					gui.fsdTareEnable = false;
					result[0] = 0;					
					scale.directIO(2000, result, null);			
				}				
			}
			catch (JposException e) 
			{
				displayException(e);
			}			
			gui.updateGUIButtons();			
		}		
		else if(cmd == "perctare")
		{
			try
			{
				scale.setSpecialTare(jpos.ScaleConst.SCAL_SST_PERCENT, 1000);
			} 
			catch (JposException e)
			{				
				displayException(e);
			}
		}
		else if(cmd == "cycletest")
		{
			if(null == cycleTestThread  )
			{	
				if(cycletime > 0)
				{
					cycleTestThread = new CycleTestThread();
					cycleTestThread.start();
				}
				else
				{
					gui.displayError("No cycle time was set");
				}
			}
			else
			{			
				if (cycleTestThread.isAlive())
				{
					cycleTestThread.interrupt();
				}		
				cycleTestThread.kill();
				cycleTestThread = null;				
			}
			gui.cycleTestIsOn = (cycleTestThread != null);
			gui.updateGUIButtons();
		}
		else if(cmd == "getScaleLoadInfo")
		{
			result[0] = 5000; // Timeout			
			try
			{					
				String[] scaleInfo = new String[1];
				scaleInfo[0] = "";
				scale.directIO(903, result, scaleInfo);				
				gui.displayCommandInfo("Scale Info: " + scaleInfo[0]);			
			}
			catch(JposException e)
			{
				displayException(e);
			}
		}
		else if(cmd == "getLanguageInfo")
		{
			result[0] = 5000; // Timeout			
			try
			{
				String[] langInfo = new String[1];
				langInfo[0] = "";
				scale.directIO(904, result, langInfo);
				gui.displayCommandInfo("Lang Info: " + langInfo[0]);			
			}
			catch(JposException e)
			{
				displayException(e);
			}
		}
		else if(cmd == "SWITCHCURRENTON")
		{
			System.out.println("Switch current on");
			result[0] = 5000; // Timeout			
			try
			{
				String[] obj = new String[1];
				obj[0] = "1|bool|true";				
				scale.directIO(901, result, obj);
			}
			catch(JposException e)
			{
				gui.disableCurrentPanel();
			}		
		}
		else if(cmd == "SWITCHCURRENTOFF")
		{
			System.out.println("Switch current off");
			result[0] = 5000; // Timeout			
			try
			{
				String[] obj = new String[1];
				obj[0] = "1|bool|false";				
				scale.directIO(901, result, obj);
			}
			catch(JposException e)
			{
				gui.disableCurrentPanel();
			}		
			
		}		
	}
	
	/**
	 * Callback listener for error events
	 * 
	 */	
	public void errorOccurred(ErrorEvent e)
	{
		if(e.getErrorCodeExtended() > 0)
		{
			gui.displayError("Jpos Scale Error: " + e.getErrorCode() + " " + e.getErrorCodeExtended());
		}
		else
		{
			gui.displayError("Jpos Scale Error: " + e.getErrorCode());
		}
		gui.enableGui(true);						
	}	
	
	/**
	 * Shuts down the application
	 * 
	 * 
	 */	
	public void shutDownApplication()
	{		
		if(scale != null)
		{			
			try
			{
				if(opMode == TRANSSYNC)
				{
					System.out.println("Shutdown Sync Modus");
					scale.close();				
				}
				else
				{
					System.out.println("Shutdown async Modus");		
					scale.close();			
				}				
				scale = null;
				if (currentWeightThread != null) {
					try {
						currentWeightThread.interrupt();
						currentWeightThread.kill();
						currentWeightThread = null;
					} catch (Exception ex) {
					}
				}
				if (cycleTestThread != null) {
					try {
						cycleTestThread.interrupt();
						cycleTestThread.kill();
						cycleTestThread = null;						
					} catch (Exception ex) {
					}
				}
				
			}
			catch(JposException err)
			{
				
			}
		}
	}
	
	/**
	 * Switches to other opMode
	 * 
	 */	
	private void ToggleOpMode()
	{
		if(scale != null)
		{			
			try
			{
				scale.setDeviceEnabled(false);				
				if(opMode == TRANSSYNC)
				{
					scale.addDataListener(this);
					scale.addErrorListener(this);
					scale.setDataEventEnabled(true);
					scale.setAsyncMode(true);								
					opMode = TRANSASYNC;
				}
				else
				{
					scale.removeDataListener(this);
					scale.removeErrorListener(this);
					scale.setDataEventEnabled(false);
					scale.setAsyncMode(false);					
					opMode = TRANSSYNC;
				}
				scale.setDeviceEnabled(true);				
			}
			catch(JposException err)
			{
				displayException(err);
				try
				{
					scale.setDeviceEnabled(true);
				}
				catch(JposException x)
				{
				
				}
			}
		}	
	}
	
	/**
	 * 
	 * @param err The JposException include the code and Message
	 */	
	private void displayException(JposException err)
	{
		if(err.getErrorCodeExtended() > 0)
		{
			gui.displayError(err.getErrorCode()+ " " + err.getErrorCodeExtended() + " " + err.getMessage());
		}
		else
		{
			gui.displayError(err.getErrorCode()+ " "  + err.getMessage());
		
		}
		gui.enableGui(true);
	}
	
	/**
	 * Displays the weighing and price calculating results
	 * 
	 * @param weight the measured weight
	 * @throws JposException
	 */	
	private void displayResults(float weight) throws JposException 
	{
		float salesPrice;		
		float tare;
		float unitPrice;
		salesPrice = scale.getSalesPrice();				
		tare = scale.getTareWeight();
		unitPrice = scale.getUnitPrice();	
		salesPrice /= 10000;
		unitPrice /= 10000;
		tare /= 1000;
		weight /= 1000;
		int weightUnit = scale.getWeightUnit();
		int[] precWeightArg = new int[1];
		int[] precTareArg = new int[1];
	    GetPrecission(precWeightArg,precTareArg);		
		gui.updateGUIResult(weight, tare, unitPrice, salesPrice, true, weightUnit, precWeightArg[0],precTareArg[0]);
		gui.enableGui(true);		
	}
	
	/**
	 * Starts a price calculating requests and displays the results
	 *  
	 * @throws JposException
	 */
	private void doPriceCalcDisplayResults() throws JposException
	{	
		gui.clearGUIResult();
		int[] weightOut = new int[1];
		int[] tareOut = new int[1];
		long[] unitPriceOut = new long[1];
		long[] unitPriceXOut = new long[1];
		int[] weightUnitXOut = new int[1];
		int[] weightNumeratorXOut = new int[1];
		int[] weightDenominatorXOut = new int[1];
		long[] priceOut = new long[1];
		int timeout = 5000;
		scale.doPriceCalculating(weightOut, tareOut, unitPriceOut, unitPriceXOut, weightUnitXOut, weightNumeratorXOut, weightDenominatorXOut, priceOut, timeout);
		float weight = (float)weightOut[0] / 1000;
		float tare = (float)tareOut[0] / 1000;
		double unitPrice = (double)unitPriceOut[0] / 10000;
		double price = (double)priceOut[0] / 10000;
		int weightUnit = scale.getWeightUnit();
		int[] precWeightArg = new int[1];
		int[] precTareArg = new int[1];
	    GetPrecission(precWeightArg,precTareArg);		
		
		gui.updateGUIResult(weight, tare, unitPrice, price, true, weightUnit,precWeightArg[0], precTareArg[0] );
		gui.enableGui(true);		
	}
	
	
	/**
	 * Get precision of last price calculating
	 *  
	 * @throws JposException
	 */	
	private void GetPrecission(int precWeightArg[],int precTareArg[]) throws JposException
	{
		int[] result = new int[2];
		result[0] = 5000; // Timeout
		String[] datastring = new String[1];
		String precission = "";

		
		scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_GET_PREC_LAST_REG, result, datastring);
		precission = datastring[0];

		// parse precision 
		// precWeight|precTare
		int i = 2;
		int beginToken = 0;
		int nextToken = 0;
		String temp="";
		
		while(i > 0)
		{
			beginToken = nextToken;
			if(i > 1)
			{
				nextToken = precission.indexOf("|", beginToken);
				if(nextToken == -1)
				{
					break;
				}
				temp = precission.substring(beginToken, nextToken);
				nextToken++;	
			}
			else
			{
				temp = precission.substring(beginToken);
			}
			try
			{
				switch(i)
				{
					case 2:
					{
						// parse precision weight						
						precWeightArg[0]=  Integer.parseInt(temp);
						break;
					}
					case 1:
					{
						// parse precision tare						
						precTareArg[0] = Integer.parseInt(temp);
						break;
					}
				}						
			}
			catch(NumberFormatException e)
			{
				precWeightArg[0]= 3;
				precTareArg[0] = 3;					
			}			
			i--;					
		}		
	}

	
	private void DoAuthenticate()
	{
		if(authenticationDone == false)
		{
			int[] result = new int[2];
			result[0] = 5000; // Timeout
			
			
			try
			{					
				scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_AUTH_DEMO, result, null);
				authenticationDone = true;
				System.out.println("Switch current off");
				result[0] = 5000; // Timeout			
				try
				{
					String[] obj = new String[1];
					obj[0] = "1|bool|false";				
					scale.directIO(901, result, obj);
				}
				catch(JposException e)
				{
					gui.disableCurrentPanel();
				}
				
			}
			catch(JposException e)
			{
				displayException(e);
			}
		}
	}
		
	
	/**
	 * inner class implementing the thread for asynchronous read from scale
	 */	
	protected class CurrentWeightThread extends Thread
	{
		boolean blnMustKillIt = false;


		CurrentWeightThread()
		{
			blnMustKillIt = false;			
		}

		public void kill() {
			blnMustKillIt = true;
		}

		/**
		 * Run asynchron reading of the weight
		 */
		public void run() 
		{
			int[] result = new int[2];
			
			String[] datastring = new String[1];
			String current = "";
			int state=0;
			int weightUnit=0;
			float currentTare=0;
			float currentNetWeight=0;
			float salesPrice=0;		
			float uPrice=0;

			String temp="";
			
			
			while (!blnMustKillIt)
			{
				try 
				{
				    Thread.sleep(50);
				}
				catch (InterruptedException e) {
				}
				try {
					result[0] = 5000; // Timeout
					scale.directIO(BizerbaScaleConstants.BUSCI_DIO_REQUEST_CURRENT, result, datastring);
					current = datastring[0];
					
					
					// parse current 
					// state|weightUnit|currentTare|currentNetWeight
					int i = 4;
					int beginToken = 0;
					int nextToken = 0;
					while(i > 0)
					{
						beginToken = nextToken;
						if(i > 1)
						{
							nextToken = current.indexOf("|", beginToken);
							if(nextToken == -1)
							{
								break;
							}
							temp = current.substring(beginToken, nextToken);
							nextToken++;	
						}
						else
						{
							temp = current.substring(beginToken);
						}
						try
						{
							switch(i)
							{
								case 4:
								{
									// parse state								
									state = Integer.parseInt(temp);
									break;
								}
								case 3:
								{
									// parse weight unit								
									weightUnit = Integer.parseInt(temp);
									break;
								}
								case 2:
								{						
									// parse current tare
									currentTare = Float.parseFloat(temp);
									break;
								}
								case 1:
								{						
									// parse current net weight
									currentNetWeight = Float.parseFloat(temp);
									break;
								}							
							}						
						}
						catch(NumberFormatException e)
						{
							nextToken = -1;
							break;
						}			
						i--;					
					}
					if(nextToken != -1)
					{
						// received correct values
						synchronized (unitPrice)
						{
							uPrice = (float)unitPrice[0] /10000;
						}						
						if(state == BizerbaScaleConstants.BUSCI_STATE_VALID_WEIGHT)
						{
							// Stable weight, calculate price
							salesPrice = uPrice * currentNetWeight;
							gui.updateGUIResult(currentNetWeight, currentTare, uPrice, salesPrice, true, weightUnit,3,3);
						}
						else
						{
							gui.updateGUIResult(currentNetWeight, currentTare, uPrice, 0, false, weightUnit,3,3);							
						}
					}
					
				} 
				catch (JposException e) {
					// TODO Auto-generated catch block
					gui.clearGUIResult();
					displayException(e);					
				}

			}
		}
		protected void finalize() throws Throwable {
			try 
			{
				if (currentWeightThread != null)
				{
					if (currentWeightThread.isAlive())
					{
						currentWeightThread.interrupt();
					}
					currentWeightThread.kill();
					currentWeightThread = null;
				}
			}		
			finally
			{
				super.finalize();
			}
		}
	}
	
	
	/**
	 * inner class implementing the thread for asynchronous read from scale
	 */	
	protected class CycleTestThread extends Thread
	{
		boolean blnMustKillIt = false;


		CycleTestThread()
		{
			blnMustKillIt = false;			
		}

		public void kill() {
			blnMustKillIt = true;
		}

		/**
		 * Run call test PLU's automatically
		 */
		public void run() 
		{
			boolean blink = false;
			while (!blnMustKillIt)
			{
				try 
				{				    
				    if(false == blink)
				    {
				    	blink=true;
				    	gui.SetTestButtonPLU1();
				    	gui.SetTestButtonRegister();				    					    	
				    }
				    else
				    {
				    	blink=false;
				    	gui.SetTestButtonPLU2();
				    	gui.SetTestButtonRegister();
				    }
				    Thread.sleep(cycletime);
				}
				catch (InterruptedException e) {
				}								 
			}
		}
		protected void finalize() throws Throwable {
			try 
			{
				if (currentWeightThread != null)
				{
					if (currentWeightThread.isAlive())
					{
						currentWeightThread.interrupt();
					}
					currentWeightThread.kill();
					currentWeightThread = null;
				}
			}		
			finally
			{
				super.finalize();
			}
		}
	}	

	
}
