package com.bizerba.testjpos.scalecsoem;

import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.FocusListener;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JPanel;
import javax.swing.JTextArea;

@SuppressWarnings("serial")
public class TabbedGUIInput extends JPanel implements KeyListener{
	private Panel unitPricePanel;	
	private JTextArea unitPrice;
	private Button unitPriceButton;
	private Button unitPriceButtonPricePer100g;
	private Button unitPriceButtonPricePer500g;
	private Button unitPriceButtonPricePerXLB;
	private Panel tarePanel;
	private Panel tarePanel2;
	private Panel pluTextPanel;
	private JTextArea tareValue;
	private JTextArea percentTareValue;
	private JTextArea tareLimitValue;
	private JTextArea pluText;
	private Button presetTareButton;
	private Button percentTareButton;
	private Button weightedTareButton;
	private Button buttonFixPrice;	
	private Button buttonFixTare;	
	private Button buttonLimitWeightedTare;	
	private Button buttonSetTarePrio;	
	private Button buttonSetFSDTare;	
	private Button buttonSetZero;	
	private Button register;
	private Button setPLUText;
	
	/** Label to display infos of the selected command */
	public JTextArea commandInfo;
		
	TabbedGUIInput(ActionListener cmd){
		
		
		GridBagLayout gbl = new GridBagLayout();		
		GridBagConstraints gbc;
		setLayout(gbl);	
		
		gbc = new GridBagConstraints(0, 0, 6, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		commandInfo = new JTextArea();
		gbl.setConstraints(commandInfo, gbc);
		commandInfo.setBackground((Color.WHITE));
		commandInfo.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		commandInfo.setLineWrap(true);
		add(commandInfo);
				
		unitPricePanel = new Panel();
		unitPricePanel.setLayout(new GridLayout(1,0));
		unitPrice = new JTextArea("1.45");
		unitPrice.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		unitPrice.setBackground(Color.lightGray);
		unitPrice.addKeyListener(this);
		unitPricePanel.add(unitPrice);
		unitPriceButton = new Button("Set per total");
		unitPriceButton.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		unitPriceButton.setActionCommand("SETUNITPRICE"+ ";UNIT;" + unitPrice.getText() );
		unitPriceButton.addActionListener(cmd);
		unitPricePanel.add(unitPriceButton);
		unitPriceButtonPricePer100g = new Button("Set per 100g");
		unitPriceButtonPricePer100g.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		unitPriceButtonPricePer100g.setActionCommand("SETUNITPRICE"+ ";100G;" + unitPrice.getText() );
		unitPriceButtonPricePer100g.addActionListener(cmd);
		unitPricePanel.add(unitPriceButtonPricePer100g);		
		unitPriceButtonPricePer500g = new Button("Set per 500g");
		unitPriceButtonPricePer500g.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		unitPriceButtonPricePer500g.setActionCommand("SETUNITPRICE"+ ";500G;" + unitPrice.getText() );
		unitPriceButtonPricePer500g.addActionListener(cmd);
		unitPricePanel.add(unitPriceButtonPricePer500g);		
		unitPriceButtonPricePerXLB = new Button("Set per X=3 LB");
		unitPriceButtonPricePerXLB.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		unitPriceButtonPricePerXLB.setActionCommand("SETUNITPRICE"+ ";X=3LB;" + unitPrice.getText() );
		unitPriceButtonPricePerXLB.addActionListener(cmd);
		unitPricePanel.add(unitPriceButtonPricePerXLB );
		buttonFixPrice = new Button("fix price");
		buttonFixPrice.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonFixPrice.setActionCommand("fixp");
		buttonFixPrice.addActionListener(cmd);
		unitPricePanel.add(buttonFixPrice);
		gbc = new GridBagConstraints(0, 1, 6, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(unitPricePanel, gbc);
		add(unitPricePanel);		
		
		tarePanel = new Panel();
		tarePanel.setLayout(new GridLayout(1,0));
		tareValue = new JTextArea("0.007");
		tareValue.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		tareValue.setBackground(Color.lightGray);
		tareValue.addKeyListener(this);
		tarePanel.add(tareValue);
		
		presetTareButton = new Button("Set preset tare");
		presetTareButton.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		presetTareButton.setActionCommand("SETPRESETTARE"+ ";" + tareValue.getText() );
		presetTareButton.addActionListener(cmd);
		tarePanel.add(presetTareButton);
		
		weightedTareButton = new Button("weighted tare");
		weightedTareButton.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		weightedTareButton.setActionCommand("SETWEIGHTEDTARE");
		weightedTareButton.addActionListener(cmd);
		tarePanel.add(weightedTareButton);

		
		percentTareValue = new JTextArea("10.00");
		percentTareValue.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		percentTareValue.setBackground(Color.lightGray);
		percentTareValue.addKeyListener(this);
		tarePanel.add(percentTareValue);
		
		percentTareButton = new Button("Set % tare");
		percentTareButton.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		percentTareButton.setActionCommand("SETPERCENTTARE"+ ";" + percentTareValue.getText() );
		percentTareButton.addActionListener(cmd);
		tarePanel.add(percentTareButton);
		
		buttonFixTare = new Button("fix tare");
		buttonFixTare.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonFixTare.setActionCommand("fixt");
		buttonFixTare.addActionListener(cmd);
		tarePanel.add(buttonFixTare);

		
		
		gbc = new GridBagConstraints(0, 2, 6, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(tarePanel, gbc);
		add(tarePanel);
		
		
		tarePanel2 = new Panel();
		tarePanel2.setLayout(new GridLayout(1,0));
		tareLimitValue = new JTextArea("0.500");
		tareLimitValue.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		tareLimitValue.setBackground(Color.lightGray);
		tareLimitValue.addKeyListener(this);
		tarePanel2.add(tareLimitValue);
		
		buttonLimitWeightedTare = new Button("Limit weight tare");
		buttonLimitWeightedTare.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonLimitWeightedTare.setActionCommand("limitweighttare;0.500");
		buttonLimitWeightedTare.addActionListener(cmd);
		tarePanel2.add(buttonLimitWeightedTare);
		
		buttonSetTarePrio = new Button("No T prio");
		buttonSetTarePrio.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonSetTarePrio.setActionCommand("tarePrio");
		buttonSetTarePrio.addActionListener(cmd);
		tarePanel2.add(buttonSetTarePrio);	
		
		buttonSetFSDTare = new Button("enable FSD tare");
		buttonSetFSDTare.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonSetFSDTare.setActionCommand("fsdTare");
		buttonSetFSDTare.addActionListener(cmd);
		tarePanel2.add(buttonSetFSDTare);
		
		buttonSetZero = new Button("Set zero");
		buttonSetZero.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonSetZero.addActionListener(cmd);
		tarePanel2.add(buttonSetZero);

		register = new Button("Register");
		register.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		register.addActionListener(cmd);
		register.setActionCommand("REGISTER");
		register.setBackground(Color.PINK);
		tarePanel2.add(register);
		
		gbc = new GridBagConstraints(0, 3, 6, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(tarePanel2, gbc);
		add(tarePanel2);
		
		pluTextPanel = new Panel();
		pluTextPanel.setLayout(new GridLayout(1,0));				
		pluText = new JTextArea("Bio Äpfel aus Shanghai");
		pluText.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		pluText.addKeyListener(this);
		pluTextPanel.add(pluText);
		
		setPLUText = new Button("Set Plu Text");
		setPLUText.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		setPLUText.addActionListener(cmd);
		setPLUText.setActionCommand("SETPLUTEXT;Bio Äpfel aus Shanghai");
		pluTextPanel.add(setPLUText);
		
		gbc = new GridBagConstraints(0, 4, 6, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(pluTextPanel, gbc);
		add(pluTextPanel);
		
			
	}

	@Override
	public void keyTyped(KeyEvent e) {
		// TODO Auto-generated method stub		
	}

	@Override
	public void keyPressed(KeyEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void keyReleased(KeyEvent e) {
		// TODO Auto-generated method stub
		if(e.getComponent() == unitPrice)
		{
			try
			{
				@SuppressWarnings("unused")
				Double testNumber;
				testNumber = new Double(unitPrice.getText());
			}
			catch(NumberFormatException exception)
			{
				unitPrice.setText("");
			}
			unitPriceButton.setActionCommand("SETUNITPRICE"+ ";UNIT;" + unitPrice.getText() );
			unitPriceButtonPricePer100g.setActionCommand("SETUNITPRICE"+ ";100G;" + unitPrice.getText() );
			unitPriceButtonPricePer500g.setActionCommand("SETUNITPRICE"+ ";500G;" + unitPrice.getText() );
			unitPriceButtonPricePerXLB.setActionCommand("SETUNITPRICE"+ ";X=3LB;" + unitPrice.getText() );
		}
		else if(e.getComponent() == tareValue)
		{
			try
			{
				@SuppressWarnings("unused")
				Double testNumber;
				testNumber = new Double(tareValue.getText());
			}
			catch(NumberFormatException exception)
			{
				tareValue.setText("");
			}			
			presetTareButton.setActionCommand("SETPRESETTARE"+ ";" + tareValue.getText() );

		}
		else if(e.getComponent() == percentTareValue)
		{
			try
			{
				@SuppressWarnings("unused")
				Double testNumber;
				testNumber = new Double(percentTareValue.getText());
			}
			catch(NumberFormatException exception)
			{
				percentTareValue.setText("");
			}			
			percentTareButton.setActionCommand("SETPERCENTTARE"+ ";" + percentTareValue.getText() );
		}
		else if(e.getComponent() == tareLimitValue)
		{
			try
			{
				@SuppressWarnings("unused")
				Double testNumber;
				testNumber = new Double(tareLimitValue.getText());
			}
			catch(NumberFormatException exception)
			{
				tareLimitValue.setText("");
			}
			buttonLimitWeightedTare.setActionCommand("limitweighttare"  +  ";" + tareLimitValue.getText() );
		}		
		else if(e.getComponent() == pluText)
		{
			if(pluText.getText().length() > 0)
			{
				setPLUText.setActionCommand("SETPLUTEXT" +  ";" + pluText.getText() );
			}
			else
			{
				setPLUText.setActionCommand("SETPLUTEXT");
			}
		}
	};
	
	public void updateGUIButtons(boolean priceWasFixed, boolean tareWasFixed, boolean tareWasLimited, boolean noTarePrio, boolean fsdTareEnable)
	{
		if(priceWasFixed==true)
		{
			buttonFixPrice.setLabel("Price fixed");
			buttonFixPrice.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonFixPrice.setLabel("Price not fixed");
			buttonFixPrice.setBackground(Color.LIGHT_GRAY);
		}
		
		if(tareWasFixed==true)
		{
			buttonFixTare.setLabel("Tare fixed");
			buttonFixTare.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonFixTare.setLabel("Fix tare");
			buttonFixTare.setBackground(Color.LIGHT_GRAY);
		}
		

		if(tareWasLimited==true)
		{
			buttonLimitWeightedTare.setLabel("unlimit weight tare");
			buttonLimitWeightedTare.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonLimitWeightedTare.setLabel("Limit weight tare");
			buttonLimitWeightedTare.setBackground(Color.LIGHT_GRAY);
		}

		if(noTarePrio == true)
		{
			buttonSetTarePrio.setLabel("First T prio");
			buttonSetTarePrio.setBackground(Color.YELLOW);
		}
		else
		{
			buttonSetTarePrio.setLabel("No T prio");			
			buttonSetTarePrio.setBackground(Color.LIGHT_GRAY);
		}

		if(fsdTareEnable == true)
		{
			buttonSetFSDTare.setLabel("disable FSD tare");
			buttonSetFSDTare.setBackground(Color.YELLOW);
		}
		else
		{
			buttonSetFSDTare.setLabel("enable FSD tare");			
			buttonSetFSDTare.setBackground(Color.LIGHT_GRAY);
		}	
		
	}
}
