package com.bizerba.testjpos.scalecsoem;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JPanel;
import javax.swing.JTextArea;

@SuppressWarnings("serial")
public class TabbedGUI2 extends JPanel {

	/** Extensions for KOEM */
	private Panel koemextension;
	/** Button Log Version on/off */
	public Button buttonTiltCompensation;
	/** Button labeling mode on off */
	public Button buttonLabelingOnOff;
	/** show UPOS Service Description */
	private Button buttonId;
	/** Button scale state*/
	private Button buttonState;
	/** Button switch frames */
	public Button buttonChangeFrameWindow;
	/** Button set sync/async */
	public Button buttonSyncAsync;
	
	/** Button cycle test */
	public Button buttonCycleTest;
	/** PLU Button 1 */
	public Button buttonplu1;
	/** PLU Button 2 */
	public Button buttonplu2;
	/** Button Register */
	public Button register;
	/** Panel include PLU Buttons */
	private Panel plus;
	
	/** Button show scale options */
	private Button buttonGetScaleLoadOptions;
	/** Button show country options */
	private Button buttonGetLanguageOptions;
	/** Laufender Gewichts Modus aktiv */
	private boolean currentWeightModeIsActive;
	/** Label to display infos of the selected command */
	public JTextArea commandInfo;
	

	public TabbedGUI2(ActionListener cmd, boolean currentWeightModeIsActive)
	{
		this.currentWeightModeIsActive = currentWeightModeIsActive;
		GridBagLayout gbl = new GridBagLayout();		
		GridBagConstraints gbc;
		setLayout(gbl);

		gbc = new GridBagConstraints(0, 0, 5, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		commandInfo = new JTextArea();
		gbl.setConstraints(commandInfo, gbc);
		commandInfo.setBackground((Color.WHITE));
		commandInfo.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		commandInfo.setLineWrap(true);
		add(commandInfo);

		
		plus = new Panel();
		plus.setLayout(new GridLayout(1,0));	
		
		buttonplu1 = new Button("PLU without tare");
		buttonplu1.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonplu1.addActionListener(cmd);
		buttonplu1.setActionCommand("PLU1");
		plus.add(buttonplu1);
		
		buttonplu2 = new Button("PLU with tare");
		buttonplu2.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonplu2.addActionListener(cmd);
		buttonplu2.setActionCommand("PLU2");
		plus.add(buttonplu2);
		
		register = new Button("Register");
		register.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		register.setBackground(Color.PINK);
		register.addActionListener(cmd);
		register.setActionCommand("REGISTER");
		plus.add(register);
		
		buttonCycleTest = new Button("Cycle test");
		buttonCycleTest.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonCycleTest.setActionCommand("cycletest");
		buttonCycleTest.addActionListener(cmd);
		plus.add(buttonCycleTest);

		gbc = new GridBagConstraints(0, 1, 5, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(plus, gbc);
		add(plus);
		
		gbc = new GridBagConstraints(0, 2, 1, 1, 100,100,GridBagConstraints.SOUTH , GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		buttonSyncAsync = new Button("Syn/Asyn Mode");
		buttonSyncAsync.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		gbl.setConstraints(buttonSyncAsync, gbc);
		buttonSyncAsync.setActionCommand("Syn/Asyn Mode");
		buttonSyncAsync.addActionListener(cmd);
		add(buttonSyncAsync);
		
		buttonChangeFrameWindow = new Button("Switch frames 1");
		buttonChangeFrameWindow.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonChangeFrameWindow.setActionCommand("switchFrames");
		buttonChangeFrameWindow.addActionListener(cmd);
		gbc = new GridBagConstraints(1, 2, 1, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(buttonChangeFrameWindow, gbc);
		add(buttonChangeFrameWindow);
		
		gbc = new GridBagConstraints(2, 2, 1, 1, 100,100,GridBagConstraints.SOUTH , GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		buttonTiltCompensation = new Button("Turn Tilt On");
		buttonTiltCompensation.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		gbl.setConstraints(buttonTiltCompensation, gbc);
		buttonTiltCompensation.addActionListener(cmd);
		buttonTiltCompensation.setActionCommand("tilt");		
		add(buttonTiltCompensation);
		
		gbc = new GridBagConstraints(3, 2, 2, 1, 100,100,GridBagConstraints.SOUTH , GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		buttonLabelingOnOff = new Button("Turn Labeling on");
		buttonLabelingOnOff.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		gbl.setConstraints(buttonLabelingOnOff, gbc);
		buttonLabelingOnOff.addActionListener(cmd);
		buttonLabelingOnOff.setActionCommand("labeling");
		add(buttonLabelingOnOff);
		
		koemextension = new Panel();
		koemextension.setLayout(new GridLayout(1,0));
		Button button;
		
		button = new Button("Set zero");
		button.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		button.addActionListener(cmd);
		koemextension.add(button);
		
		button = new Button("Piece item");
		button.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		button.addActionListener(cmd);
		koemextension.add(button);
		button = new Button("Piece item(quantity)");
		button.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		button.addActionListener(cmd);
		koemextension.add(button);
		button = new Button("Blank screen");
		button.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		button.addActionListener(cmd);
		koemextension.add(button);		
		button = new Button("Delete piece");
		button.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		button.addActionListener(cmd);
		koemextension.add(button);

		gbc = new GridBagConstraints(0, 3, 5, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(koemextension, gbc);
		add(koemextension);	

		buttonGetScaleLoadOptions = new Button("Scale info"); ;
		buttonGetScaleLoadOptions.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonGetScaleLoadOptions.setActionCommand("getScaleLoadInfo");
		buttonGetScaleLoadOptions.addActionListener(cmd);
		gbc = new GridBagConstraints(0, 4, 1, 1, 100,100,GridBagConstraints.NORTH , GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(buttonGetScaleLoadOptions, gbc);
		add(buttonGetScaleLoadOptions);

		buttonGetLanguageOptions = new Button("Language infos");
		buttonGetLanguageOptions.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonGetLanguageOptions.setActionCommand("getLanguageInfo");
		buttonGetLanguageOptions.addActionListener(cmd);
		gbc = new GridBagConstraints(1, 4, 2, 1, 100,100,GridBagConstraints.NORTH , GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(buttonGetLanguageOptions, gbc);
		add(buttonGetLanguageOptions);
		
		gbc = new GridBagConstraints(3, 4, 1, 1, 100,100,GridBagConstraints.SOUTH , GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		buttonId = new Button("Show ID");
		buttonId.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		gbl.setConstraints(buttonId, gbc);
		buttonId.addActionListener(cmd);
		buttonId.setActionCommand("ID");		
		add(buttonId);	
		
		gbc = new GridBagConstraints(4, 4, 1, 1, 100,100,GridBagConstraints.SOUTH , GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);		
		buttonState = new Button("Scale state");
		buttonState.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		gbl.setConstraints(buttonState, gbc);		
		buttonState.addActionListener(cmd);
		add(buttonState);

	}
	/**
	 * Enables disables the buttons
	 * 
	 * @param enable
	 * 
	 * The application disables the buttons, when the weighinh process
	 * was started
	 * 
	 */	
	public void enableGui(boolean enable)
	{
		if(enable==true)
		{
			Component comps[] = getComponents();
			for(int i = 0;i < comps.length; i++)
			{
				Object obj = comps[i];
				if(obj instanceof Button)
				{
					comps[i].setEnabled(enable);					
				}
												
			}
		}
		if(currentWeightModeIsActive == true)
		{
			buttonSyncAsync.setEnabled(false);
			register.setEnabled(false);
			buttonCycleTest.setEnabled(false);			
		}

	}	
	

	/**
	 * Update log and label on button
	 * 
	 * @param logIsOn
	 * @param labelingIsOn
	 */
	
	public void updateGUIButtons(boolean tiltIsOn,boolean labelingIsOn, boolean switchWindow, boolean cycleTestIsOn, boolean async)
	{
		if(tiltIsOn==true)
		{
			buttonTiltCompensation.setLabel("Turn tilt off");
			buttonTiltCompensation.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonTiltCompensation.setLabel("Turn tilt on");
			buttonTiltCompensation.setBackground(Color.lightGray);		
		}
		if(labelingIsOn==true)
		{
			buttonLabelingOnOff.setLabel("Turn labeling off");
			buttonLabelingOnOff.setBackground(Color.YELLOW);
		}
		else
		{
			buttonLabelingOnOff.setLabel("Turn labeling on");
			buttonLabelingOnOff.setBackground(Color.LIGHT_GRAY);
		}

		if(switchWindow==true)
		{
			buttonChangeFrameWindow.setLabel("Switch frames 0");
			buttonChangeFrameWindow.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonChangeFrameWindow.setLabel("Switch frames 1");
			buttonChangeFrameWindow.setBackground(Color.LIGHT_GRAY);	
		}
		
		if(cycleTestIsOn==true)
		{
			buttonCycleTest.setLabel("Cycle Test runs");
			buttonCycleTest.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonCycleTest.setLabel("Cycle test");
			buttonCycleTest.setBackground(Color.LIGHT_GRAY);
		}
		if(async==true)
		{
			buttonSyncAsync.setLabel("Sync Mode");
			buttonSyncAsync.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonSyncAsync.setLabel("Async Mode");
			buttonSyncAsync.setBackground(Color.LIGHT_GRAY);		
		}
	}
	public void SetTestButtonPLU1()
	{
		ActionEvent ae = 
		          new ActionEvent((Object)buttonplu1, ActionEvent.ACTION_PERFORMED, "PLU1");
		       
		buttonplu1.dispatchEvent(ae); 

	}
	
	public void SetTestButtonPLU2()
	{
		ActionEvent ae = 
		          new ActionEvent((Object)buttonplu2, ActionEvent.ACTION_PERFORMED, "PLU2");
		       
		buttonplu2.dispatchEvent(ae); 

	}
	
	public void SetTestButtonRegister()
	{
		ActionEvent ae = 
		          new ActionEvent((Object)register, ActionEvent.ACTION_PERFORMED, "REGISTER");
		       
		register.dispatchEvent(ae); 

	}
	

}
