package com.bizerba.testjpos.scalecsoem;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;


@SuppressWarnings("serial")
public class TabbedGUI1 extends JPanel {

	/** Extensions for KOEM */
	private Panel koemextension;
	/** Button get live weight */
	private Button buttonLiveWeight;
	/** Button Hide show window */
	private Button buttonHideShowWindow;
	/** Button Hide show window */
	private Button buttonHideShowOperatorWindow;
	/** Button price per 100g */
	private Button pricePer;
	/** Button Register */
	private Button register;
	/** Button graduated price with fix graduates */
	private Button gradPriceEx1;
	/** Button graduated price with sliding price */
	private Button gradPriceEx2;
	/** Button price per x lb */
	private Button priceXLB;
	/** Button set percent tare */
	private Button buttonPercentTare;
	/** Button set fix price */
	private Button buttonFixPrice;
	/** Button  weighted tare limit */
	private Button buttonLimitWeightedTare;
	/** Button set tare priority */
	private Button buttonSetTarePrio;
	/** Button set enable FSD tare */
	private Button buttonSetFSDTare;	
	
	/** PLU Button 1 */
	private Button buttonplu1;
	/** PLU Button 2 */
	private Button buttonplu2;	
	/** Panel include PLU Buttons */
	private Panel plus;
	/** Panel for misc settings 1 */
	private Panel misc1;
	/** Panel for misc settings 2 */
	private Panel misc2;
	
	
	/** Laufender Gewichts Modus aktiv */
	private boolean currentWeightModeIsActive;
	/** Label to display infos of the selected command */
	public JTextArea commandInfo;
	

	public TabbedGUI1(ActionListener cmd, boolean currentWeightModeIsActive)
	{
		this.currentWeightModeIsActive = currentWeightModeIsActive;
		GridBagLayout gbl = new GridBagLayout();		
		GridBagConstraints gbc;
		setLayout(gbl);
		

		gbc = new GridBagConstraints(0, 0, 4, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		commandInfo = new JTextArea();
		gbl.setConstraints(commandInfo, gbc);
		commandInfo.setBackground((Color.WHITE));
		commandInfo.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		commandInfo.setLineWrap(true);
		add(commandInfo);

		
		plus = new Panel();
		plus.setLayout(new GridLayout(1,7));	
		
		buttonplu1 = new Button("PLU without tare");
		buttonplu1.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonplu1.addActionListener(cmd);
		buttonplu1.setActionCommand("PLU1");		
		plus.add(buttonplu1);
		
		buttonplu2 = new Button("PLU with tare");
		buttonplu2.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonplu2.addActionListener(cmd);
		buttonplu2.setActionCommand("PLU2");
		plus.add(buttonplu2);
		pricePer = new Button("Price per 100g");
		pricePer.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		pricePer.addActionListener(cmd);
		pricePer.setActionCommand("PLU3");
		plus.add(pricePer);
		
		register = new Button("Register");
		register.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		register.addActionListener(cmd);
		register.setActionCommand("REGISTER");
		register.setBackground(Color.PINK);
		plus.add(register);
		
		gradPriceEx1 = new Button("Grad. price mode 1 ");
		gradPriceEx1.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		gradPriceEx1.addActionListener(cmd);
		gradPriceEx1.setActionCommand("PLU5");
		plus.add(gradPriceEx1);

		gradPriceEx2 = new Button("Grad. price mode 2 slide");
		gradPriceEx2.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		gradPriceEx2.addActionListener(cmd);
		gradPriceEx2.setActionCommand("PLU6");
		plus.add(gradPriceEx2);
		
		priceXLB = new Button("Price xlb");
		priceXLB.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		priceXLB.addActionListener(cmd);
		priceXLB.setActionCommand("PLU7");
		plus.add(priceXLB);

		gbc = new GridBagConstraints(0, 1, 4, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(plus, gbc);
		add(plus);
		
		koemextension = new Panel();
		koemextension.setLayout(new GridLayout(1,0));
		Button button;
		button = new Button("Tare and unfix");
		button.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		button.setActionCommand("Tare");
		button.addActionListener(cmd);				
		koemextension.add(button);
		
		button = new Button("Tare and fix");
		button.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		button.setActionCommand("Tare and save");		
		button.addActionListener(cmd);
		koemextension.add(button);	
		
		buttonPercentTare = new Button("10% tare");
		buttonPercentTare.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonPercentTare.setActionCommand("perctare");
		buttonPercentTare.addActionListener(cmd);
		koemextension.add(buttonPercentTare);

		gbc = new GridBagConstraints(0, 2, 4, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(koemextension, gbc);
		add(koemextension);	

		misc1 = new Panel();
		misc1.setLayout(new GridLayout(1,0));	

		buttonFixPrice = new Button("fix price");
		buttonFixPrice.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonFixPrice.setActionCommand("fixp");
		buttonFixPrice.addActionListener(cmd);
		misc1.add(buttonFixPrice);
		
		buttonLimitWeightedTare = new Button("Limit weight tare 500");
		buttonLimitWeightedTare.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonLimitWeightedTare.setActionCommand("limitweighttare;0.500");
		buttonLimitWeightedTare.addActionListener(cmd);
		misc1.add(buttonLimitWeightedTare);
		
		buttonSetTarePrio = new Button("No T prio");
		buttonSetTarePrio.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonSetTarePrio.setActionCommand("tarePrio");
		buttonSetTarePrio.addActionListener(cmd);
		misc1.add(buttonSetTarePrio);	
		
		buttonSetFSDTare = new Button("enable FSD tare");
		buttonSetFSDTare.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonSetFSDTare.setActionCommand("fsdTare");
		buttonSetFSDTare.addActionListener(cmd);
		misc1.add(buttonSetFSDTare);
		
		gbc = new GridBagConstraints(0, 3, 4, 1, 100,100,GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);		
		gbl.setConstraints(misc1, gbc);
		add(misc1);	
		
		
		misc2 = new Panel();
		misc2.setLayout(new GridLayout(1,0));
		
		buttonLiveWeight = new Button("Live Weight");
		buttonLiveWeight.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonLiveWeight.setActionCommand("lw");
		buttonLiveWeight.addActionListener(cmd);
		misc2.add(buttonLiveWeight);
		
		button = new Button("Set zero");
		button.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		button.addActionListener(cmd);
		misc2.add(button);
		
		buttonHideShowWindow = new Button("Hide Window");
		buttonHideShowWindow.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonHideShowWindow.setActionCommand("hideShow");
		buttonHideShowWindow.addActionListener(cmd);
		misc2.add(buttonHideShowWindow);
		
		buttonHideShowOperatorWindow = new Button("Hide operator window");
		buttonHideShowOperatorWindow.setFont(new Font(Font.MONOSPACED,Font.BOLD,TestBizerbaJposGUI.scaleToResolutionHeight(10)));
		buttonHideShowOperatorWindow.setActionCommand("hideShowOpWindow");
		buttonHideShowOperatorWindow.addActionListener(cmd);
		misc2.add(buttonHideShowOperatorWindow);
		
		gbc = new GridBagConstraints(0, 4, 1, 1, 100,100,GridBagConstraints.NORTH , GridBagConstraints.BOTH, new Insets(1,1,1,1) , 0, 0);
		gbl.setConstraints(misc2, gbc);
		add(misc2);
		
		
	}
	/**
	 * Enables disables the buttons
	 * 
	 * @param enable
	 * 
	 * The application disables the buttons, when the weighinh process
	 * was started
	 * 
	 */	
	public void enableGui(boolean enable)
	{
		if(enable==true)
		{
			Component comps[] = getComponents();
			for(int i = 0;i < comps.length; i++)
			{
				Object obj = comps[i];
				if(obj instanceof Button)
				{
					comps[i].setEnabled(enable);					
				}
												
			}
		}
		if(currentWeightModeIsActive == true)
		{
			buttonLiveWeight.setEnabled(false);
			register.setEnabled(false);
			pricePer.setEnabled(false);
		}

	}	
	

	/**
	 * Update log and label on button
	 * 
	 * @param logIsOn
	 * @param labelingIsOn
	 */
	
	public void updateGUIButtons(boolean weightWindowIsHidden, boolean operatorWindowIshidden, boolean priceWasFixed, boolean tareWasLimited, boolean noTarePrio, boolean fsdTareEnable)
	{
		if(weightWindowIsHidden==true)
		{
			buttonHideShowWindow.setLabel("Show window");
			buttonHideShowWindow.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonHideShowWindow.setLabel("Hide window");
			buttonHideShowWindow.setBackground(Color.LIGHT_GRAY);	
		}		
		if(operatorWindowIshidden==true)
		{
			buttonHideShowOperatorWindow.setLabel("Show window");
			buttonHideShowOperatorWindow.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonHideShowOperatorWindow.setLabel("Hide operator window");
			buttonHideShowOperatorWindow.setBackground(Color.LIGHT_GRAY);	
		}
		
		if(priceWasFixed==true)
		{
			buttonFixPrice.setLabel("Price fixed");
			buttonFixPrice.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonFixPrice.setLabel("Price not fixed");
			buttonFixPrice.setBackground(Color.LIGHT_GRAY);
		}

		if(tareWasLimited==true)
		{
			buttonLimitWeightedTare.setLabel("unlimit weight tare");
			buttonLimitWeightedTare.setBackground(Color.YELLOW);			
		}
		else
		{
			buttonLimitWeightedTare.setLabel("Limit weight tare 500");
			buttonLimitWeightedTare.setBackground(Color.LIGHT_GRAY);
		}

		if(noTarePrio == true)
		{
			buttonSetTarePrio.setLabel("First T prio");
			buttonSetTarePrio.setBackground(Color.YELLOW);
		}
		else
		{
			buttonSetTarePrio.setLabel("No T prio");			
			buttonSetTarePrio.setBackground(Color.LIGHT_GRAY);
		}

		if(fsdTareEnable == true)
		{
			buttonSetFSDTare.setLabel("disable FSD tare");
			buttonSetFSDTare.setBackground(Color.YELLOW);
		}
		else
		{
			buttonSetFSDTare.setLabel("enable FSD tare");			
			buttonSetFSDTare.setBackground(Color.LIGHT_GRAY);
		}	
		
	}
	public void SetTestButtonPLU1()
	{
		ActionEvent ae = 
		          new ActionEvent((Object)buttonplu1, ActionEvent.ACTION_PERFORMED, "PLU1");
		       
		buttonplu1.dispatchEvent(ae); 

	}
	
	public void SetTestButtonPLU2()
	{
		ActionEvent ae = 
		          new ActionEvent((Object)buttonplu2, ActionEvent.ACTION_PERFORMED, "PLU2");
		       
		buttonplu2.dispatchEvent(ae); 

	}
	
	public void SetTestButtonRegister()
	{
		ActionEvent ae = 
		          new ActionEvent((Object)register, ActionEvent.ACTION_PERFORMED, "REGISTER");
		       
		register.dispatchEvent(ae); 

	}
	

}
