package com.bizerba.jpos.scalecsoem.UPOSLib;

import java.util.logging.*;

import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import com.bizerba.jpos.scalecsoem.UPOSLib.UposScaleProtos.*;
import com.google.protobuf.InvalidProtocolBufferException;

import zmq.ZError;

public class UposScaleZMQServer {
    private static final Logger logger = Logger.getLogger(UposScaleZMQServer.class.getName());
    private Thread worker = null;
    private static String port = "5559";
    private static ZContext context;
    private ZMQ.Socket socket = null;
    private static IUpdateDTCCS updateDTCCS;

    
    public UposScaleZMQServer(ZContext context, String port, IUpdateDTCCS updateDTCCS) {
    	UposScaleZMQServer.context = context;
    	UposScaleZMQServer.port = port;
    	UposScaleZMQServer.updateDTCCS = updateDTCCS;
    	
    	init();
    	worker.start();
    }
    
    private void init() {
        worker = new Thread(new Runnable() {
            public void run() {
            	lazyConnect();
            	while (!Thread.currentThread ().isInterrupted ()) {
            		try {
            			subscribe();
            		} catch (ZMQException e) {
            			if (e.getErrorCode() == ZMQ.Error.ETERM.getCode ()) {
            				break;
            			}
            		}
            	}
            	
            	socket.close();
            }
        });
    }
    
    public void stop() {
    	if (worker != null) {
    		try {
        		worker.interrupt();
				worker.join(3000);
			} catch (InterruptedException e) {
			}
    	}
    }
    
    private void lazyConnect() {
		if (socket == null){
			try {
				logger.info("Connect Socket to endpoint");
				socket = UposScaleZMQServer.context.createSocket(ZMQ.SUB);
				String clientaddr = "tcp://localhost:" + UposScaleZMQServer.port;
				logger.info("Client address: " + clientaddr);
				socket.connect (clientaddr);
				socket.subscribe("P".getBytes(ZMQ.CHARSET)); // subscribe to topic "P"
			} catch (ZMQException e) {
				if (e.getErrorCode() == ZError.ESOCKET)
				{
					logger.info("socket was terminated");
				} else if (e.getErrorCode() == ZError.ETERM) {
					logger.info("context was terminated");
				} else {
					logger.log(Level.SEVERE, "Exception occured", e);
				}
			}
		}		
	}
	
	
	private void statusUpdateDTCCS1(String dtccs1, int uposStatus)
	{		
		UposScaleZMQServer.updateDTCCS.updateDTCCS(dtccs1, uposStatus);		
	}
	
	private void subscribe() {
		socket.recvStr(); // topic "P"
		byte[] content = socket.recv(); // get data
		Req msg;
		try {
			msg = Req.parseFrom(content);
			if (msg.hasStringParam1() && msg.hasIntParam1()) {
				statusUpdateDTCCS1(msg.getStringParam1(), msg.getIntParam1());
			}
		} catch (InvalidProtocolBufferException e) {
			logger.log(Level.SEVERE, "Exception occured", e);
		}
	}
}
