package com.bizerba.jpos.scalecsoem.UPOSLib;

import java.io.IOException;
import java.util.logging.*;

import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQ.Poller;
import org.zeromq.ZMQException;

import com.bizerba.jpos.scalecsoem.UPOSLib.UposScaleProtos.*;
import com.google.protobuf.InvalidProtocolBufferException;

import zmq.ZError;

/**
 * This class implements the zmq Client to connect the JVM Process
 * with a native 32 bit server process 
 * 
 *  @remarks: This module contains approval relevant code                        
 *           If you change approval relevant code you have to increase APPROVAL_ID    
 *           and you have to induce a new authorization
 * 
 */
public class UposScaleZMQClient implements IUposScale {

	// members for Initialization
    private static final Logger logger = Logger.getLogger(UposScaleZMQClient.class.getName());
	public static final int APPROVAL_ID = 0;
	static Process process = null;
	private static final ZContext context = new ZContext(2);
	Poller items = context.createPoller(1);
	ZMQ.Socket socket = null;
	String processPath = "";
	String port = "";
	String publisherPort = "";
	IUpdateDTCCS _updateDTCCS;
	UposScaleZMQServer subscriber = null;


	public UposScaleZMQClient(String processpath, String port, String publisherPort, boolean autoStartZMQ, IUpdateDTCCS updateDTCCS) {
		this.processPath = processpath;
		this.port = port;
		this.publisherPort = publisherPort;
		this._updateDTCCS = updateDTCCS;
		InitZMQ(autoStartZMQ);
	}
	
	protected void InitZMQ(boolean autoStartZMQ)
	{
		if(process == null)
		{
			try {
				if(processPath.length() > 0 && autoStartZMQ == true)
				{
					/* Der Server wird mit dem open gestartet */
					process = new ProcessBuilder(processPath, port)
							.redirectErrorStream(true)
							.redirectOutput(ProcessBuilder.Redirect.INHERIT)
							.start();			
					lazyConnect();
				}
				else
				{
					/* Der Server wurde oder wird noch gestartet */
					lazyConnect();
				}
			}
			catch (IOException e) {
				e.printStackTrace();
			}
		}
		
		subscriber = new UposScaleZMQServer(UposScaleZMQClient.context, publisherPort, _updateDTCCS);
	}


	protected void lazyConnect() {
		if (socket == null){
			try {
				logger.info("Connect Socket to endpoint");
				socket = context.createSocket(ZMQ.REQ);
				String clientaddr = "tcp://localhost:" + port;
				logger.info("Client address: " + clientaddr);
				socket.connect (clientaddr);
				items.register(socket, ZMQ.Poller.POLLIN);
			} catch (ZMQException e) {
				if (e.getErrorCode() == ZError.ESOCKET)
				{
					logger.info("socket was terminated");
				} else if (e.getErrorCode() == ZError.ETERM) {
					logger.info("context was terminated");
				} else {
					logger.log(Level.SEVERE, "Exception occured", e);
				}
			}
		}		
	}

	protected synchronized Req sendMsg(Req request, long timeout) {
		Req msg = null;

		logger.info("Sending message.");
		socket.send(request.toByteArray());
		logger.info("Message sent, waiting for reply.\n");
		if (items.poll(timeout) != -1) {
			if (items.pollin(0)) {
				// Receive message
				byte[] reply = socket.recv(0);
				logger.info("Message received.");
				try {
					msg = Req.parseFrom(reply);
					logger.info("ErrorText: " + msg.getErrorText());
				} catch (InvalidProtocolBufferException e) {
					logger.log(Level.SEVERE, "Exception occured", e);
				}
			} else {
				msg = Req.newBuilder().setErrorCode(112).build(); // UPOS_E_TIMEOUT
			}
		}

		return msg;
	}


	protected synchronized Req sendMsg(Req request) {
		Req msg = null;

		logger.info("Sending message.");
		socket.send(request.toByteArray());
		logger.info("Message sent, waiting for reply.\n");

		// Receive message
		byte[] reply = socket.recv(0);
		logger.info("Message received.");
		try {
			msg = Req.parseFrom(reply);
			logger.info("ErrorText: " + msg.getErrorText());
		} catch (InvalidProtocolBufferException e) {
			logger.log(Level.SEVERE, "Exception occured", e);
		}	

		return msg;
	}


	// ID: 1
	public synchronized long OptionalPreInit(String configfile, String errorText[]) {

		// To construct a message, first construct a builder, fields are set to parameters' values, then the builder's build() method is called.
		Req request = Req.newBuilder()
				.setIdentifier(1)
				.setStringParam1(configfile)
				.build();
		Req reply = sendMsg(request);
		return reply.getErrorCode();
	}

	// ID: 2
	public synchronized long Exit() {
		logger.info("Exit!");
		Req request = Req.newBuilder()
				.setIdentifier(2)
				.build();
		Req reply = sendMsg(request);
		items.unregister(socket);
		socket.close();
		socket = null;
		context.destroy();
		if (subscriber != null) {
			subscriber.stop();
		}
		process = null;
		return 0;
	}

	// ID: 3
	public synchronized long Init(String moduleFileName1, String moduleFileName2, int approvalJava, String version,
			String errorText[]) {

		// To construct a message, first construct a builder, fields are set to parameters' values, then the builder's build() method is called.
		Req request = Req.newBuilder()
				.setIdentifier(3)
				.setStringParam1(moduleFileName1)
				.setStringParam2(moduleFileName2)
				.setStringParam3("051"+version)
				.setIntParam1(approvalJava)				
				.build();
		// Send message
		Req reply = sendMsg(request);
		return reply.getErrorCode();
	}

	// ID: 4
	public synchronized long Open(String name, long insthdl[], String errorText[]){	

		Req request = Req.newBuilder()
				.setIdentifier(4)
				.setStringParam1(name)
				.build();
		// Send message
		Req reply = sendMsg(request);
		insthdl[0] = reply.getLongParam1();
		logger.info("Insthdl: " + insthdl[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 5
	public synchronized long Close(long insthdl, String errorText[]) {

		Req request = Req.newBuilder()
				.setIdentifier(5)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request, 5000);
		return reply.getErrorCode();
	}

	// ID: 6
	public synchronized long Claim(long insthdl, long timeout_in_ms, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(6)
				.setInsthdl(insthdl)
				.setLongParam1(timeout_in_ms)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 7
	public synchronized long ReleaseDevice(long insthdl, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(7)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 8
	public synchronized long GetClaimed(long insthdl, boolean claimed[], String errorText[]) {

		Req request = Req.newBuilder()
				.setIdentifier(8)
				.setLongParam1(insthdl)
				.build();
		Req reply = sendMsg(request);
		claimed[0] = reply.getBoolParam();
		logger.info("Claimed: " + claimed[0]);
		return reply.getErrorCode();
	}

	// ID: 9
	public synchronized long GetDeviceEnabled(long insthdl, boolean[] enabled, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(9)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		enabled[0] = reply.getBoolParam();
		logger.info("Enabled: " + enabled[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 10
	public synchronized long SetDeviceEnabled(long insthdl, boolean enabled, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(10)
				.setInsthdl(insthdl)
				.setBoolParam(enabled)
				.build();
		Req reply = sendMsg(request, 2000);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 11
	public synchronized long GetState(long insthdl, long[] state, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(11)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		state[0] = reply.getLongParam1();
		logger.info("State: " + state[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 12
	public synchronized long DirectIO(long insthdl, long id, long[] data, Object[] datastring, String[] errorText) {
		Req request = Req.newBuilder()
				.setIdentifier(12)
				.setInsthdl(insthdl)
				.setLongParam1(id)
				.setLongParam2(data[0])
				.setStringParam1((String) datastring[0])
				.build();
		Req reply = sendMsg(request);
		data[0] = reply.getLongParam1();
		datastring[0] = reply.getStringParam1();
		logger.info("Data: " + data[0]);
		logger.info("Datastring: " + datastring[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 13
	public synchronized long SetAsyncMode(long insthdl, boolean asyncMode, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(13)
				.setInsthdl(insthdl)
				.setBoolParam(asyncMode)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 14
	public synchronized long GetAsyncMode(long insthdl, boolean[] asyncmode, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(14)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		asyncmode[0] = reply.getBoolParam();
		logger.info("Asyncmode: " + asyncmode[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 15
	public synchronized long CapDisplay(long insthdl, boolean[] capdisplay, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(15)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		capdisplay[0] = reply.getBoolParam();
		logger.info("Capdisplay: " + capdisplay[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 16
	public synchronized long CapDisplayText(long insthdl, boolean[] capdisplaytext, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(16)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		capdisplaytext[0] = reply.getBoolParam();
		logger.info("Capdisplaytext: " + capdisplaytext[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 17
	public synchronized long CapPriceCalculating(long insthdl, boolean[] cappricecalculating, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(17)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		cappricecalculating[0] = reply.getBoolParam();
		logger.info("Cappricecalculating: " + cappricecalculating[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 18
	public synchronized long CapTareWeight(long insthdl, boolean[] captareweight, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(18)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		captareweight[0] = reply.getBoolParam();
		logger.info("Captareweight: " + captareweight[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 19
	public synchronized long CapZeroScale(long insthdl, boolean[] capzeroweight, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(19)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		capzeroweight[0] = reply.getBoolParam();
		logger.info("Capzeroweight: " + capzeroweight[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 20
	public synchronized long GetMaxDisplayTextChars(long insthdl, long[] maxdisplaytextchars, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(20)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		maxdisplaytextchars[0] = reply.getLongParam1();
		logger.info("Maxdisplaytextchars: " + maxdisplaytextchars[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 21
	public synchronized long GetSalesPrice(long insthdl, long[] salesprice, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(21)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		salesprice[0] = reply.getLongParam1();
		logger.info("Salesprice: " + salesprice[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 22
	public synchronized long SetTareWeight(long insthdl, int tareWeight, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(22)
				.setInsthdl(insthdl)
				.setIntParam1(tareWeight)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 23
	public synchronized long GetTareWeight(long insthdl, long[] tareweight, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(23)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		tareweight[0] = reply.getLongParam1();
		logger.info("TareWeight: " + tareweight[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 24
	public synchronized long SetUnitPrice(long insthdl, long unitPrice, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(24)
				.setInsthdl(insthdl)
				.setLongParam1(unitPrice)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 25
	public synchronized long GetUnitPrice(long insthdl, long[] unitprice, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(25)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		unitprice[0] = reply.getLongParam1();
		logger.info("Unitprice: " + unitprice[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 26
	public synchronized long GetWeightUnit(long insthdl, long[] weightunit, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(26)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		weightunit[0] = reply.getLongParam1();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 27
	public synchronized long SetDisplayText(long insthdl, String text, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(27)
				.setInsthdl(insthdl)
				.setStringParam1(text)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 28
	public synchronized long ReadWeight(long insthdl, long[] readweight, long timeout, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(28)
				.setInsthdl(insthdl)
				.setLongParam1(timeout)
				.build();
		Req reply = sendMsg(request);
		readweight[0] = reply.getLongParam1();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 29
	public synchronized long ZeroScale(long insthdl, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(29)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 30
	public synchronized long ScaleLiveWeight(long insthdl, long[] liveweight, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(30)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		liveweight[0] = reply.getLongParam1();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 31
	public synchronized long GetMaximumWeight(long insthdl, long[] maximumweight, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(31)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		maximumweight[0] = reply.getLongParam1();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 32
	public synchronized long KillActualCommand(long insthdl, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(32)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 33
	public synchronized long GetDeviceServiceDescription(long insthdl, String[] serviceDescription, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(33)
				.build();
		Req reply = sendMsg(request);
		serviceDescription[0] = reply.getStringParam1();
		logger.info("Description " + serviceDescription[0]);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();	
	}

	// ID: 34
	public synchronized int GetDeviceServiceVersion() {

		Req request = Req.newBuilder()
				.setIdentifier(34)
				.build();
		Req reply = sendMsg(request);
		int version = 0;
		version = reply.getIntParam1();
		logger.info("Version: " + version);
		return version;	
	}

	// ID: 35
	public synchronized long CheckHealth(long insthdl, long level, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(35)
				.setInsthdl(insthdl)
				.setLongParam1(level)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 36
	public synchronized long GetHealthText(long insthdl, String[] healthText, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(36)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		healthText[0] = reply.getStringParam1();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 37
	public synchronized long ZeroValid(long insthdl, boolean[] zeroValid, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(37)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		zeroValid[0] = reply.getBoolParam();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 38
	public synchronized long DoPriceCalculating(long insthdl, int[] weightData, int[] tare, long[] unitPrice,
			long[] unitPriceX, int[] weightUnitX, int[] weightNumeratorX, int[] weightDenominatorX, long[] price,
			int timeout, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(38)
				.setInsthdl(insthdl)
				.setIntParam1(timeout)
				.build();
		Req reply = sendMsg(request);
		weightData[0] = reply.getIntParam1();
		tare[0] = reply.getIntParam2();
		unitPrice[0] = reply.getLongParam1();
		unitPriceX[0] = reply.getLongParam2();
		weightUnitX[0] = reply.getIntParam3();
		weightNumeratorX[0] = reply.getIntParam4();
		weightDenominatorX[0] = reply.getIntParam5();
		price[0] = reply.getLongParam3();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 39
	public synchronized long freezeValue(long insthdl, int item, boolean freeze, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(39)
				.setInsthdl(insthdl)
				.setIntParam1(item)
				.setBoolParam(freeze)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 40
	public synchronized long CapFreezeValue(long insthdl, boolean[] capFreezeValue, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(40)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		capFreezeValue[0] = reply.getBoolParam();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 41
	public synchronized long CapReadLiveWeightWithTare(long insthdl, boolean[] capReadLiveWeightWithTare,
			String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(41)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		capReadLiveWeightWithTare[0] = reply.getBoolParam();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 42
	public synchronized long CapSetPriceCalculationMode(long insthdl, boolean[] capSetPriceCalculationMode,
			String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(42)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		capSetPriceCalculationMode[0] = reply.getBoolParam();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 43
	public synchronized long CapSetUnitPriceWithWeightUnit(long insthdl, boolean[] capSetUnitPriceWithWeightUnit,
			String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(43)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		capSetUnitPriceWithWeightUnit[0] = reply.getBoolParam();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 44
	public synchronized long CapSpecialTare(long insthdl, boolean[] capSpecialTare, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(44)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		capSpecialTare[0] = reply.getBoolParam();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 45
	public synchronized long CapTarePriority(long insthdl, boolean[] capTarePriority, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(45)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		capTarePriority[0] = reply.getBoolParam();
		return reply.getErrorCode();
	}

	// ID: 46
	public synchronized long GetMinimumWeight(long insthdl, long[] minimumweight, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(46)
				.setInsthdl(insthdl)
				.build();
		Req reply = sendMsg(request);
		minimumweight[0] = reply.getLongParam1();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 47
	public synchronized long ReadLiveWeightWithTare(long insthdl, int[] weightData, int[] tare, int timeout,
			String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(47)
				.setInsthdl(insthdl)
				.setIntParam1(timeout)
				.build();
		Req reply = sendMsg(request);
		weightData[0] = reply.getIntParam1();
		tare[0] = reply.getIntParam2();
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 48
	public synchronized long SetPriceCalculationMode(long insthdl, int mode, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(48)
				.setInsthdl(insthdl)
				.setIntParam1(mode)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 49
	public synchronized long SetSpecialTare(long insthdl, int mode, int data, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(49)
				.setInsthdl(insthdl)
				.setIntParam1(mode)
				.setIntParam2(data)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 50
	public synchronized long SetTarePrioity(long insthdl, int priority, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(50)
				.setInsthdl(insthdl)
				.setIntParam1(priority)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}

	// ID: 51
	public synchronized long SetUnitPriceWithWeightUnit(long insthdl, long unitPrice, int weightUnit, int weightNumerator,
			int weightDenominator, String[] errorText) {

		Req request = Req.newBuilder()
				.setIdentifier(51)
				.setInsthdl(insthdl)
				.setLongParam1(unitPrice)
				.setIntParam1(weightUnit)
				.setIntParam2(weightNumerator)
				.setIntParam3(weightDenominator)
				.build();
		Req reply = sendMsg(request);
		errorText[0] = reply.getErrorText();
		return reply.getErrorCode();
	}
}