/** 
 * Implementation of Bizerba Scale Service Native interface  
 * Copyright (c) 2007-2014 BIZERBA
 *   
 * @author Reiner Moll 
 * @version 220-1 - 30.01.2014
 * 
 *  *  @remarks: This module contains approval relevant code                        
 *           If you change approval relevant code you have to increase APPROVAL_ID    
 *           and you have to induce a new authorization
 * 
 */
package com.bizerba.jpos.scalecsoem.UPOSLib;

public class NativeUposScale implements IUposScale {
	/** In case of approval relevant changes increase this ID */
	public static final int APPROVAL_ID = 1000;
	IUpdateDTCCS _updateDTCCS;
	public NativeUposScale(String library, IUpdateDTCCS updateDTCCS)
	{
			//System.loadLibrary("jposscalejni");
			System.load(library);
			_updateDTCCS = updateDTCCS;
	}
	void StatusUpdateDTCCS1(String dtccs1, int uposStatus)
	{		
		_updateDTCCS.updateDTCCS(dtccs1, uposStatus);		
	}
	public native long UPOSlibOptionalPreInit(String configfile,Object errorText[]);
	public native long UPOSlibInit(String moduleFileName1, String moduleFileName2, int approvalJava, Object errorText[]);
	public native long UPOSlibExit();
	public native long UPOSlibOpen( String name, long insthdl[], Object errorText[] );
	public native long UPOSlibClose(long insthdl, Object errorText[]);
	public native long UPOSlibClaim (long insthdl, long timeout_in_ms, Object errorText[]);	
	public native long UPOSlibReleaseDevice (long insthdl, Object errorText[]);
	public native long UPOSlibGetClaimed (long insthdl,boolean claimed[], Object errorText[]);
	public native long UPOSlibGetDeviceEnabled (long insthdl,boolean enabled[], Object errorText[]);
	public native long UPOSlibSetDeviceEnabled (long insthdl,boolean enabled, Object errorText[]);
	public native long UPOSlibGetState (long insthdl,long state[], Object errorText[]);
	public native long UPOSlibDirectIO( long insthdl, long id, long data[], Object datastring[], Object errorText[]);
	public native long UPOSlibSetAsyncMode(long insthdl, boolean  asyncMode, Object errorText[]);
	public native long UPOSlibGetAsyncMode(long insthdl, boolean  asyncMode[], Object errorText[]);
	public native long UPOSlibCapDisplay(long insthdl, boolean capDisplay[], Object errorTxt[]);
	public native long UPOSlibCapDisplayText(long insthdl, boolean capDisplayText[], Object errorTxt[]);
	public native long UPOSlibCapPriceCalculating(long insthdl, boolean capPriceCalculating[], Object errorTxt[]);
	public native long UPOSlibCapTareWeight(long insthdl, boolean capTareWeight[], Object errorTxt[]);
	public native long UPOSlibCapZeroScale(long insthdl, boolean capZeroScale[], Object errorTxt[]);
	public native long UPOSlibGetMaxDisplayTextChars(long insthdl, long maxDisplaychars[], Object errorTxt[]);
	public native long UPOSlibGetSalesPrice(long insthdl, long salesPrice[], Object errorTxt[]);
	public native long UPOSlibSetTareWeight(long insthdl, long  tareWeight, Object errorTxt[]);
	public native long UPOSlibGetTareWeight(long insthdl, long tareWeight[], Object errorTxt[]);
	public native long UPOSlibSetUnitPrice(long insthdl, long unitPrice, Object errorTxt[]);
	public native long UPOSlibGetUnitPrice(long insthdl, long unitPrice[], Object errorTxt[]);
	public native long UPOSlibGetWeightUnit(long insthdl, long weightUnit[], Object errorTxt[]);
	public native long UPOSlibSetDisplayText(long insthdl, String text, Object errorTxt[]);
	public native long UPOSlibReadWeight(long insthdl, long weight[], long timeout, Object errorTxt[]);
	public native long UPOSlibZeroScale(long insthdl, Object errorTxt[]);
	public native long UPOSlibScaleLiveWeight(long insthdl, long liveweight[], Object errorTxt[]);
	public native long UPOSlibGetMaximumWeight(long insthdl, long maximumweight[], Object errorTxt[]);
	public native long UPOSlibKillActualCommand(long insthdl,Object errorTxt[]);
	public native long UPOSlibCheckHealth(long insthdl, long level, Object[]errorText);
	public native long UPOSlibGetHealthText(long insthdl, Object[]healthText, Object[]errorText);
	public native long UPOSlibGetDeviceServiceDescription(long insthdl, Object[]deviceDescription,Object[]errorText);
	public native int UPOSlibGetDeviceServiceVersion();
	/* UPOS 1.13 */
	public native long UPOSlibZeroValid(long insthdl, boolean zeroValid[], Object errorTxt[]);	
	/* UPOS 1.14 */
	public native long UPOSlibDoPriceCalculating(long insthdl,int[] weightData, int[] tare, long[] unitPrice,
			long[] unitPriceX, int[] weightUnitX, int[] weightNumeratorX, int[] weightDenominatorX, long[] price,
			int timeout, Object errorTxt[]);
	public native long UPOSlibfreezeValue(long insthdl,int item, boolean freeze, Object errorTxt[]);	
	public native long UPOSlibCapFreezeValue(long insthdl, boolean capFreezeValue[], Object errorTxt[]);
	public native long UPOSlibCapReadLiveWeightWithTare(long insthdl, boolean capReadLiveWeightWithTare[], Object errorTxt[]);
	public native long UPOSlibCapSetPriceCalculationMode(long insthdl, boolean capSetPriceCalculationMode[], Object errorTxt[]);
	public native long UPOSlibCapSetUnitPriceWithWeightUnit(long insthdl, boolean capSetUnitPriceWithWeightUnit[], Object errorTxt[]);
	public native long UPOSlibCapSpecialTare(long insthdl, boolean capSpecialTare[], Object errorTxt[]);
	public native long UPOSlibCapTarePriority(long insthdl, boolean capTarePriority[], Object errorTxt[]);
	public native long UPOSlibGetMinimumWeight(long insthdl, long maximumweight[], Object errorTxt[]);
	public native long UPOSlibReadLiveWeightWithTare(long insthdl,int[] weightData, int[] tare, int timeout, Object errorTxt[]);
	public native long UPOSlibSetPriceCalculationMode(long insthdl, int mode, Object errorTxt[]);
	public native long UPOSlibSetSpecialTare(long insthdl, int mode, int data, Object errorTxt[]);
	public native long UPOSlibSetTarePrioity(long insthdl, int priority, Object errorTxt[]);
	public native long UPOSlibSetUnitPriceWithWeightUnit(long insthdl, long unitPrice, int weightUnit, int weightNumerator,			
			                                             int weightDenominator, Object errorTxt[]);
@Override
	public long OptionalPreInit(String configfile, String[] errorText) {
		return UPOSlibOptionalPreInit(configfile, errorText);
	}
	@Override
	public long Exit() {
		return UPOSlibExit();
	}
	@Override
	public long Init(String moduleFileName1, String moduleFileName2, int approvalJava, String version,
			String[] errorText) {
		return UPOSlibInit(moduleFileName1, moduleFileName2, approvalJava, errorText);
	}
	@Override
	public long Open(String name, long[] insthdl, String[] errorText) {
		return UPOSlibOpen(name, insthdl, errorText);
	}
	@Override
	public long Close(long insthdl, String[] errorText) {
		return UPOSlibClose(insthdl, errorText);
	}
	@Override
	public long Claim(long insthdl, long timeout_in_ms, String[] errorText) {
		return UPOSlibClaim(insthdl, timeout_in_ms, errorText);
	}
	@Override
	public long ReleaseDevice(long insthdl, String[] errorText) {
		return UPOSlibReleaseDevice(insthdl, errorText);
	}
	@Override
	public long GetClaimed(long insthdl, boolean[] claimed, String[] errorText) {
		return UPOSlibGetClaimed(insthdl, claimed, errorText);
	}
	@Override
	public long GetDeviceEnabled(long insthdl, boolean[] enabled, String[] errorText) {
		return UPOSlibGetDeviceEnabled(insthdl, enabled, errorText);
	}
	@Override
	public long SetDeviceEnabled(long insthdl, boolean enabled, String[] errorText) {
		return UPOSlibSetDeviceEnabled(insthdl, enabled, errorText);
	}
	@Override
	public long GetState(long insthdl, long[] state, String[] errorText) {
		return UPOSlibGetState(insthdl, state, errorText);
	}
	@Override
	public long DirectIO(long insthdl, long id, long[] data, Object[] datastring, String[] errorText) {
		return UPOSlibDirectIO(insthdl, id,data, datastring, errorText);
	}
	@Override
	public long SetAsyncMode(long insthdl, boolean asyncMode, String[] errorText) {
		return UPOSlibSetAsyncMode(insthdl, asyncMode, errorText);
	}
	@Override
	public long GetAsyncMode(long insthdl, boolean[] asyncmode, String[] errorText) {
		return 	UPOSlibGetAsyncMode(insthdl, asyncmode, errorText);
	}
	@Override
	public long CapDisplay(long insthdl, boolean[] capdisplay, String[] errorText) {
		return UPOSlibCapDisplay(insthdl, capdisplay, errorText);

	}
	@Override
	public long CapDisplayText(long insthdl, boolean[] capdisplaytext, String[] errorText) {
		return UPOSlibCapDisplayText(insthdl, capdisplaytext, errorText);
	}
	@Override
	public long CapPriceCalculating(long insthdl, boolean[] cappricecalculating, String[] errorText) {
		return UPOSlibCapPriceCalculating(insthdl, cappricecalculating, errorText);
	}
	@Override
	public long CapTareWeight(long insthdl, boolean[] captareweight, String[] errorText) {
		return UPOSlibCapTareWeight(insthdl, captareweight, errorText);
	}
	@Override
	public long CapZeroScale(long insthdl, boolean[] capzeroweight, String[] errorText) {
		return UPOSlibCapZeroScale(insthdl, capzeroweight, errorText);
	}
	@Override
	public long GetMaxDisplayTextChars(long insthdl, long[] maxdisplaytextchars, String[] errorText) {
		return UPOSlibGetMaxDisplayTextChars(insthdl, maxdisplaytextchars, errorText);
	}
	@Override
	public long GetSalesPrice(long insthdl, long[] salesprice, String[] errorText) {
		return UPOSlibGetSalesPrice(insthdl, salesprice, errorText);
	}
	@Override
	public long SetTareWeight(long insthdl, int tareWeight, String[] errorText) {
		return UPOSlibSetTareWeight(insthdl, tareWeight, errorText);
	}
	@Override
	public long GetTareWeight(long insthdl, long[] tareweight, String[] errorText) {
		return UPOSlibGetTareWeight(insthdl, tareweight, errorText);
	}
	@Override
	public long SetUnitPrice(long insthdl, long unitPrice, String[] errorText) {
		return UPOSlibSetUnitPrice(insthdl, unitPrice, errorText);
	}
	@Override
	public long GetUnitPrice(long insthdl, long[] unitprice, String[] errorText) {
		return UPOSlibGetUnitPrice(insthdl, unitprice, errorText);
	}
	@Override
	public long GetWeightUnit(long insthdl, long[] weightunit, String[] errorText) {
		return UPOSlibGetWeightUnit(insthdl, weightunit, errorText);
	}
	@Override
	public long SetDisplayText(long insthdl, String text, String[] errorText) {
		return UPOSlibSetDisplayText(insthdl, text, errorText);
	}
	@Override
	public long ReadWeight(long insthdl, long[] readweight, long timeout, String[] errorText) {
		return UPOSlibReadWeight(insthdl, readweight, timeout, errorText);
	}
	@Override
	public long ZeroScale(long insthdl, String[] errorText) {
		return UPOSlibZeroScale(insthdl, errorText);
	}
	@Override
	public long ScaleLiveWeight(long insthdl, long[] liveweight, String[] errorText) {
		return UPOSlibScaleLiveWeight(insthdl, liveweight, errorText);
	}
	@Override
	public long GetMaximumWeight(long insthdl, long[] maximumweight, String[] errorText) {
		return UPOSlibGetMaximumWeight(insthdl, maximumweight, errorText);
	}
	@Override
	public long KillActualCommand(long insthdl, String[] errorText) {
		return UPOSlibKillActualCommand(insthdl, errorText);
	}
	@Override
	public long GetDeviceServiceDescription(long insthdl, String[] deviceServiceDesctription, String[] errorText) {
		return UPOSlibGetDeviceServiceDescription(insthdl,  deviceServiceDesctription,  errorText);
	}
	@Override
	public int GetDeviceServiceVersion() {
		return UPOSlibGetDeviceServiceVersion();
	}
	@Override
	public long CheckHealth(long insthdl, long level, String[] errorText) {
		return UPOSlibCheckHealth(insthdl, level, errorText);
	}
	@Override
	public long GetHealthText(long insthdl, String[] healthText, String[] errorText) {
		return UPOSlibGetHealthText(insthdl, healthText, errorText);
	}
	@Override
	public long ZeroValid(long insthdl, boolean[] zeroValid, String[] errorText) {
		return UPOSlibZeroValid(insthdl, zeroValid, errorText);
	}
	@Override
	public long DoPriceCalculating(long insthdl, int[] weightData, int[] tare, long[] unitPrice,
			long[] unitPriceX, int[] weightUnitX, int[] weightNumeratorX, int[] weightDenominatorX, long[] price,
			int timeout, String[] errorText) {
		return UPOSlibDoPriceCalculating(insthdl, weightData, tare, unitPrice,
				unitPriceX, weightUnitX, weightNumeratorX, weightDenominatorX, price, timeout, errorText);
	}
	@Override
	public long freezeValue(long insthdl, int item, boolean freeze, String[] errorText) {
		return UPOSlibfreezeValue(insthdl, item, freeze, errorText);
	}
	@Override
	public long CapFreezeValue(long insthdl, boolean[] capFreezeValue, String[] errorText) {
		return UPOSlibCapFreezeValue(insthdl, capFreezeValue, errorText);
	}
	@Override
	public long CapReadLiveWeightWithTare(long insthdl, boolean[] capReadLiveWeightWithTare,
			String[] errorText) {
		return UPOSlibCapReadLiveWeightWithTare(insthdl, capReadLiveWeightWithTare, errorText);
	}
	@Override
	public long CapSetPriceCalculationMode(long insthdl, boolean[] capSetPriceCalculationMode,
			String[] errorText) {
		return UPOSlibCapSetPriceCalculationMode(insthdl, capSetPriceCalculationMode, errorText);
	}
	@Override
	public long CapSetUnitPriceWithWeightUnit(long insthdl, boolean[] capSetUnitPriceWithWeightUnit,
			String[] errorText) {
		return UPOSlibCapSetUnitPriceWithWeightUnit(insthdl, capSetUnitPriceWithWeightUnit, errorText);
	}
	@Override
	public long CapSpecialTare(long insthdl, boolean[] capSpecialTare, String[] errorText) {
		return UPOSlibCapSpecialTare(insthdl, capSpecialTare, errorText);
	}
	@Override
	public long CapTarePriority(long insthdl, boolean[] capTarePriority, String[] errorText) {
		return UPOSlibCapTarePriority(insthdl, capTarePriority, errorText);
	}
	@Override
	public long GetMinimumWeight(long insthdl, long[] minimumweight, String[] errorText) {
		return UPOSlibGetMinimumWeight(insthdl, minimumweight, errorText);
	}
	@Override
	public long ReadLiveWeightWithTare(long insthdl, int[] weightData, int[] tare, int timeout,
			String[] errorText) {
		return UPOSlibReadLiveWeightWithTare(insthdl, weightData, tare, timeout, errorText);
	}
	@Override
	public long SetPriceCalculationMode(long insthdl, int mode, String[] errorText) {
		return UPOSlibSetPriceCalculationMode(insthdl, mode, errorText);
	}
	@Override
	public long SetSpecialTare(long insthdl, int mode, int data, String[] errorText) {
		return UPOSlibSetSpecialTare(insthdl, mode, data, errorText);
	}
	@Override
	public long SetTarePrioity(long insthdl, int priority, String[] errorText) {
		return UPOSlibSetTarePrioity(insthdl, priority, errorText);
	}
	@Override
	public long SetUnitPriceWithWeightUnit(long insthdl, long unitPrice, int weightUnit, int weightNumerator,
			int weightDenominator, String[] errorText) {
		return UPOSlibSetUnitPriceWithWeightUnit(insthdl, unitPrice, weightUnit, weightNumerator, weightDenominator, errorText);
	}                                                         
	
	
}
	
	
	
	
	
	
	




