/* ---------------------------- *
 * 								*
 * (c) COPYRIGHT 2007 BIZERBA	*
 * 								*
 * ---------------------------- */

package com.bizerba.jpos.scalecsoem;

/**
 * This class implements the event used internally by scale driver's implementation
 * for wrapping JavaPOS specific DataEvents and ErrorEvents in order to put them into 
 * a central events queue in order to delivery them to the JavaPOS Scale Device Control
 * 
 * @author Bizerba
 * @version 1.00
 */

public class ScaleInternalEvent {

	public static final int DATA_TYPE = 1;
	public static final int ERROR_TYPE = 2;
	public static final int STATUS_TYPE = 3;
	public static final int DIRECTIO_TYPE = 4;
	

	private int iType;
	private Object objInfo;

	public ScaleInternalEvent() {
		iType = 0;
		objInfo = null;
	}

	/**
	 * Constructor of this class
	 * @param pType - event's type, possible value being one from 
	 * 				  DATA_TYPE and ERROR_TYPE declared as static constants in this class  
	 * @param pInfo - object representing the information content of this event: 
	 * 				  when type is DATA_TYPE then pInfo is an instance of ScaleDataResponse, 
	 * 				  and for ERROR_TYPE there should be an instance jpos.events.ErrorEvent 
	 */
	public ScaleInternalEvent(int pType, Object pInfo) {
		iType = pType;
		objInfo = pInfo;
	}

	public int getType() {
		return iType;
	}

	public Object getInfo() {
		return objInfo;
	}

	public void setType(int pType) {
		if (pType > 0) {
			iType = pType;
		}
	}

	public void setInfoObject(Object pObject) {
		objInfo = pObject;
	}
}
