/* ---------------------------- *
 * 								*
 * (c) COPYRIGHT 2007 BIZERBA	*
 * 								*
 * ---------------------------- */

package com.bizerba.jpos.scalecsoem;

import java.lang.reflect.Constructor;
import jpos.JposException;
import jpos.JposConst;
import jpos.config.JposEntry;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;

/**
 * Class that implements the JavaPOS specific interface
 * JposServiceInstanceFactory to provide the mechanism for obtaining an instance
 * of the JavaPOS Scale Device Service.
 * 
 * @author Bizerba
 * @version 1.00
 */

public class ScaleInstanceFactory implements JposServiceInstanceFactory {
	public ScaleInstanceFactory() {
	}

	/**
	 * This method create an instance of the JavaPOS Scale Device Service class
	 * based on the configuration entry identified in jpos.xml file by the
	 * logical name.
	 * 
	 * @param logicalName -
	 *            string containing the name used as
	 * 
	 */
	public JposServiceInstance createInstance(String logicalName,
			JposEntry entry) throws JposException {
		if (!entry.hasPropertyWithName("serviceClass")) {
			throw new JposException(JposConst.JPOS_E_NOSERVICE,
					"JposEntry does not contain the mandatory 'serviceClass' property");
		}

		JposServiceInstance serviceInstance = null;
		try {
			String serviceClassName = (String) entry
					.getPropertyValue("serviceClass");
			Class<?> serviceClass = Class.forName(serviceClassName);
			Constructor<?> constructor = serviceClass.getConstructor();
			serviceInstance = (JposServiceInstance) constructor.newInstance();
		} catch (Exception genEx) {
			throw new JposException(JposConst.JPOS_E_NOSERVICE,
					"Unable to obtain the service instance");
		}
		return serviceInstance;
	}

}
