/* ---------------------------- *
 * 								*
 * (c) COPYRIGHT 2007 BIZERBA	*
 * 								*
 * ---------------------------- */

package com.bizerba.jpos.scalecsoem;



/**
 * Interface grouping constant values used throughout the implementation of 
 * JavaPOS Device Service for Bizerba Scale 
 * 
 * @author Bizerba
 * @version 1.00
 * @version 1.10 15.02.2010 Reiner Moll extension for KOEM
 *               integration of named pipe for KOEM and CS3000SD
 * 
 */

public interface BizerbaScaleConstants {


	public static final int BUSCI_DIO_REQUEST_TARE = 2;
	// set tare and save: scale tares weight on the scale and saves the tare
	// customer Command not defined in UPOS
	public static final int BUSCI_DIO_REQUEST_SAVE_TARE = 3;	
	// set zero UPOS
	public static final int BUSCI_DIO_REQUEST_ZERO = 4;
	// Display version on customer Command not defined in UPOS
	public static final int BUSCI_DIO_REQUEST_DISPLAY_VERSION_ON = 5;
	// Display version off customer Command not defined in UPOS
	public static final int BUSCI_DIO_REQUEST_DISPLAY_VERSION_OFF = 6;
	// Labeling mode on  Command not defined in UPOS
	public static final int BUSCI_DIO_REQUEST_LABELING_ON = 7;
	// Labeling mode off  Command not defined in UPOS
	public static final int BUSCI_DIO_REQUEST_LABELING_OFF = 8;	
	// Request Current scale state Command not defined in UPOS
	public static final int BUSCI_DIO_REQUEST_CURRENT_SCALE_STATE = 9;
	// Display piece item customer Command not defined in UPOS 
	public static final int BUSCI_DIO_REQUEST_DISPLAY_PIECE_ITEM = 10;
	// Delete piece item customer Command not defined in UPOS
	public static final int BUSCI_DIO_REQUEST_DELETE_PIECE_ITEM = 11;
	// Display piece item with piece customer Command not defined in UPOS
	public static final int BUSCI_DIO_REQUEST_DISPLAY_PIECE_ITEM_PIECE = 12;
	// Display blank screen
	public static final int BUSCI_DIO_REQUEST_BLANC_SCREEN = 13;	
	// Hide Window
	public static final int BUSCI_DIO_REQUEST_HIDE_WINDOW = 14;
	// show Window
	public static final int BUSCI_DIO_REQUEST_SHOW_WINDOW = 15;
	// request authentication
	public static final int BUSCI_DIO_REQUEST_AUTH_INTEGRITY = 16;
	// request demo authentication
	public static final int BUSCI_DIO_REQUEST_AUTH_DEMO = 17;
	// request operation mode
	public static final int BUSCI_DIO_REQUEST_SET_OPERATION_MODE = 18;
	// request percent tare
	public static final int BUSCI_DIO_REQUEST_PERCENT_TARE = 19;
	// request fix function
	public static final int BUSCI_DIO_REQUEST_FIX = 20;
	// request set unit price based on weight unit
	public static final int BUSCI_DIO_REQUEST_SET_UNIT_PRICE_WEIGHT_UNIT = 21;
	// request get unit price based on weight unit
	public static final int BUSCI_DIO_REQUEST_GET_UNIT_PRICE_WEIGHT_UNIT = 22;	
	// request hide operator window
	public static final int BUSCI_DIO_REQUEST_HIDE_OPERATOR_WINDOW = 23;
	// request graduated prices
	public static final int BUSCI_DIO_REQUEST_GRADUATED_PRICES = 24;
	// request graduated prices extended
	public static final int BUSCI_DIO_REQUEST_GRADUATED_PRICES_EX = 25;
	// request get library version
	public static final int BUSCI_DIO_REQUEST_GETLIBRARYVERSION = 40;
	// request all library version
	public static final int BUSCI_DIO_REQUEST_GETALLLIBRARIESVERSIONS = 41;
	// request current scale state, weight unit, tare and weight 
	public static final int BUSCI_DIO_REQUEST_CURRENT = 800;
	// request different scale states
	public static final int BUSCI_DIO_REQUEST_STATE_BY_SELECTOR =           900;
	// request information about the scale
	public static final int BUSCI_DIO_REQUEST_SCALEINFO =                 903;
	// request limit the weighted tare
	public static final int BUSCI_DIO_REQUEST_SET_LIMITWEIGHTEDTARE =       906;
	// request get weight tare precisions of last price calculation
	public static final int BUSCI_DIO_REQUEST_GET_PREC_LAST_REG =           907;
	// request set FSD tare enable
	public static final int BUSCI_DIO_REQUEST_SET_FSD_TARE_ENABLE =        2000;
	// request set xlb
	public static final int BUSCI_DIO_REQUEST_SET_XLB =           2001;	
	// request current scale state, weight unit, tare and weight 
	public static final int BUSCI_DIO_EVENT_UPDATE_DTCCS = 401;
	// parameter for direct IO 18 set to self service 
	public static final String BUSCI_DIO_P_SET_OPERATION_MODE_SELFSERVICE = "0";
	// parameter for direct IO 18 set to labeling mode
	public static final String BUSCI_DIO_P_SET_OPERATION_MODE_LABELING = "1";
	// parameter for direct IO 18 set to operator mode
	public static final String BUSCI_DIO_P_SET_OPERATION_MODE_OPERATOR = "2";
	//Scale States
	public static final int BUSCI_STATE_VALID_WEIGHT = 0;
	// Scale in Error state
	public static final int BUSCI_STATE_ERROR = 1;
	// Scale Weight in underflow
	public static final int BUSCI_STATE_WEIGHT_UNDERFLOW = 2;
	// Scale Weight is zero
	public static final int BUSCI_STATE_WEIGHT_IS_ZERO = 3;
	// Scale Weight is not stabel
	public static final int BUSCI_STATE_WEIGHT_NOT_STABLE = 4;
	// Scale weight overflow 
	public static final int BUSCI_STATE_WEIGHT_OVERFLOW =   5;
	// Scale was not set to zero because of overweight
	public static final int BUSCI_STATE_WEIGHT_OVER_ZERO_SETRANGE  = 6;
	// scale was not set to zero because of under weight
	public static final int BUSCI_STATE_WEIGHT_UNDER_ZERO_SETRANGE = 7;
	// scale is in calibration mode
	public static final int BUSCI_STATE_SCALE_IN_CALIBRATION_MODE = 8;
	// scale tilt overflow
	public static final int BUSCI_STATE_TILT_OVERFLOW = 9;
	// The product has not positioned correctly on the load plate
	public static final int BUSCI_STATE_LOAD_CIRCUIT = 10;
	// Scale is deactivated display show blanks
	public static final int BUSCI_STATE_DISPLAY_BLANK_MODE = 11;
	// Scale is deactivated no weight mode is active
	public static final int BUSCI_STATE_IN_NW_MODE = 12;
	// Scale is deactivated window is hidden
	public static final int BUSCI_STATE_REG_FIXED = 13;
	// unload scale
	public static final int BUSCI_STATE_UNLOAD_SCALE = 14;	

    // Touch Event in windows of possacel
	public static final int POSSCALE_NOFIELD_TOUCH = 0;
	public static final int POSSCALE_TAREFIELD_TOUCH = 1;
	public static final int POSSCALE_WEIGHTFIELD_TOUCH = 2;
	public static final int POSSCALE_BASEFIELD_TOUCH = 3;
	public static final int POSSCALE_PRICEFIELD_TOUCH = 4;

}