/** 
 * Implementation of Bizerba Scale Service 114  
 * Copyright (c) 2007-2014 BIZERBA
 *   
 * @author Reiner Moll 
 * @version 2.201 - 28.01.2014
 * 
 */
package com.bizerba.jpos.scalecsoem;

import java.io.File;
import jpos.JposException;
import jpos.services.ScaleService114;
import com.bizerba.jpos.scalecsoem.UPOSLib.*;


/**
 * The {@code BizerbaCSScaleService114CS} class implements the
 * {@code ScaleService114} and represents the Device Service part of JavaPOS 1.14
 * scale driver for Bizerba Scale Model CS.
 * 
 * @author Bizerba
 * @version 3.001 11.05.2016 Reiner Moll  
 * 
 *  @remarks: This module contains approval relevant code                        
 *           If you change approval relevant code you have to increase APPROVAL_ID    
 *           and you have to induce a new authorization
 * 
 * 
 * @see ScaleService114
 */
public class BizerbaCSScaleService114CS extends BizerbaCSScaleService19 implements ScaleService114{
	
	/** In case of approval relevant changes increase this ID */
	public static final int APPROVAL_ID = 100;
	
	/**
	 * Constructor of the class. All attributtes are initalized to default
	 * values.
	 * 
	 */
	public BizerbaCSScaleService114CS() {
		approvalJava = APPROVAL_ID;
		approvalJava += BizerbaCSScaleService19.APPROVAL_ID;
		approvalJava += NativeUposScale.APPROVAL_ID;
		approvalJava += UposScaleZMQClient.APPROVAL_ID;
		approvalJava += UposScale.APPROVAL_ID;
		
		if(isLinux)
		{
			moduleFileNameZMQServer += "protozmqscale.x";
		}
		else
		{
			moduleFileNameZMQServer += "protozmqscale.exe";
		}
		if(moduleFileName1.endsWith(".dll"))
		{
			moduleFileName1.replace(".dll", "cs.dll");					
		}
		if(moduleFileName1.endsWith(".so"))
		{
			moduleFileName1 = moduleFileName1.replace(".so", "cs.so");
		}
		File f = new File(moduleFileName1);			
		if (f.exists() == false)
		{
			// Kommunikation via ZMQ Wrapper
			moduleFileName1 = moduleFileNameZMQServer;					
		}
		/* in case of ZMQ then start automatically if not defined in XML file */
		autoStartZMQ = true;
	}
	
	/**
	 * This method returns the integer value representing the version number for
	 * Device Service
	 * 
	 * @see jpos.services.BaseService#getDeviceServiceVersion()
	 */
	public int getDeviceServiceVersion() throws JposException
	{
		return UposScale.GetDeviceServiceVersion();
	}
	
	/**
	 * 
	 */	
	public boolean getZeroValid() throws JposException {
		checkOpened();
		return uposscale.getZeroValid();		
	}

	/**
	 * 
	 */
	public void setZeroValid(boolean setValid) throws JposException {
		setValid = false;		
	}

	/**
	 * 
	 */	
	public void doPriceCalculating(int[] weightData, int[] tare, long[] unitPrice,
			long[] unitPriceX, int[] weightUnitX, int[] weightNumeratorX, int[] weightDenominatorX, long[] price,
			int timeout) throws JposException {
		checkOpened();
		uposscale.doPriceCalculating(weightData, tare, unitPrice, unitPriceX, weightUnitX, weightNumeratorX, weightDenominatorX, price, timeout);		
	}

	/**
	 * 
	 */	
	public void freezeValue(int item, boolean freeze) throws JposException {
		checkOpened();
		uposscale.freezeValue(item, freeze);		
	}

	/**
	 * 
	 */	
	public boolean getCapFreezeValue() throws JposException {
		checkOpened();
		return uposscale.getCapFreezeValue();
	}

	/**
	 * 
	 */
	public boolean getCapReadLiveWeightWithTare() throws JposException {
		checkOpened();
		return uposscale.getCapReadLiveWeightWithTare();
	}

	/**
	 * 
	 */
	public boolean getCapSetPriceCalculationMode() throws JposException {
		checkOpened();
		return uposscale.getCapSetPriceCalculationMode();
	}

	/**
	 * 
	 */
	public boolean getCapSetUnitPriceWithWeightUnit() throws JposException {
		checkOpened();
		return uposscale.getCapSetUnitPriceWithWeightUnit();
	}

	/**
	 * 
	 */
	public boolean getCapSpecialTare() throws JposException {
		checkOpened();
		return uposscale.getCapSpecialTare();
	}

	/**
	 * 
	 */	
	public boolean getCapTarePriority() throws JposException {
		checkOpened();
		return uposscale.getCapTarePriority();
	}

	/**
	 * 
	 */
	public int getMinimumWeight() throws JposException {
		checkOpened();
		return uposscale.getMinimumWeight();
	}

	/**
	 * 
	 */
	public void readLiveWeightWithTare(int[] weightData, int[] tare, int timeout)
			throws JposException {		
		checkOpened();
		uposscale.readLiveWeightWithTare(weightData, tare, timeout);
		
	}

	/**
	 * 
	 */
	public void setPriceCalculationMode(int mode) throws JposException {
		checkOpened();
		uposscale.setPriceCalculationMode(mode);		
	}

	/**
	 * 
	 */
	public void setSpecialTare(int mode, int data) throws JposException {
		checkOpened();
		uposscale.setSpecialTare(mode, data);		
	}

	/**
	 * 
	 */
	public void setTarePrioity(int priority) throws JposException {
		checkOpened();
		uposscale.setTarePrioity(priority);
	}

	/**
	 * 
	 */
	public void setUnitPriceWithWeightUnit(long unitPrice, int weightUnit, int weightNumerator,
			int weightDenominator) throws JposException {
		checkOpened();
		uposscale.setUnitPriceWithWeightUnit(unitPrice, weightUnit, weightNumerator, weightDenominator);
	}
}
