@rem script of project RIK, Copyright 2012 by Bizerba GmbH&Co.KG, J. Moser, all rights reserved
@echo off
setlocal
rem ***************************************************************************************************
rem supported calls: uninstall.cmd 		uninstall posprinter
rem 
rem ***************************************************************************************************



REM ######################################################################### 
REM # main
REM ######################################################################### 

set CORENAME=oemprinter
set THISPRODUCTKEYNAME=posprinter

for %%i in (%0) do set curpath=%%~dpi
cd /d %curpath%

rem posprinter

call :GETFIRSTLINE THISSERVERVER ver.txt

set THISNAME=Bizerba RIK POSPrinter
set BIZERBA_PATH=%ProgramFiles%\Bizerba
set POSTHIS_PATH=%BIZERBA_PATH%\%THISPRODUCTKEYNAME%
set POS_THIS_KEY=./components/%CORENAME%/

rem # read dependencies
call :GETFIRSTLINE DEPFILEVER dep.txt
if "%DEPFILEVER%" NEQ "# boscfg dependency list file 1.00 #" (
echo dependency list file error
goto :ERROREND
)
call :GETLINE DEP1_POS_SCRIPTS_KEY DEP1_POS_SCRIPT_VER dep.txt 1

set DEP1_POS_SCRIPTS_KEY=./components/%DEP1_POS_SCRIPTS_KEY%/

echo %DATE% %TIME% ********** Uninstall of '%THISNAME%' started **********

REM ######################################################################### 
REM # set env for common scripts (exit 1 if not found)
REM ######################################################################### 

if exist setenv4commonscripts.cmd (
call setenv4commonscripts.cmd
) else (
rem we are probably in win/system32 et al
call "%POSTHIS_PATH%\setenv4commonscripts.cmd"
)

REM ######################################################################### 
REM # check if we have admin rights
REM ######################################################################### 

pushd "%BIZCOMMONSCRIPTS%"
call check_admin
popd
if "%admin%" EQU "N" goto :END

REM ######################################################################### 
REM # ignore dependencies ?
REM ######################################################################### 
if "%1" EQU "f" goto :FORCE

REM ######################################################################### 
REM # check for dependencies of this installation
REM ######################################################################### 

rem ***** CHECK FOR INSTALLED SCRIPTS VERSION ******************
set COMPONENT1_KEY=%DEP1_POS_SCRIPTS_KEY%
set COMPONENT1_MINVER=%DEP1_POS_SCRIPT_VER%
CALL %BIZCOMMONSCRIPTS%\checkdependencies.cmd
if "%errorlevel%" EQU "1" (
set ERRMSG=WITH ERRORS
goto :END
)

rem ***** CHECK FOR INSTALLED VERSION OF THIS ******************
set COMPONENT1_KEY=%POS_THIS_KEY%
set COMPONENT1_MINVER=%THISSERVERVER%
CALL %BIZCOMMONSCRIPTS%\checkdependencies.cmd
if "%errorlevel%" EQU "1" (
set ERRMSG=
goto :END
)

REM ######################################################################### 
REM # uninstall 
REM ######################################################################### 
:FORCE
echo removing %POS_THIS_KEY% from configuration...
@"%BOSCFGEXE%" deletekey -kn %POS_THIS_KEY% 1>nul
@"%BOSCFGEXE%" deletekey -kn ./%CORENAME%/ 1>nul

if "%1" EQU "f" goto :FORCE2
:NOTH_YET_INST1

rem we should be in programfiles => not when from reguninst, not when from boscfg
if exist "%POSTHIS_PATH%" (
CALL %BIZCOMMONSCRIPTS%\is_thisdir.cmd "%POSTHIS_PATH%"
if errorlevel 1 cd "%POSTHIS_PATH%"
echo off
)

:FORCE2
pushd winnt_x86
call uninst.cmd %1
popd

echo 3. deleting directories...
if exist "%POSTHIS_PATH%" (
attrib -R "%POSTHIS_PATH%\*.*"
echo @echo Please wait while deleting %THISNAME% in "%POSTHIS_PATH%" >"%TEMP%\del%CORENAME%.cmd"
echo @ping 127.0.0.1 ^>nul >>"%TEMP%\del%CORENAME%.cmd"
echo @rmdir /S /Q "%POSTHIS_PATH%" >>"%TEMP%\del%CORENAME%.cmd"
echo @del /F /Q "%TEMP%\del%CORENAME%.cmd" >>"%TEMP%\del%CORENAME%.cmd"
)

echo %DATE% %TIME% ********** uninstall of %THISNAME% finished **********
goto :END

:GETLINE
rem call :GETLINE VAR file line
SETLOCAL
( ENDLOCAL
  for /f "skip=%4 tokens=1-2" %%i in (%3) do (
 set "%~1=%%i%" 
 set "%~2=%%j%" 
 goto :EOF
)
)
goto :EOF

:GETFIRSTLINE
SETLOCAL
( ENDLOCAL
  for /f "delims=" %%i in (%2) do (
 set "%~1=%%i%" 
 goto :EOF
)
)
goto :EOF

:END
if exist "%TEMP%\del%CORENAME%.cmd" start /D "%TEMP%" del%CORENAME%.cmd

endlocal
