@rem script of project RIK, Copyright 2012 by Bizerba GmbH&Co.KG, J. Moser, all rights reserved
@echo off
setlocal

set OS_SYSTEM=32
if %PROCESSOR_ARCHITECTURE%==AMD64 (
    set OS_SYSTEM=64
)

if "%PROCESSOR_ARCHITEW6432%"=="AMD64" (
    set OS_SYSTEM=64
)


echo 2. creating folders...
echo creating %POSTHIS_PATH% ...
mkdir "%POSTHIS_PATH%" 2>nul
if not exist "%POSTHIS_PATH%" (
echo ERROR: target "%POSTHIS_PATH%" not created!
echo ABORTING INSTALLATION!
goto :ERROREND
)

echo 3. copying files...
xcopy /Y /S /E /V /F /R /K .. "%POSTHIS_PATH%" 1>nul
rmdir /s /q "%POSTHIS_PATH%\linux_x86" 1>nul
FOR /F %%D in ("%CD%") do set MYOLDDRIVE=%%~dD
FOR /F %%D in ("%POSTHIS_PATH%") do set MYDRIVE=%%~dD

%MYDRIVE%
pushd "%POSTHIS_PATH%"\winnt_x86

echo 3.2 setting environment
setx /? >NUL
if errorlevel 0 (
setx RIK_JARPATH "%POSTHIS_PATH%" /M
setx RIK_DLLPATH "%POSTHIS_PATH_%/winnt/" /M
)

echo installing version %THISSERVERVER% in directory:
call pwd.cmd

echo 4. writing POSPrinter entries to registry...
regedit /s BizPos.reg
IF not errorlevel 0 (
echo ERROR: regedit failed!
echo ERROR: Installation aborted!
popd
goto :ERROREND
)

echo registering bizerbaoposprinter.ocx ...
regsvr32 -s bizerbaoposprinter.ocx 
IF not errorlevel 0 (
echo ERROR: Registration of bizerbaoposprinter.ocx failed!
echo ERROR: Installation aborted!
popd
goto :ERROREND
)

if %OS_SYSTEM%==64 (
     Powershell.exe -ExecutionPolicy Bypass -Command "& '.\bizregisterOPOS64.ps1'"
) else (
    del "%ProgramFiles%\bizerba\posprinter\winnt_x86\POSDynamicXMLTest64.exe" /F/Q   
    del "%ProgramFiles%\bizerba\posprinter\winnt_x86\bizerbaoposprinter64.ocx" /F/Q   
)

popd
goto :OKEND

:ERROREND
echo %DATE% %TIME% ********** %MSG% of '%THISNAME%' finished %ERRMSG% **********
endlocal
exit /B 1
goto :FIN

:OKEND
echo %DATE% %TIME% ********** %MSG% of '%THISNAME%' finished %ERRMSG% **********
endlocal
exit /B 0
goto :FIN

:FIN