@rem script of project RIK, Copyright 2012 by Bizerba GmbH&Co.KG, J. Moser, all rights reserved
@echo off
setlocal
rem ***************************************************************************************************
rem supported calls: bizinstaller.cmd 		install posprinter
rem supported calls: bizinstaller.cmd r		remove
rem 
rem ***************************************************************************************************

REM ######################################################################### 
REM # EDIT HERE
set CORENAME=oemprinter
set THISPRODUCTKEYNAME=posprinter
set THISNAME=Bizerba RIK POSPrinter
set THISIMAGE=posprinter.txt
REM ######################################################################### 

REM ######################################################################### 
REM # load variables
REM ######################################################################### 
set DEP_COMPONENT1_KEY=
set DEP_COMPONENT1_VER=
set DEP_COMPONENT2_KEY=
set DEP_COMPONENT2_VER=

rem change current dir to this
for %%i in (%0) do set curpath=%%~dpi 
cd /d %curpath% 

rem load thisversion
call :GETFIRSTLINE THISSERVERVER ver.txt

set BIZERBA_PATH=%ProgramFiles%/Bizerba
set POSTHIS_PATH=%BIZERBA_PATH%/%THISPRODUCTKEYNAME%
set LOCALINSTALLSUBDIR=.
set POS_THIS_KEY=./components/%CORENAME%/
set POS_THIS_CLASS=./%CORENAME%/classes/appargs/

rem # read dependencies
call :GETFIRSTLINE DEPFILEVER dep.txt
if "%DEPFILEVER%" NEQ "# boscfg dependency list file 1.00 #" (
echo dependency list file error
goto :ERROREND
)
call :GETLINE DEP_COMPONENT1_KEY DEP_COMPONENT1_VER dep.txt 1
set DEP_COMPONENT1_KEY=./components/%DEP_COMPONENT1_KEY%/

set SHORTTHISPATH=
for %%A in ("%POSTHIS_PATH%") do set SHORTTHISPATH=%%~sdpnxA

set INSTALL_PATH=%CD%
set MSG=Install

REM ######################################################################### 
REM # main
REM ######################################################################### 

if "%1" EQU "r" goto :SKIPINTROECHO
echo %DATE% %TIME% ********** Install of '%THISNAME%' started **********
:SKIPINTROECHO

REM ######################################################################### 
REM # set env for common scripts (exit 1 if not found)
REM ######################################################################### 
call %LOCALINSTALLSUBDIR%/setenv4commonscripts.cmd

REM ######################################################################### 
REM # check if we have admin rights
REM ######################################################################### 
pushd "%BIZCOMMONSCRIPTS%"
call check_admin
popd
if "%admin%" EQU "N" goto :ERROREND


REM ######################################################################### 
REM # check for this uninstallation
REM ######################################################################### 
if "%1" EQU "r" (
set MSG=Uninstall
if "%2" EQU "f" (
echo forcing uninstallation, no backup of config!!!
call %LOCALINSTALLSUBDIR%\uninstall.cmd %2
goto :OKEND
)
CALL :CALLNORMALUNINST
goto :OKEND
)

REM ######################################################################### 
REM # check for dependencies of this installation
REM ######################################################################### 

rem ***** CHECK FOR INSTALLED SCRIPTS VERSION ******************
set COMPONENT1_KEY=%DEP_COMPONENT1_KEY%
set COMPONENT1_MINVER=%DEP_COMPONENT1_VER%
CALL %BIZCOMMONSCRIPTS%\checkdependencies.cmd
if "%errorlevel%" EQU "1" (
set ERRMSG=WITH ERRORS
goto :ERROREND
)

rem ***** CHECK FOR INSTALLED VERSION OF THIS ******************
set COMPONENT1_KEY=%POS_THIS_KEY%
set COMPONENT1_MINVER=%THISSERVERVER%
CALL %BIZCOMMONSCRIPTS%\checkdependencies.cmd NONOTFOUND
if "%errorlevel%" EQU "0" (
  echo Installed %THISNAME% is same or newer.
  echo Nothing is changed.

  goto :OKEND
) 

if "%errorlevel%" EQU "1" set UNINSTALL_BEFORE_INSTALL=FALSE
if "%errorlevel%" EQU "2" set UNINSTALL_BEFORE_INSTALL=TRUE

if "%UNINSTALL_BEFORE_INSTALL%" EQU "TRUE" CALL :CALLNORMALUNINST

REM ######################################################################### 
REM # install 
REM ######################################################################### 

echo 1. start install...
call inst.cmd %1
if "%errorlevel%" neq "0" goto :ERROREND

if not exist "%POSTHIS_PATH%\%THISIMAGE%" (
set ERRMSG=WITH ERRORS
goto :ERROREND
)

rem ***** restore boscfg.ini  *********************************
echo 5. config restore...

rem ### create config settings
echo 6. updating configuration...

@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY% -vn versionbuild -v "%THISSERVERVER%" 1>nul
rem restore checks versionbuild!
pushd %BIZCOMMONSCRIPTS% 1>nul
call %BIZCOMMONSCRIPTS%\restore_config_subset.cmd
popd
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY% -vn installpath -v "%SHORTTHISPATH%\\" 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY% -vn displayname -v "%THISNAME%" 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY% -vn uninstall -v "\"%SHORTTHISPATH%\winnt_x86\uninstall.cmd\"" 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY% -vn sharedobjectfilename -v "%SHORTTHISPATH%\winnt_x86\uposdll.dll" 1>nul

rem call %BIZCOMMONSCRIPTS%\setBIZERBACOMMONAPPDATA.cmd
rem to set USERSGROUPNAME and BIZERBACOMMONAPPDATA
pushd %BIZCOMMONSCRIPTS% 1>nul
call %BIZCOMMONSCRIPTS%\prep_paths.cmd
popd

set RIKDATAPATH=%BIZERBACOMMONAPPDATA%/%THISPRODUCTKEYNAME%/
set RIKFONTCACHE=%RIKDATAPATH%fontcache
set RIKFONTCACHESRC=%POSTHIS_PATH%/fontcache
rem createdir n rights
mkdir "%RIKDATAPATH%" 2>NUL
mkdir "%RIKFONTCACHE%" 2>NUL
echo Y| cacls "%RIKFONTCACHE%" /E /T /C /G "%USERSGROUPNAME%":F>nul
REM fontcache immer loeschen
echo delete fontcache
del "%RIKFONTCACHE%"\*.* /Q/F/S 1>nul 2>nul

REM copy fontcache
echo copy fontcache
copy "%RIKFONTCACHESRC%"\*.* "%RIKFONTCACHE%"
rmdir /s /q "%RIKFONTCACHESRC%" 1>nul

@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY% -vn datapath -v "%RIKDATAPATH%" 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_CLASS% -vn fontcache -v "%RIKFONTCACHE%\\" 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_CLASS% -vn fontspath -v "%SHORTTHISPATH%/fonts/" 1>nul
rem !set font pathes also in tests.ini to enable printer tests on production line
attrib -R "%POSTHIS_PATH%/test_data/tests.ini" 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY% -vn installpath -v "%SHORTTHISPATH%\\" -i "%POSTHIS_PATH%/test_data/tests" 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY% -vn datapath -v "%RIKDATAPATH%" -i "%POSTHIS_PATH%/test_data/tests" 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_CLASS% -vn fontcache -v "%RIKFONTCACHE%\\" -i "%POSTHIS_PATH%/test_data/tests" 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_CLASS% -vn fontspath -v "%SHORTTHISPATH%/fonts/" -i "%POSTHIS_PATH%/test_data/tests" 1>nul

rem !fontcache is not deleted on uninstall

if "%DEP_COMPONENT1_KEY%" NEQ "" (
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY%dependencies/0001/ -vn versionbuild -v %DEP_COMPONENT1_VER% 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY%dependencies/0001/ -vn name -v %DEP_COMPONENT1_KEY% 1>nul
)
if "%DEP_COMPONENT2_KEY%" NEQ "" (
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY%dependencies/0002/ -vn versionbuild -v %DEP_COMPONENT2_VER% 1>nul
@"%BOSCFGEXE%" setvaluestrutf8 -kn %POS_THIS_KEY%dependencies/0002/ -vn name -v %DEP_COMPONENT2_KEY% 1>nul
)
@"%BOSCFGEXE%" deletevalue -kn %POS_THIS_KEY% -vn refcount 1>nul


rem call "%BIZCOMMONSCRIPTS%\reg4rikstartstop.cmd" printerflush v00.00_b0000 7 "%SHORTTHISPATH%\winnt_x86\" printerflush.cmd


set ERRMSG=SUCCESSFULLY.
goto :OKEND

REM ######################################################################### 
REM # subroutines
REM ######################################################################### 

:CALLNORMALUNINST
rem ***** backup boscfg.ini  
echo 0. config backup...
pushd %BIZCOMMONSCRIPTS% 1>nul
call %BIZCOMMONSCRIPTS%\backup_config_subset.cmd
popd

set MYT=
for /f "Tokens=*" %%a in ('%BOSCFGEXE% existsvalue -kn %POS_THIS_KEY% -vn uninstall^|find /i "TRUE"') do set MYT=%%a
if "TRUE" NEQ "%MYT%" goto :SKIPEXIST_UNINST

set MYT=
for /f "Tokens=*" %%a in ('%BOSCFGEXE% getvaluestrutf8 -kn %POS_THIS_KEY% -vn uninstall^|find /i ".cmd"') do set MYT=%%a
set UNINSTCMDLINE=%MYT%

echo calling uninstallation...
call %UNINSTCMDLINE%
@ping -n 6 127.0.0.1 1>nul 

:SKIPEXIST_UNINST
if not exist "%POSTHIS_PATH%" goto :EOF
rem second try
if exist "%SHORTTHISPATH%\uninstall.cmd" (
"%SHORTTHISPATH%\uninstall.cmd"
) else (
call %LOCALINSTALLSUBDIR%\uninstall.cmd
)
goto :EOF

REM ######################################################################### 
REM # END
REM ######################################################################### 

:ERROREND
echo %DATE% %TIME% ********** %MSG% of '%THISNAME%' finished %ERRMSG% **********
endlocal
exit /B 1
goto :FIN

:GETLINE
rem call :GETLINE VAR file line for reading dependecies
SETLOCAL
( ENDLOCAL
  for /f "skip=%4 tokens=1-2" %%i in (%3) do (
 set "%~1=%%i%" 
 set "%~2=%%j%" 
 goto :EOF
)
)
goto :EOF

:GETFIRSTLINE
rem for reading versions
SETLOCAL
( ENDLOCAL
  for /f "delims=" %%i in (%2) do (
 set "%~1=%%i%" 
 goto :EOF
)
)
goto :EOF

:OKEND
echo %DATE% %TIME% ********** %MSG% of '%THISNAME%' finished %ERRMSG% **********
endlocal
exit /B 0
goto :FIN

:FIN
