/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.EncoderBase;
import zmq.IMsgSource;
import zmq.Msg;

public class V1Encoder
extends EncoderBase {
    private static final int SIZE_READY = 0;
    private static final int MESSAGE_READY = 1;
    private Msg inProgress;
    private final byte[] tmpbuf = new byte[9];
    private final ByteBuffer tmpbufWrap = ByteBuffer.wrap(this.tmpbuf);
    private IMsgSource msgSource;

    public V1Encoder(int bufsize, IMsgSource session) {
        super(bufsize);
        this.msgSource = session;
        this.nextStep(null, 0, 1, true);
    }

    @Override
    public void setMsgSource(IMsgSource msgSource) {
        this.msgSource = msgSource;
    }

    @Override
    protected boolean next() {
        switch (this.state()) {
            case 0: {
                return this.sizeReady();
            }
            case 1: {
                return this.messageReady();
            }
        }
        return false;
    }

    private boolean sizeReady() {
        this.nextStep(this.inProgress.buf(), 1, !this.inProgress.hasMore());
        return true;
    }

    private boolean messageReady() {
        if (this.msgSource == null) {
            return false;
        }
        this.inProgress = this.msgSource.pullMsg();
        if (this.inProgress == null) {
            return false;
        }
        int protocolFlags = 0;
        if (this.inProgress.hasMore()) {
            protocolFlags |= 1;
        }
        if (this.inProgress.size() > 255) {
            protocolFlags |= 2;
        }
        this.tmpbuf[0] = (byte)protocolFlags;
        int size = this.inProgress.size();
        this.tmpbufWrap.position(0);
        if (size > 255) {
            this.tmpbufWrap.limit(9);
            this.tmpbufWrap.putLong(1, size);
            this.nextStep(this.tmpbufWrap, 0, false);
        } else {
            this.tmpbufWrap.limit(2);
            this.tmpbuf[1] = (byte)size;
            this.nextStep(this.tmpbufWrap, 0, false);
        }
        return true;
    }
}

