/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import zmq.Command;
import zmq.Ctx;
import zmq.IPollEvents;
import zmq.Mailbox;
import zmq.Poller;
import zmq.SocketBase;
import zmq.ZObject;

public class Reaper
extends ZObject
implements IPollEvents,
Closeable {
    private final Mailbox mailbox;
    private final SelectableChannel mailboxHandle;
    private final Poller poller;
    private int socketsReaping = 0;
    private final AtomicBoolean terminating = new AtomicBoolean();
    private String name;

    public Reaper(Ctx ctx, int tid) {
        super(ctx, tid);
        this.name = "reaper-" + tid;
        this.poller = new Poller(this.name);
        this.mailbox = new Mailbox(this.name);
        this.mailboxHandle = this.mailbox.getFd();
        this.poller.addHandle(this.mailboxHandle, this);
        this.poller.setPollIn(this.mailboxHandle);
    }

    @Override
    public void close() throws IOException {
        this.poller.destroy();
        this.mailbox.close();
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public void start() {
        this.poller.start();
    }

    public void stop() {
        if (!this.terminating.get()) {
            this.sendStop();
        }
    }

    @Override
    public void inEvent() {
        Command cmd;
        while ((cmd = this.mailbox.recv(0L)) != null) {
            cmd.destination().processCommand(cmd);
        }
    }

    @Override
    public void outEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timerEvent(int id) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void processStop() {
        this.terminating.set(true);
        if (this.socketsReaping == 0) {
            this.finishTerminating();
        }
    }

    @Override
    protected void processReap(SocketBase socket) {
        ++this.socketsReaping;
        socket.startReaping(this.poller);
    }

    @Override
    protected void processReaped() {
        --this.socketsReaping;
        if (this.socketsReaping == 0 && this.terminating.get()) {
            this.finishTerminating();
        }
    }

    private void finishTerminating() {
        this.sendDone();
        this.poller.removeHandle(this.mailboxHandle);
        this.poller.stop();
    }
}

