/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.zeromq.ZMQ;

public class ZFrame {
    public static final int MORE = 2;
    public static final int REUSE = 128;
    public static final int DONTWAIT = 1;
    private boolean more;
    private byte[] data;
    private static final String HEX_CHAR = "0123456789ABCDEF";

    protected ZFrame() {
    }

    public ZFrame(byte[] data) {
        if (data != null) {
            this.data = data;
        }
    }

    public ZFrame(String data) {
        if (data != null) {
            this.data = data.getBytes(ZMQ.CHARSET);
        }
    }

    public void destroy() {
        if (this.hasData()) {
            this.data = null;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean hasMore() {
        return this.more;
    }

    public int size() {
        if (this.hasData()) {
            return this.data.length;
        }
        return 0;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean send(ZMQ.Socket socket, int flags) {
        if (socket == null) {
            throw new IllegalArgumentException("socket parameter must be set");
        }
        return socket.send(this.data, flags);
    }

    public boolean sendAndKeep(ZMQ.Socket socket, int flags) {
        return this.send(socket, flags);
    }

    public boolean sendAndKeep(ZMQ.Socket socket) {
        return this.sendAndKeep(socket, 0);
    }

    public boolean sendAndDestroy(ZMQ.Socket socket, int flags) {
        boolean ret = this.send(socket, flags);
        if (ret) {
            this.destroy();
        }
        return ret;
    }

    public boolean sendAndDestroy(ZMQ.Socket socket) {
        return this.sendAndDestroy(socket, 0);
    }

    public ZFrame duplicate() {
        return new ZFrame(this.data);
    }

    public boolean hasSameData(ZFrame other) {
        if (other == null) {
            return false;
        }
        if (this.size() == other.size()) {
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }

    public void reset(String data) {
        this.data = data.getBytes(ZMQ.CHARSET);
    }

    public void reset(byte[] data) {
        this.data = data;
    }

    public String strhex() {
        StringBuilder b = new StringBuilder();
        for (byte aData : this.data) {
            int b1 = aData >>> 4 & 0xF;
            int b2 = aData & 0xF;
            b.append(HEX_CHAR.charAt(b1));
            b.append(HEX_CHAR.charAt(b2));
        }
        return b.toString();
    }

    public boolean streq(String str) {
        if (!this.hasData()) {
            return false;
        }
        return new String(this.data, ZMQ.CHARSET).compareTo(str) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZFrame zFrame = (ZFrame)o;
        return Arrays.equals(this.data, zFrame.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        if (!this.hasData()) {
            return "";
        }
        boolean isText = true;
        for (byte aData : this.data) {
            if (aData >= 32 && aData <= 127) continue;
            isText = false;
            break;
        }
        if (isText) {
            return new String(this.data, ZMQ.CHARSET);
        }
        return this.strhex();
    }

    private byte[] recv(ZMQ.Socket socket, int flags) {
        if (socket == null) {
            throw new IllegalArgumentException("socket parameter must not be null");
        }
        this.data = socket.recv(flags);
        this.more = socket.hasReceiveMore();
        return this.data;
    }

    public static ZFrame recvFrame(ZMQ.Socket socket) {
        return ZFrame.recvFrame(socket, 0);
    }

    public static ZFrame recvFrame(ZMQ.Socket socket, int flags) {
        ZFrame f = new ZFrame();
        byte[] data = f.recv(socket, flags);
        if (data == null) {
            return null;
        }
        return f;
    }

    public void print(String prefix) {
        int charNbr;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (prefix != null) {
            pw.printf("%s", prefix);
        }
        byte[] data = this.getData();
        int size = this.size();
        boolean isBin = false;
        for (charNbr = 0; charNbr < size; ++charNbr) {
            if (data[charNbr] >= 9 && data[charNbr] <= 127) continue;
            isBin = true;
        }
        pw.printf("[%03d] ", size);
        int maxSize = isBin ? 35 : 70;
        String elipsis = "";
        if (size > maxSize) {
            size = maxSize;
            elipsis = "...";
        }
        for (charNbr = 0; charNbr < size; ++charNbr) {
            if (isBin) {
                pw.printf("%02X", data[charNbr]);
                continue;
            }
            pw.printf("%c", data[charNbr]);
        }
        pw.printf("%s\n", elipsis);
        pw.flush();
        pw.close();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.print(sw.toString());
    }
}

