/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.Messages;
import com.jrockit.mc.ui.model.fields.NumberField;
import java.text.ParseException;
import org.eclipse.osgi.util.NLS;

public final class TimespanParser {
    public static Long parse(Tokenizer tokenizer) throws ParseException {
        long timeSpan = 0L;
        TimeFactor[] TIMESPAN_FACTORS = TimeFactor.values();
        int timeFactorIndex = 0;
        while (tokenizer.hasNext() && timeFactorIndex < TIMESPAN_FACTORS.length) {
            double value = TimespanParser.parseDouble(tokenizer);
            if (Double.isNaN(value)) break;
            if (tokenizer.hasNext()) {
                String text = tokenizer.peek().text;
                TimeFactor tf = TimeFactor.lookup(text, TIMESPAN_FACTORS[timeFactorIndex]);
                if (tf == null || tf.ordinal() < timeFactorIndex) break;
                ++timeFactorIndex;
                timeSpan += Math.round(value * (double)tf.getNanos());
                tokenizer.next();
                continue;
            }
            throw new ParseException(NLS.bind((String)Messages.TimespanParser_MISSING_UNIT_FOR_X, (Object)NumberField.formatNumber(value)), 0);
        }
        return timeFactorIndex > 0 ? Long.valueOf(timeSpan) : null;
    }

    private static double parseDouble(Tokenizer tokenizer) {
        try {
            return NumberField.parseNumber(tokenizer);
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    static enum TimeFactor {
        weeks(604800000000000L, "wk", "week", "weeks"),
        days(86400000000000L, "d", "day", "days"),
        hours(3600000000000L, "h", "hour", "hours"),
        minutes(60000000000L, "min", "minute", "minutes"),
        seconds(1000000000L, "s", "second", "seconds"),
        millis(1000000L, "ms", "milli", "millis", "millisecond", "milliseconds"),
        micros(1000L, "us", "\u03bcs", "micro", "micros", "microsecond", "microseconds"),
        nanos(1L, "ns", "nano", "nanos", "nanosecond", "nanoseconds");

        private final long m_nanos;
        private final String[] m_identifier;

        private TimeFactor(long seconds, String ... identifier) {
            this.m_identifier = identifier;
            this.m_nanos = seconds;
        }

        public String[] getRepresentations() {
            return this.m_identifier;
        }

        public long getNanos() {
            return this.m_nanos;
        }

        public static TimeFactor lookup(String identifier, TimeFactor startFactor) {
            TimeFactor[] timeFactorArray = TimeFactor.values();
            int n = timeFactorArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimeFactor f = timeFactorArray[n2];
                if (f.ordinal() >= startFactor.ordinal()) {
                    String[] stringArray = f.getRepresentations();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String rep = stringArray[n4];
                        if (rep.equals(identifier)) {
                            return f;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return null;
        }

        public static TimeFactor lookup(String identifier) {
            return TimeFactor.lookup(identifier, TimeFactor.values()[0]);
        }
    }
}

