/*
 * Decompiled with CFR 0.152.
 */
package com.bizerba.jpos.PosPrinter.UPOSLib;

import com.bizerba.jpos.PosPrinter.UPOSLib.IUposPrinter;
import com.bizerba.jpos.PosPrinter.UPOSLib.UposPrinterProtos;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class UposPrinterZMQClient
implements IUposPrinter {
    private static final Logger logger = Logger.getLogger(UposPrinterZMQClient.class.getName());
    public static final int APPROVAL_ID = 0;
    static Process process = null;
    private static final ZContext context = new ZContext(2);
    ZMQ.Poller items = context.createPoller(1);
    ZMQ.Socket socket = null;
    String processPath = "";
    String port = "";

    byte[] convertToModifiedUTF8(String strUnmodified) {
        byte[] originalBytes = null;
        try {
            originalBytes = strUnmodified.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int nulCount = 0;
        for (int i = 0; i < originalBytes.length; ++i) {
            if (originalBytes[i] != 0) continue;
            ++nulCount;
        }
        if (nulCount == 0) {
            return originalBytes;
        }
        byte[] convertedBytes = new byte[originalBytes.length + nulCount];
        int i = 0;
        int j = 0;
        while (i < originalBytes.length) {
            convertedBytes[j] = originalBytes[i];
            if (originalBytes[i] == 0) {
                convertedBytes[j] = -64;
                convertedBytes[++j] = -128;
            }
            ++i;
            ++j;
        }
        return convertedBytes;
    }

    public UposPrinterZMQClient(String processPath, String port) {
        this.processPath = processPath;
        this.port = port;
        this.InitZMQ();
    }

    protected void InitZMQ() {
        if (process == null) {
            try {
                if (this.processPath.length() > 0) {
                    process = new ProcessBuilder(this.processPath, this.port).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.INHERIT).start();
                    this.lazyConnect();
                } else {
                    this.lazyConnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void lazyConnect() {
        if (this.socket == null) {
            try {
                logger.info("Connect Socket to endpoint");
                this.socket = context.createSocket(3);
                String clientaddr = "tcp://localhost:" + this.port;
                logger.info("Client address: " + clientaddr);
                this.socket.connect(clientaddr);
                this.items.register(this.socket, 1);
            }
            catch (ZMQException e) {
                if (e.getErrorCode() == 156384818) {
                    logger.info("socket was terminated");
                }
                if (e.getErrorCode() == 156384765) {
                    logger.info("context was terminated");
                }
                logger.log(Level.SEVERE, "Exception occured", e);
            }
        }
    }

    protected synchronized UposPrinterProtos.Params sendMsg(UposPrinterProtos.Params request, long timeout) {
        UposPrinterProtos.Params msg = null;
        this.socket.send(request.toByteArray());
        if (this.items.poll(timeout) != -1) {
            if (this.items.pollin(0)) {
                byte[] reply = this.socket.recv(0);
                try {
                    msg = UposPrinterProtos.Params.parseFrom(reply);
                }
                catch (InvalidProtocolBufferException e) {
                    logger.log(Level.SEVERE, "Exception occured", e);
                }
            } else {
                msg = UposPrinterProtos.Params.newBuilder().setErrorCode(112).build();
            }
        }
        return msg;
    }

    protected synchronized UposPrinterProtos.Params sendMsg(UposPrinterProtos.Params request) {
        UposPrinterProtos.Params msg = null;
        this.socket.send(request.toByteArray());
        byte[] reply = this.socket.recv(0);
        try {
            msg = UposPrinterProtos.Params.parseFrom(reply);
        }
        catch (InvalidProtocolBufferException e) {
            logger.log(Level.SEVERE, "Exception occured", e);
        }
        return msg;
    }

    @Override
    public long UPOSlibOptionalPreInit(String name) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibOptionalPreInit).addStrParam(name).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibInit() {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibInit).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibExit() {
        logger.info("Exit!");
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibExit).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        this.items.unregister(this.socket);
        this.socket.close();
        this.socket = null;
        context.destroy();
        process = null;
        return 0L;
    }

    @Override
    public long UPOSlibOpen(String name, long[] insthdl, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibOpen).addStrParam(name).setInstHdl((int)insthdl[0]).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        insthdl[0] = reply.getInstHdl();
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibClose(long[] insthdl, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibClose).setInstHdl((int)insthdl[0]).build();
        UposPrinterProtos.Params reply = this.sendMsg(request, 5000L);
        insthdl[0] = reply.getInstHdl();
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibClaim(long insthdl, long timeout_in_ms, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibClaim).setInstHdl((int)insthdl).addUint32Param((int)timeout_in_ms).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibReleaseDevice(long insthdl, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibReleaseDevice).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibUpdateFirmware(long insthdl, String file, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibUpdateFirmware).setInstHdl((int)insthdl).addStrParam(file).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetRecEmpty(long insthdl, boolean[] paperout, boolean[] nolabelfound, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetRecEmpty).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        paperout[0] = reply.getBoolParam(0);
        nolabelfound[0] = reply.getBoolParam(1);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetCoverOpen(long insthdl, boolean[] coverOpen, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetCoverOpen).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        coverOpen[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetRecEmptyAndCoverOpen(long insthdl, boolean[] paperout, boolean[] nolabelfound, boolean[] coverOpen, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetRecEmptyAndCoverOpen).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        paperout[0] = reply.getBoolParam(0);
        nolabelfound[0] = reply.getBoolParam(1);
        coverOpen[0] = reply.getBoolParam(2);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetRecNearEnd(long insthdl, boolean[] nearend, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetRecNearEnd).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        nearend[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibSetBitmap(long insthdl, long id, String path, long width, long align, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibSetBitmap).setInstHdl((int)insthdl).addUint32Param((int)id).addStrParam(path).addUint32Param((int)width).addUint32Param((int)align).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibPrintBitmap(long insthdl, String path, long width, long alignment, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibPrintBitmap).setInstHdl((int)insthdl).addStrParam(path).addUint32Param((int)width).addUint32Param((int)alignment).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibPrintMemoryBitmap(long insthdl, byte[] path, long length, long type, long width, long alignment, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibPrintMemoryBitmap).setInstHdl((int)insthdl).setBuffer(ByteString.copyFrom((byte[])path)).addUint32Param((int)length).addUint32Param((int)type).addUint32Param((int)width).addUint32Param((int)alignment).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibPrintBarcode(long insthdl, String codestr, long symbology, long height, long width, long alignment, long textpos, long[] exterr, Object[] errorText) {
        byte[] utf8str = this.convertToModifiedUTF8(codestr);
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibPrintBarcode).setInstHdl((int)insthdl).setBuffer(ByteString.copyFrom((byte[])utf8str)).addUint32Param((int)symbology).addUint32Param((int)height).addUint32Param((int)width).addUint32Param((int)alignment).addUint32Param((int)textpos).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public boolean UPOSlibValidateEscString(long insthdl, String printstr, Object[] errorText) {
        byte[] utf8str = this.convertToModifiedUTF8(printstr);
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibValidateEscString).setInstHdl((int)insthdl).setBuffer(ByteString.copyFrom((byte[])utf8str)).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getBoolParam(0);
    }

    @Override
    public long UPOSlibSetLogo(long insthdl, long location, String logostr, Object[] errorText) {
        byte[] utf8str = this.convertToModifiedUTF8(logostr);
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibSetLogo).setInstHdl((int)insthdl).addUint32Param((int)location).setBuffer(ByteString.copyFrom((byte[])utf8str)).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibPrintNormal(long insthdl, String printstr, long[] exterr, Object[] errorText) {
        byte[] utf8str = this.convertToModifiedUTF8(printstr);
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibPrintNormal).setInstHdl((int)insthdl).setBuffer(ByteString.copyFrom((byte[])utf8str)).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        exterr[0] = reply.getInt32Param(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibCheckHealth(long insthdl, long level, boolean[] result, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibCheckHealth).setInstHdl((int)insthdl).addUint32Param((int)level).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        result[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibCompareFirmwareVersion(long insthdl, String path, byte[] result, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibCompareFirmwareVersion).setInstHdl((int)insthdl).addStrParam(path).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        result[0] = (byte)reply.getUint32Param(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibDirectIO(long insthdl, long id, long[] data, Object[] datastring, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibDirectIO).setInstHdl((int)insthdl).addUint32Param((int)id).addUint32Param((int)data[0]).addStrParam((String)datastring[0]).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        data[0] = reply.getUint32Param(0);
        datastring[0] = reply.getStrParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibPageModePrint(long insthdl, long control, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibPageModePrint).setInstHdl((int)insthdl).addInt32Param((int)control).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetFontTypefaceList(long insthdl, Object[] fonts, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetFontTypefaceList).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        fonts[0] = reply.getStrParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibTest(long insthdl, String name) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibTest).setInstHdl((int)insthdl).addStrParam(name).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibClearPrintArea(long insthdl, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibClearPrintArea).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetDeviceEnabled(long insthdl, boolean[] enabled, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetDeviceEnabled).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        enabled[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibSetDeviceEnabled(long insthdl, boolean enabled, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibSetDeviceEnabled).setInstHdl((int)insthdl).addBoolParam(enabled).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetState(long insthdl, long[] state, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetState).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        state[0] = reply.getUint32Param(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetCheckHealthText(long insthdl, Object[] healthText, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetCheckHealthText).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        healthText[0] = reply.getStrParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibTransactionPrint(long insthdl, long control, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibTransactionPrint).setInstHdl((int)insthdl).addUint32Param((int)control).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetRecLineChars(long insthdl, long[] charsperline, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetRecLineChars).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        charsperline[0] = reply.getUint32Param(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibSetRecLineChars(long insthdl, long charsperline, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibSetRecLineChars).setInstHdl((int)insthdl).addUint32Param((int)charsperline).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetRecLineCharsList(long insthdl, Object[] charsList, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetRecLineCharsList).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        charsList[0] = reply.getStrParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetClaimed(long insthdl, boolean[] claimed, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetClaimed).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        claimed[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetRecLinesToPaperCut(long insthdl, long[] lines, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetRecLinesToPaperCut).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        lines[0] = reply.getUint32Param(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetPageModeVerticalPosition(long insthdl, long[] vpos, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetPageModeVerticalPosition).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        vpos[0] = reply.getInt32Param(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibSetPageModeVerticalPosition(long insthdl, long vpos, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibSetPageModeVerticalPosition).setInstHdl((int)insthdl).addInt32Param((int)vpos).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibAsyncMode(long insthdl, boolean[] asyncmode, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibAsyncMode).setInstHdl((int)insthdl).addBoolParam(asyncmode[0]).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        asyncmode[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetMsSinceBoot() {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetMsSinceBoot).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        return reply.getUint64Param(0);
    }

    @Override
    public long UPOSlibGetNsSinceBoot() {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetNsSinceBoot).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        return reply.getUint64Param(0);
    }

    @Override
    public long UPOSlibTrcPut(int level, String text, int file, int line) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibTrcPut).addStrParam(text).addUint32Param(level).addUint32Param(file).addUint32Param(line).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibConfigValueSet(String keyname, String valname, String val) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibConfigValueSet).addStrParam(keyname).addStrParam(valname).addStrParam(val).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibMarkFeed(long insthdl, long position, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibMarkFeed).setInstHdl((int)insthdl).addUint32Param((int)position).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibGetPhysicalDeviceDescription(long insthdl, Object[] healthText, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibGetPhysicalDeviceDescription).setInstHdl((int)insthdl).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        healthText[0] = reply.getStrParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public long UPOSlibCutPaper(long insthdl, int percantage, Object[] errorText) {
        UposPrinterProtos.Params request = UposPrinterProtos.Params.newBuilder().setCmd(UposPrinterProtos.CmdTypePrn.UPOSlibCutPaper).setInstHdl((int)insthdl).addUint32Param(percantage).build();
        UposPrinterProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }
}

