/*
 * Decompiled with CFR 0.152.
 */
package com.bizerba.jpos.PosPrinter.UPOSLib;

import com.bizerba.jpos.PosPrinter.UPOSLib.IUposPrinter;
import com.bizerba.jpos.PosPrinter.UPOSLib.UposPrinterZMQClient;
import jpos.JposException;

public class UPosPrinter {
    private boolean m_shouldBeClosed = false;
    private static IUposPrinter m_jni = null;
    private long m_insthdl = 0L;
    private static int m_refs = 0;

    public static synchronized UPosPrinter getInstance(String configfile, String moduleFileNameZMQServer, String port) throws UPosPrinterException {
        if (m_jni == null) {
            m_jni = new UposPrinterZMQClient(moduleFileNameZMQServer, port);
        }
        if (configfile != null && !configfile.isEmpty()) {
            m_jni.UPOSlibOptionalPreInit(configfile);
        }
        return new UPosPrinter();
    }

    public synchronized void releaseInstance() {
        this.m_shouldBeClosed = false;
        if (--m_refs == 0) {
            m_jni.UPOSlibExit();
            m_jni = null;
        }
    }

    private UPosPrinter() throws UPosPrinterException {
        if (m_refs == 0) {
            long ret = m_jni.UPOSlibInit();
            if (ret != 0L) {
                throw new UPosPrinterException(ret);
            }
            long[] data = new long[]{0L};
            Object[] datastring = new String[]{new String()};
            datastring[0] = "";
            Object[] errorText = new String[]{new String()};
            errorText[0] = "";
            m_jni.UPOSlibDirectIO(0L, 10L, data, datastring, errorText);
            Object versions = datastring[0];
            versions = "BizerbaJPOSPrinter:1013265," + (String)versions;
            this.UPOSlibConfigValueSet("./oemprinter/classes/jposprinter/", "alllibrariesversions", (String)versions);
        }
        ++m_refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.m_shouldBeClosed) {
                this.m_shouldBeClosed = false;
                this.releaseInstance();
            }
        }
        finally {
            super.finalize();
        }
    }

    public long optionalPreInit(String name) {
        return m_jni.UPOSlibOptionalPreInit(name);
    }

    public long open(String name, Object[] errorText) {
        long[] l_insthdl = new long[]{this.m_insthdl};
        long ret = m_jni.UPOSlibOpen(name, l_insthdl, errorText);
        if (ret == 0L) {
            this.m_insthdl = l_insthdl[0];
            this.m_shouldBeClosed = true;
        }
        return ret;
    }

    public long close(Object[] errorText) {
        long[] l_insthdl = new long[]{this.m_insthdl};
        long ret = m_jni.UPOSlibClose(l_insthdl, errorText);
        this.m_insthdl = l_insthdl[0];
        return ret;
    }

    public long claim(long timeoutInMs, Object[] errorText) {
        return m_jni.UPOSlibClaim(this.m_insthdl, timeoutInMs, errorText);
    }

    public long releaseDevice(Object[] errorText) {
        return m_jni.UPOSlibReleaseDevice(this.m_insthdl, errorText);
    }

    public long updateFirmware(String file, Object[] errorText) {
        return m_jni.UPOSlibUpdateFirmware(this.m_insthdl, file, errorText);
    }

    public long getRecEmpty(boolean[] paperout, boolean[] nolabelfound, Object[] errorText) {
        return m_jni.UPOSlibGetRecEmpty(this.m_insthdl, paperout, nolabelfound, errorText);
    }

    public long getCoverOpen(boolean[] coverOpen, Object[] errorText) {
        return m_jni.UPOSlibGetCoverOpen(this.m_insthdl, coverOpen, errorText);
    }

    public long getRecEmptyAndCoverOpen(boolean[] paperout, boolean[] nolabelfound, boolean[] coverOpen, Object[] errorText) {
        return m_jni.UPOSlibGetRecEmptyAndCoverOpen(this.m_insthdl, paperout, nolabelfound, coverOpen, errorText);
    }

    public long getRecNearEnd(boolean[] nearend, Object[] errorText) {
        return m_jni.UPOSlibGetRecNearEnd(this.m_insthdl, nearend, errorText);
    }

    public long setBitmap(long id, String path, long width, long align, Object[] errorText) {
        return m_jni.UPOSlibSetBitmap(this.m_insthdl, id, path, width, align, errorText);
    }

    public long printBitmap(String path, long width, long alignment, Object[] errorText) {
        return m_jni.UPOSlibPrintBitmap(this.m_insthdl, path, width, alignment, errorText);
    }

    public long printMemoryBitmap(byte[] bitmap, long length, long type, long width, long alignment, Object[] errorText) {
        return m_jni.UPOSlibPrintMemoryBitmap(this.m_insthdl, bitmap, length, type, width, alignment, errorText);
    }

    public long printBarcode(String codestr, long symbology, long height, long width, long alignment, long textpos, long[] exterr, Object[] errorText) {
        return m_jni.UPOSlibPrintBarcode(this.m_insthdl, codestr, symbology, height, width, alignment, textpos, exterr, errorText);
    }

    public boolean validateEscString(String printstr, Object[] errorText) {
        return m_jni.UPOSlibValidateEscString(this.m_insthdl, printstr, errorText);
    }

    public long setLogo(long location, String logostr, Object[] errorText) {
        return m_jni.UPOSlibSetLogo(this.m_insthdl, location, logostr, errorText);
    }

    public long printNormal(String printstr, long[] exterr, Object[] errorText) {
        long ret = m_jni.UPOSlibPrintNormal(this.m_insthdl, printstr, exterr, errorText);
        return ret;
    }

    public long checkHealth(long level, boolean[] result, Object[] errorText) {
        return m_jni.UPOSlibCheckHealth(this.m_insthdl, level, result, errorText);
    }

    public long compareFirmwareVersion(String path, byte[] result, Object[] errorText) {
        return m_jni.UPOSlibCompareFirmwareVersion(this.m_insthdl, path, result, errorText);
    }

    public long directIO(long id, long[] data, Object[] datastring, Object[] errorText) {
        return m_jni.UPOSlibDirectIO(this.m_insthdl, id, data, datastring, errorText);
    }

    public long pageModePrint(long control, Object[] errorText) {
        return m_jni.UPOSlibPageModePrint(this.m_insthdl, control, errorText);
    }

    public long getFontTypefaceList(String[] fonts, Object[] errorText) {
        return m_jni.UPOSlibGetFontTypefaceList(this.m_insthdl, fonts, errorText);
    }

    public long test(String p) {
        return m_jni.UPOSlibTest(this.m_insthdl, p);
    }

    public long clearPrintArea(Object[] errorText) {
        return m_jni.UPOSlibClearPrintArea(this.m_insthdl, errorText);
    }

    public long getDeviceEnabled(boolean[] enabled, Object[] errorText) {
        return m_jni.UPOSlibGetDeviceEnabled(this.m_insthdl, enabled, errorText);
    }

    public long setDeviceEnabled(boolean enabled, Object[] errorText) {
        return m_jni.UPOSlibSetDeviceEnabled(this.m_insthdl, enabled, errorText);
    }

    public long getState(long[] state, Object[] errorText) {
        return m_jni.UPOSlibGetState(this.m_insthdl, state, errorText);
    }

    public long getCheckHealthText(Object[] healthText, Object[] errorText) {
        return m_jni.UPOSlibGetCheckHealthText(this.m_insthdl, healthText, errorText);
    }

    public long transactionPrint(long control, Object[] errorText) {
        return m_jni.UPOSlibTransactionPrint(this.m_insthdl, control, errorText);
    }

    public long getRecLineChars(long[] lineChars, Object[] errorText) {
        return m_jni.UPOSlibGetRecLineChars(this.m_insthdl, lineChars, errorText);
    }

    public long setRecLineChars(long lineChars, Object[] errorText) {
        return m_jni.UPOSlibSetRecLineChars(this.m_insthdl, lineChars, errorText);
    }

    public long getRecLineCharsList(Object[] charsList, Object[] errorText) {
        return m_jni.UPOSlibGetRecLineCharsList(this.m_insthdl, charsList, errorText);
    }

    public long getClaimed(boolean[] claimed, Object[] errorText) {
        return m_jni.UPOSlibGetClaimed(this.m_insthdl, claimed, errorText);
    }

    public long getRecLinesToPaperCut(long[] lines, Object[] errorText) {
        return m_jni.UPOSlibGetRecLinesToPaperCut(this.m_insthdl, lines, errorText);
    }

    public long getPageModeVerticalPosition(long[] vpos, Object[] errorText) throws JposException {
        return m_jni.UPOSlibGetPageModeVerticalPosition(this.m_insthdl, vpos, errorText);
    }

    public long setPageModeVerticalPosition(long vpos, Object[] errorText) throws JposException {
        return m_jni.UPOSlibSetPageModeVerticalPosition(this.m_insthdl, vpos, errorText);
    }

    public long AsyncMode(boolean[] asyncmode, Object[] errorText) throws JposException {
        return m_jni.UPOSlibAsyncMode(this.m_insthdl, asyncmode, errorText);
    }

    public long GetMsSinceBoot() {
        return m_jni.UPOSlibGetMsSinceBoot();
    }

    public long GetNsSinceBoot() {
        return m_jni.UPOSlibGetNsSinceBoot();
    }

    public long TracePut(UposlibTrcSeverityLevel level, String text, int file, int line) {
        return m_jni.UPOSlibTrcPut(level.getValue(), text, file, line);
    }

    public long UPOSlibConfigValueSet(String keyname, String valname, String val) {
        return m_jni.UPOSlibConfigValueSet(keyname, valname, val);
    }

    public long markFeed(long position, Object[] errorText) {
        return m_jni.UPOSlibMarkFeed(this.m_insthdl, position, errorText);
    }

    public long getPhysicalDeviceDescription(Object[] deviceDescription, Object[] errorText) {
        return m_jni.UPOSlibGetPhysicalDeviceDescription(this.m_insthdl, deviceDescription, errorText);
    }

    public long cutPaper(int percantage, Object[] errorText) {
        return m_jni.UPOSlibCutPaper(this.m_insthdl, percantage, errorText);
    }

    public static enum UposlibTrcSeverityLevel {
        UNDEFINED(0),
        CRITICAL_ERROR(1),
        WARNING(2),
        INFO(3),
        LEVEL0(3),
        LEVEL1(5),
        LEVEL2(6),
        LEVEL3(7),
        LEVEL4(8),
        LEVEL5(9),
        LEVEL6(10),
        LEVEL7(11);

        private int value;

        private UposlibTrcSeverityLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public class UPosPrinterException
    extends Exception {
        private static final long serialVersionUID = 1471931987252460969L;
        long m_ErrorVal;

        public UPosPrinterException() {
        }

        public UPosPrinterException(long ret) {
            this.m_ErrorVal = ret;
        }

        public UPosPrinterException(String message) {
            super(message);
        }

        public long getErrorVal() {
            return this.m_ErrorVal;
        }
    }
}

