/*
 * Decompiled with CFR 0.152.
 */
package com.bizerba.jpos.PosPrinter;

import com.bizerba.jpos.PosPrinter.BizerbaPOSPrinterService113;
import com.bizerba.jpos.PosPrinter.BizerbaPrinterJobRequest;
import com.bizerba.jpos.PosPrinter.UPOSLib.UPosPrinter;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jpos.JposException;
import jpos.events.ErrorEvent;
import jpos.services.EventCallbacks;

public class BizerbaPrinterJobQueue
implements Runnable {
    private Semaphore _signalThread = new Semaphore(1);
    private Deque JobQueue = new LinkedList();
    private final Lock lock = new ReentrantLock();
    private String NewJobSignal = "NewJobSignal";
    private boolean FinishQueueSignal = false;
    private BizerbaPOSPrinterService113 printerRef;
    private EventCallbacks eventCallbacks = null;
    public boolean FreezeEvents = false;
    private static int _outputID = 0;
    private Thread m_queueThread;
    private boolean m_threadIsRunning = false;
    private boolean m_jobsInProcess = false;

    public BizerbaPrinterJobQueue(BizerbaPOSPrinterService113 serviceObject) {
        this.printerRef = serviceObject;
        try {
            this._signalThread.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.TerminateWorkingThread();
    }

    public void GrantWorkingThread() {
        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "GrantWorkingThread", 50327894, 1);
        if (null == this.m_queueThread) {
            this.m_queueThread = new Thread(this);
            this.m_queueThread.setName("PrinterJobQueueThread");
            this.FinishQueueSignal = false;
            this.m_threadIsRunning = false;
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "starting PrinterJobQueueThread", 50327894, 1);
            this.m_queueThread.start();
            while (!this.m_threadIsRunning) {
                this._signalThread.release();
                try {
                    Thread.sleep(100L);
                    this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "waiting for startup of PrinterJobQueueThread", 50327894, 1);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "PrinterJobQueueThread is running, OK.", 50327894, 1);
        } else {
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "ignored, m_queueThread was not null", 50327894, 1);
        }
    }

    public void TerminateWorkingThread() {
        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "TerminateWorkingThread", 50327894, 1);
        if (null != this.m_queueThread) {
            this.FinishQueueSignal = true;
            this._signalThread.release();
            try {
                this.m_queueThread.join(60000L);
                if (this.m_queueThread.isAlive()) {
                    this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "PrinterJobQueueThread still alive, interrupting...", 50327894, 1);
                    this.m_queueThread.interrupt();
                    this.m_queueThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.ClearQueue();
            this.m_queueThread = null;
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "PrinterJobQueueThread terminated", 50327894, 1);
        } else {
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "m_queueThread already null", 50327894, 1);
        }
    }

    public boolean GetIsIdle() {
        boolean ret = false;
        this.lock.lock();
        try {
            if (this.printerRef.getState() == 2 && this.JobQueue.size() == 0 && !this.m_jobsInProcess) {
                ret = true;
            }
        }
        catch (JposException e) {
            e.printStackTrace();
        }
        this.lock.unlock();
        return ret;
    }

    public void ClearQueue() {
        this.lock.lock();
        this.JobQueue.clear();
        this.lock.unlock();
    }

    public void InsertStart(BizerbaPrinterJobRequest req) {
        this.lock.lock();
        if (!this.printerRef.getTransactionOn()) {
            ++_outputID;
        }
        req.setOutputID(_outputID);
        this.JobQueue.addFirst(req);
        this.lock.unlock();
        this._signalThread.release();
    }

    public void InsertEnd(BizerbaPrinterJobRequest req) {
        this.lock.lock();
        if (!this.printerRef.getTransactionOn()) {
            ++_outputID;
        }
        req.setOutputID(_outputID);
        this.JobQueue.addLast(req);
        this.lock.unlock();
        this._signalThread.release();
    }

    BizerbaPrinterJobRequest PopFirst() {
        this.lock.lock();
        BizerbaPrinterJobRequest ret = null;
        ret = (BizerbaPrinterJobRequest)this.JobQueue.pollFirst();
        this.lock.unlock();
        return ret;
    }

    public int GetJobCount() {
        this.lock.lock();
        int ret = 0;
        ret = this.JobQueue.size();
        this.lock.unlock();
        return ret;
    }

    @Override
    public void run() {
        boolean runThread = true;
        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "JQT Starting JobQueue", 50327894, 1);
        while (runThread) {
            try {
                this._signalThread.acquire();
                if (!this.m_threadIsRunning) {
                    this.m_threadIsRunning = true;
                    continue;
                }
                if (this.GetJobCount() > 0 && !this.FreezeEvents) {
                    this.lock.lock();
                    this.m_jobsInProcess = true;
                    this.lock.unlock();
                    while (this.GetJobCount() > 0 && !this.FreezeEvents) {
                        BizerbaPrinterJobRequest req = this.PopFirst();
                        this.ProcessJobRequest(req);
                        if (null != this.m_queueThread && !this.m_queueThread.isInterrupted()) continue;
                        runThread = false;
                        break;
                    }
                    this.lock.lock();
                    this.m_jobsInProcess = false;
                    this.lock.unlock();
                }
                if (this.FinishQueueSignal) {
                    runThread = false;
                }
            }
            catch (InterruptedException iex) {}
            break;
            if (!this.FinishQueueSignal) continue;
            runThread = false;
            break;
        }
        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "JQT Exiting JobQueue", 50327894, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessJobRequest(BizerbaPrinterJobRequest req) throws InterruptedException {
        boolean succeeded = false;
        int errorCode = 0;
        int errorCodeExtended = 0;
        while (!succeeded && !this.m_queueThread.isInterrupted()) {
            succeeded = false;
            try {
                switch (req.GetJobType()) {
                    case 1: {
                        this.printerRef.Exec_cutPaper(req.m_lData1);
                        break;
                    }
                    case 2: {
                        this.printerRef.Exec_markFeed(req.m_lData1);
                        break;
                    }
                    case 3: {
                        this.printerRef.Exec_printBarCode(req.m_lData1, req.m_strData1, req.m_lData2, req.m_lData3, req.m_lData4, req.m_lData5, req.m_lData6);
                        break;
                    }
                    case 4: {
                        this.printerRef.Exec_printBitmap(req.m_lData1, req.m_strData1, req.m_lData2, req.m_lData3);
                        break;
                    }
                    case 10: {
                        this.printerRef.Exec_printMemoryBitmap(req.m_lData1, req.m_baData1, req.m_lData2, req.m_lData3, req.m_lData4);
                        break;
                    }
                    case 5: {
                        this.printerRef.Exec_printNormal(req.m_lData1, req.m_strData1);
                        break;
                    }
                    case 6: {
                        this.printerRef.Exec_printTwoNormal(req.m_lData1, req.m_strData1, req.m_strData2);
                        break;
                    }
                    case 7: {
                        this.printerRef.Exec_rotatePrint(req.m_lData1, req.m_lData2);
                        break;
                    }
                    case 8: {
                        this.printerRef.Exec_transactionPrint(req.m_lData1, req.m_lData2);
                        break;
                    }
                    case 9: {
                        this.printerRef.Exec_pageModePrint(req.m_lData1);
                    }
                }
                succeeded = true;
            }
            catch (JposException jex) {
                errorCode = jex.getErrorCode();
                errorCodeExtended = jex.getErrorCodeExtended();
            }
            catch (Exception ex) {
                errorCode = 111;
            }
            while (this.FreezeEvents) {
                String ex = this.NewJobSignal;
                synchronized (ex) {
                    this.NewJobSignal.wait();
                }
            }
            if (succeeded) {
                if (null == this.eventCallbacks || this.printerRef.getTransactionOn()) continue;
                this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, " Signal Output Complete", 50327894, 1);
                this.printerRef.SignalOutputCompleteEvent(req.GetOutputID());
                try {
                    if (this.GetJobCount() != 0 || !this.printerRef.getFlagWhenIdle()) continue;
                    this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, " Signal Idle event", 50327894, 1);
                    this.printerRef.setFlagWhenIdle(false);
                    this.printerRef.SignalStatusUpdateEvent(1001);
                }
                catch (JposException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (null != this.eventCallbacks) {
                this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "JQT firing EE Error:" + errorCode + " ErrorExtended:" + errorCodeExtended + "  ErrorLocus:" + 1, 50327894, 1);
                ErrorEvent evt = new ErrorEvent((Object)this.printerRef, errorCode, errorCodeExtended, 1, 11);
                this.eventCallbacks.fireErrorEvent(evt);
                this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "JQT ErrorResponse:" + evt.getErrorResponse(), 50327894, 1);
                if (evt.getErrorResponse() == 11 && !this.FinishQueueSignal) {
                    succeeded = false;
                    continue;
                }
                try {
                    this.printerRef.clearOutput();
                }
                catch (JposException ex) {
                    // empty catch block
                }
                succeeded = true;
                continue;
            }
            succeeded = false;
        }
    }

    public void SetFreezeEvents(boolean freeze) {
        this.FreezeEvents = freeze;
        if (!freeze) {
            this._signalThread.release();
        }
    }

    public int GetOutputID() {
        return _outputID;
    }

    public void setEventCallBack(EventCallbacks evtCallBacks) {
        this.eventCallbacks = evtCallBacks;
    }
}

