/*
 * Decompiled with CFR 0.152.
 */
package com.bizerba.jpos.PosPrinter;

import com.bizerba.jpos.PosPrinter.BizerbaAsyncDevice;
import com.bizerba.jpos.PosPrinter.BizerbaOutputCompleteEvent;
import com.bizerba.jpos.PosPrinter.BizerbaPrinterJobRequest;
import com.bizerba.jpos.PosPrinter.BizerbaStatusUpdateEvent;
import com.bizerba.jpos.PosPrinter.UPOSLib.UPosPrinter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import jpos.services.POSPrinterService113;

public class BizerbaPOSPrinterService113
implements POSPrinterService113 {
    private String DeviceServiceDescription = "";
    private String PhysicalDeviceDescription = "";
    private String PhysicalDeviceName = "";
    private boolean CapUpdateFirmware = true;
    private boolean CapCompareFirmwareVersion = true;
    private int CapCharacterSet = 997;
    private int CharacterSet = 997;
    private String CharacterSetList;
    private int mapMode = 1;
    private int ErrorStation = 2;
    private int ErrorLevel = 1;
    private boolean CapRecEmptySensor = true;
    private boolean CapRecBarCode = true;
    private boolean CapRecBitmap = true;
    private boolean CapRecBold = true;
    private boolean CapRecDhigh = true;
    private boolean CapRecDwide = true;
    private boolean CapRecDwideDhigh = true;
    private boolean CapRecUnderline = true;
    private boolean CapTransaction = true;
    private boolean CapRecPresent = true;
    private boolean RecLetterQuality = true;
    private int RotateSpecial = 1;
    private int CapRecColor = 1;
    private int RecCurrentCartridge = 1;
    private boolean CapRecPageMode = true;
    private int CartridgeNotify = 0;
    private int RecCartridgeState = 0x10000000;
    private int PageModePrintDirection = 1;
    private String PageModePrintArea = "0,0,0,0";
    private String PageModeArea = "";
    private boolean FlagWhenIdle = false;
    private boolean FlagTransactionOn = false;
    private BizerbaAsyncDevice bizAsyncDevice = null;
    protected String moduleFileNameZMQServer;
    protected boolean isLinux = false;
    protected String hostZMQServer = "5560";
    public static final int VERSION_NUMBER = 1013265;
    public final String PHYSICAL_DEVICE_NAME = "physicalDeviceName";
    public final String PHYSICAL_DEVICE_DESCRIPTION = "physicalDeviceDescription";
    public static final String DEFAULT_PHYSICAL_DESCRIPTION = "Bizerba POS Printer";
    public static final String DEFAULT_DEVICE_SERVICE_DESCRIPTION = "Bizerba PosPrinter Service, version {?}, (c) 2012 Bizerba";
    protected final String HOSTZMQSERVER = "hostzmqserver";
    protected final String SERVERFILE = "server_file";
    private UPosPrinter uposprinter = null;
    public static final boolean HYDRA_TRUE = true;
    public static final boolean HYDRA_FALSE = false;
    private final Lock asyncLock = new ReentrantLock();
    private int laststate = 0;

    public BizerbaPOSPrinterService113() throws JposException {
        this.CharacterSetList = String.valueOf(997);
        this.bizAsyncDevice = new BizerbaAsyncDevice(this);
        this.moduleFileNameZMQServer = this.getClass().getProtectionDomain().getCodeSource().toString();
        String REGEX = "file:";
        Pattern p = Pattern.compile(REGEX);
        String[] items = p.split(this.moduleFileNameZMQServer);
        this.moduleFileNameZMQServer = items[items.length - 1];
        int lastIndex = this.moduleFileNameZMQServer.lastIndexOf("jposprinter.jar");
        if (lastIndex > -1) {
            this.moduleFileNameZMQServer = this.moduleFileNameZMQServer.substring(0, lastIndex);
            this.moduleFileNameZMQServer = this.moduleFileNameZMQServer.replaceAll("%20", " ");
            String seperator = System.getProperty("file.separator");
            System.out.println("Seperator:" + seperator);
            if (seperator.charAt(0) == '/') {
                System.out.println("found linux system");
                this.isLinux = true;
                this.moduleFileNameZMQServer = this.moduleFileNameZMQServer + "linux_x86/protozmqprinter.x";
            } else {
                System.out.println("Found windows system");
                if (this.moduleFileNameZMQServer.charAt(0) == '/') {
                    this.moduleFileNameZMQServer = this.moduleFileNameZMQServer.substring(1);
                }
                this.moduleFileNameZMQServer = this.moduleFileNameZMQServer + "winnt_x86\\protozmqprinter.exe";
            }
        } else {
            this.moduleFileNameZMQServer = "";
        }
    }

    public BizerbaPOSPrinterService113(String logicalName) throws JposException {
        this.CharacterSetList = String.valueOf(997);
        this.bizAsyncDevice = new BizerbaAsyncDevice(this);
        this.moduleFileNameZMQServer = this.getClass().getProtectionDomain().getCodeSource().toString();
        String REGEX = "file:";
        Pattern p = Pattern.compile(REGEX);
        String[] items = p.split(this.moduleFileNameZMQServer);
        this.moduleFileNameZMQServer = items[items.length - 1];
        int lastIndex = this.moduleFileNameZMQServer.lastIndexOf("jposprinter.jar");
        if (lastIndex > -1) {
            this.moduleFileNameZMQServer = this.moduleFileNameZMQServer.substring(0, lastIndex);
            this.moduleFileNameZMQServer = this.moduleFileNameZMQServer.replaceAll("%20", " ");
            String seperator = System.getProperty("file.separator");
            System.out.println("Seperator:" + seperator);
            if (seperator.charAt(0) == '/') {
                System.out.println("found linux system");
                this.isLinux = true;
                this.moduleFileNameZMQServer = this.moduleFileNameZMQServer + "linux_x86/protozmqprinter.x";
            } else {
                System.out.println("Found windows system");
                if (this.moduleFileNameZMQServer.charAt(0) == '/') {
                    this.moduleFileNameZMQServer = this.moduleFileNameZMQServer.substring(1);
                }
                this.moduleFileNameZMQServer = this.moduleFileNameZMQServer + "winnt_x86\\protozmqprinter.exe";
            }
        } else {
            this.moduleFileNameZMQServer = "";
        }
    }

    public boolean getTransactionOn() {
        return this.FlagTransactionOn;
    }

    public void checkHealth(int pLevel) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        boolean[] result = new boolean[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.checkHealth(pLevel, result, errortext);
        if (result[0]) {
            return;
        }
        throw new JposException((int)retVal, (String)errortext[0]);
    }

    public void deleteInstance() throws JposException {
        this.uposprinter.releaseInstance();
        this.uposprinter = null;
    }

    public void claim(int pTimeout) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "claim() begin", 50327889, 1);
        Object[] errortext = new String[1];
        if (pTimeout < 0 && pTimeout != -1) {
            throw new JposException(106, "Invalid timeout parameter");
        }
        long retVal = this.uposprinter.claim(pTimeout, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        this.bizAsyncDevice.DeviceStatus |= 2;
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "claim() starting threads...", 50327889, 1);
        this.bizAsyncDevice.EventQueue.GrantWorkingThread();
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "claim() end", 50327889, 1);
    }

    public void close() throws JposException {
        Object[] errortext;
        long retVal;
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "close() ...", 50327889, 1);
        if ((this.bizAsyncDevice.DeviceStatus & 2) == 2) {
            this.release();
        }
        if (0L != (retVal = this.uposprinter.close(errortext = new String[1]))) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        this.bizAsyncDevice.DeviceStatus &= 0xFFFFFFFE;
    }

    public void directIO(int pCommand, int[] pData, Object pAuxData) throws JposException {
        Object[] auxData;
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "directIO() begin", 50327889, 1);
        long retVal = 0L;
        long[] data = new long[1];
        Object[] errortext = new String[1];
        long command = pCommand;
        data[0] = pData[0];
        if (null == pAuxData) {
            auxData = new String[]{new String("")};
        } else if (pAuxData.getClass().isArray()) {
            auxData = (String[])pAuxData;
            if (auxData[0] == null) {
                auxData[0] = new String("");
            }
        } else {
            auxData = new String[]{(String)pAuxData};
        }
        retVal = this.uposprinter.directIO(command, data, auxData, errortext);
        if (0L != retVal) {
            this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "throwing:" + retVal + "," + (String)errortext[0], 50327889, 1);
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        pData[0] = (int)data[0];
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "directIO() end", 50327889, 1);
    }

    public void open(String logicalName, EventCallbacks pEventCallbacks) throws JposException {
        Object objValue;
        Object objValue2;
        JposEntryRegistry entryRegistry = JposServiceLoader.getManager().getEntryRegistry();
        if (entryRegistry == null) {
            throw new JposException(104, "Configuration information not found");
        }
        if (logicalName == null) {
            throw new JposException(106, "logicalName is null!!!");
        }
        JposEntry jposEntry = entryRegistry.getJposEntry(logicalName);
        if (jposEntry == null) {
            throw new JposException(109, "Device configuration not found");
        }
        this.DeviceServiceDescription = jposEntry.hasPropertyWithName("productDescription") ? ((objValue2 = jposEntry.getPropertyValue("productDescription")) != null ? (String)objValue2 : DEFAULT_DEVICE_SERVICE_DESCRIPTION.replaceFirst("{?}", "1013265")) : DEFAULT_DEVICE_SERVICE_DESCRIPTION.replaceFirst("{?}", "1013265");
        if (jposEntry.hasPropertyWithName("physicalDeviceName")) {
            objValue2 = jposEntry.getPropertyValue("physicalDeviceName");
            if (objValue2 != null) {
                this.PhysicalDeviceName = (String)objValue2;
            } else {
                throw new JposException(109, "no physical device for logical name " + logicalName + " found");
            }
        }
        if (jposEntry.hasPropertyWithName("physicalDeviceDescription")) {
            objValue2 = jposEntry.getPropertyValue("physicalDeviceDescription");
            this.PhysicalDeviceDescription = objValue2 != null ? (String)objValue2 : DEFAULT_PHYSICAL_DESCRIPTION;
        }
        String configpath = "";
        if (jposEntry.hasPropertyWithName("config_file_with_rw_access_without_extension") && (objValue = jposEntry.getPropertyValue("config_file_with_rw_access_without_extension")) != null && !objValue.toString().isEmpty()) {
            configpath = (String)objValue;
            System.out.println("using configuration from:" + configpath);
            System.out.flush();
        }
        if (jposEntry.hasPropertyWithName("hostzmqserver")) {
            String zmqHost = "";
            Object objValue3 = jposEntry.getPropertyValue("hostzmqserver");
            if (objValue3 != null && (zmqHost = ((String)objValue3).trim()).length() > 0) {
                System.out.println("use host port from xml file: " + zmqHost);
                this.hostZMQServer = zmqHost;
            }
        }
        if (jposEntry.hasPropertyWithName("server_file") && (objValue = jposEntry.getPropertyValue("server_file")) != null) {
            String serverFile = ((String)objValue).trim();
            if (serverFile.length() > 0) {
                System.out.println("path to server file: " + serverFile);
                this.moduleFileNameZMQServer = serverFile;
            } else {
                System.out.println("using global configuration");
            }
            System.out.flush();
        }
        try {
            this.uposprinter = UPosPrinter.getInstance(configpath, this.moduleFileNameZMQServer, this.hostZMQServer);
        }
        catch (UPosPrinter.UPosPrinterException e1) {
            System.out.println("cannot get UPosPrinter Instance");
            System.out.flush();
            e1.printStackTrace();
            throw new JposException(109, "cannot get UPosPrinter Instance");
        }
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        long retVal = 0L;
        this.bizAsyncDevice.setEventCallBack(pEventCallbacks);
        Object[] errortext = new String[1];
        retVal = this.uposprinter.open(this.PhysicalDeviceName, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        System.out.flush();
        this.FlagWhenIdle = false;
        this.bizAsyncDevice.DeviceStatus = 0;
        this.bizAsyncDevice.DeviceStatus |= 1;
        this.bizAsyncDevice.FreezeEvents();
        try {
            this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "dummy printNormal to enforce just in time compiling", 50327889, 1);
            this.printNormal(0, "");
        }
        catch (JposException ex) {
            // empty catch block
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "open() done", 50327889, 1);
    }

    public void release() throws JposException {
        Object[] errortext;
        long retVal;
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "release()", 50327889, 1);
        if ((this.bizAsyncDevice.DeviceStatus & 2) == 2) {
            if ((this.bizAsyncDevice.DeviceStatus & 4) == 4) {
                this.setDeviceEnabled(false);
            }
            this.bizAsyncDevice.EventQueue.TerminateWorkingThread();
            this.bizAsyncDevice.DeviceStatus &= 0xFFFFFFFD;
        }
        if (0L != (retVal = this.uposprinter.releaseDevice(errortext = new String[1]))) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
    }

    public void cutPaper(int percentage) throws JposException {
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(1, percentage));
        } else {
            this.Exec_cutPaper(percentage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Exec_cutPaper(int percentage) throws JposException {
        try {
            this.asyncLock.lock();
            if (this.uposprinter == null) {
                throw new JposException(101, "instance not available!!!");
            }
            Object[] errortext = new String[1];
            long retVal = this.uposprinter.cutPaper(percentage, errortext);
            if (0L != retVal) {
                this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "Exec_cutPaper throwing:" + retVal + "," + (String)errortext[0], 50327889, 1);
                if (retVal <= 200L) {
                    throw new JposException((int)retVal, (String)errortext[0]);
                }
                throw new JposException(114, (int)retVal, (String)errortext[0]);
            }
        }
        finally {
            this.asyncLock.unlock();
        }
    }

    public void markFeed(int type) throws JposException {
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(2, type));
        } else {
            this.Exec_markFeed(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Exec_markFeed(int type) throws JposException {
        try {
            this.asyncLock.lock();
            if (this.uposprinter == null) {
                throw new JposException(101, "instance not available!!!");
            }
            Object[] errortext = new String[1];
            long retVal = this.uposprinter.markFeed(type, errortext);
            if (0L != retVal) {
                this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "Exec_markFeed throwing:" + retVal + "," + (String)errortext[0], 50327889, 1);
                if (retVal <= 200L) {
                    throw new JposException((int)retVal, (String)errortext[0]);
                }
                throw new JposException(114, (int)retVal, (String)errortext[0]);
            }
        }
        finally {
            this.asyncLock.unlock();
        }
    }

    public void printBarCode(int station, String data, int symbology, int height, int width, int alignment, int textPosition) throws JposException {
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "printBarCode() begin", 50327889, 1);
        if (data == null) {
            throw new JposException(106, "data is null!!!");
        }
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(3, station, data, symbology, height, width, alignment, textPosition));
        } else {
            this.Exec_printBarCode(station, data, symbology, height, width, alignment, textPosition);
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "printBarCode() end", 50327889, 1);
    }

    protected void SignalStatusUpdateEvent(int status) {
        BizerbaStatusUpdateEvent updateEvent = new BizerbaStatusUpdateEvent(status);
        this.bizAsyncDevice.EventQueue.InsertEnd(updateEvent);
    }

    protected void SignalOutputCompleteEvent(int outputID) {
        BizerbaOutputCompleteEvent ocEvent = new BizerbaOutputCompleteEvent(outputID);
        this.bizAsyncDevice.EventQueue.InsertEnd(ocEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Exec_printBarCode(int station, String data, int symbology, int height, int width, int alignment, int textPosition) throws JposException {
        try {
            this.asyncLock.lock();
            if (this.uposprinter == null) {
                throw new JposException(101, "instance not available!!!");
            }
            long[] exterr = new long[1];
            Object[] errortext = new String[1];
            long retVal = this.uposprinter.printBarcode(data, symbology, height, width, alignment, textPosition, exterr, errortext);
            if (0L != retVal) {
                this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "Exec_printBarCode throwing:" + retVal + "," + (String)errortext[0], 50327889, 1);
                throw new JposException((int)retVal, (int)exterr[0], (String)errortext[0]);
            }
        }
        finally {
            this.asyncLock.unlock();
        }
    }

    public void printBitmap(int station, String fileName, int width, int alignment) throws JposException {
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "printBitmap() begin", 50327889, 1);
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(4, station, fileName, width, alignment, 0, 0, 0));
        } else {
            this.Exec_printBitmap(station, fileName, width, alignment);
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "printBitmap() end", 50327889, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Exec_printBitmap(int station, String fileName, int width, int alignment) throws JposException {
        try {
            this.asyncLock.lock();
            if (this.uposprinter == null) {
                throw new JposException(101, "instance not available!!!");
            }
            Object[] errortext = new String[1];
            long retVal = this.uposprinter.printBitmap(fileName, width, alignment, errortext);
            if (0L != retVal) {
                this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "Exec_printBitmap throwing:" + retVal + "," + (String)errortext[0], 50327889, 1);
                if (retVal <= 200L) {
                    throw new JposException((int)retVal, (String)errortext[0]);
                }
                throw new JposException(114, (int)retVal, (String)errortext[0]);
            }
        }
        finally {
            this.asyncLock.unlock();
        }
    }

    public void printMemoryBitmap(int station, byte[] data, int type, int width, int alignment) throws JposException {
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "printMemoryBitmap() begin", 50327889, 1);
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(10, station, data, type, width, alignment, 0, 0));
        } else {
            this.Exec_printMemoryBitmap(station, data, type, width, alignment);
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "printMemoryBitmap() end", 50327889, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Exec_printMemoryBitmap(int station, byte[] data, int type, int width, int alignment) throws JposException {
        try {
            this.asyncLock.lock();
            if (this.uposprinter == null) {
                throw new JposException(101, "instance not available!!!");
            }
            Object[] errortext = new String[1];
            long retVal = this.uposprinter.printMemoryBitmap(data, data.length, type, width, alignment, errortext);
            if (0L != retVal) {
                this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "Exec_printMemoryBitmap throwing:" + retVal + "," + (String)errortext[0], 50327889, 1);
                if (retVal <= 200L) {
                    throw new JposException((int)retVal, (String)errortext[0]);
                }
                throw new JposException(114, (int)retVal, (String)errortext[0]);
            }
        }
        finally {
            this.asyncLock.unlock();
        }
    }

    public void printNormal(int station, String text) throws JposException {
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "printNormal() begin", 50327889, 1);
        if (text == null) {
            throw new JposException(106, "String is null!!!");
        }
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(5, station, text, 0, 0, 0, 0, 0));
        } else {
            this.Exec_printNormal(station, text);
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "printNormal() end", 50327889, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Exec_printNormal(int station, String text) throws JposException {
        try {
            this.asyncLock.lock();
            if (this.uposprinter == null) {
                throw new JposException(101, "instance not available!!!");
            }
            if (text == null) {
                throw new JposException(106, "String is null!!!");
            }
            long[] exterr = new long[1];
            Object[] errortext = new String[1];
            long retVal = this.uposprinter.printNormal(text, exterr, errortext);
            if (0L != retVal) {
                this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "Exec_printNormal throwing:" + retVal + "," + exterr[0] + "," + (String)errortext[0], 50327889, 1);
                JposException ex = new JposException((int)retVal, (int)exterr[0], (String)errortext[0]);
                throw ex;
            }
        }
        finally {
            this.asyncLock.unlock();
        }
    }

    public void printTwoNormal(int stations, String data1, String data2) throws JposException {
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(6, data1, data2));
        } else {
            this.Exec_printTwoNormal(stations, data1, data2);
        }
    }

    protected void Exec_printTwoNormal(int stations, String data1, String data2) throws JposException {
        throw new JposException(106, "Device does not support concurrent printing");
    }

    public void rotatePrint(int station, int rotation) throws JposException {
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(7, station, rotation));
        } else {
            this.Exec_rotatePrint(station, rotation);
        }
    }

    protected void Exec_rotatePrint(int station, int rotation) throws JposException {
        throw new JposException(106, "Not implemented");
    }

    public void transactionPrint(int station, int control) throws JposException {
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "transactionPrint() begin", 50327889, 1);
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(8, station, control));
        } else {
            this.Exec_transactionPrint(station, control);
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "transactionPrint() end", 50327889, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Exec_transactionPrint(int station, int control) throws JposException {
        block9: {
            try {
                this.asyncLock.lock();
                if (this.uposprinter == null) {
                    throw new JposException(101, "instance not available!!!");
                }
                Object[] errortext = new String[1];
                long retVal = this.uposprinter.transactionPrint(control, errortext);
                if (0L == retVal) {
                    if (11 == control) {
                        this.FlagTransactionOn = true;
                    } else if (12 == control) {
                        this.FlagTransactionOn = false;
                    }
                    break block9;
                }
                if (retVal <= 200L) {
                    throw new JposException((int)retVal, (String)errortext[0]);
                }
                throw new JposException(114, (int)retVal, (String)errortext[0]);
            }
            finally {
                this.asyncLock.unlock();
            }
        }
    }

    public void pageModePrint(int control) throws JposException {
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "pageModePrint() begin", 50327889, 1);
        if (this.getAsyncMode()) {
            this.bizAsyncDevice.JobQueue.InsertEnd(new BizerbaPrinterJobRequest(9, control));
        } else {
            this.Exec_pageModePrint(control);
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "pageModePrint() end", 50327889, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Exec_pageModePrint(int control) throws JposException {
        try {
            this.asyncLock.lock();
            if (this.uposprinter == null) {
                throw new JposException(101, "instance not available!!!");
            }
            Object[] errortext = new String[1];
            long retVal = this.uposprinter.pageModePrint(control, errortext);
            if (0L != retVal) {
                if (retVal <= 200L) {
                    throw new JposException((int)retVal, (String)errortext[0]);
                }
                throw new JposException(114, (int)retVal, (String)errortext[0]);
            }
        }
        finally {
            this.asyncLock.unlock();
        }
    }

    public String getCheckHealthText() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        Object[] healthText = new String[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getCheckHealthText(healthText, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return healthText[0];
    }

    public boolean getClaimed() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        boolean[] claimed = new boolean[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getClaimed(claimed, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return claimed[0];
    }

    public int getDataCount() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        return 0;
    }

    public boolean getDataEventEnabled() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        this.getClaimed();
        return false;
    }

    public int getState() throws JposException {
        long[] state = new long[1];
        Object[] errorText = new String[1];
        if (null == this.uposprinter) {
            return 1;
        }
        this.uposprinter.getState(state, errorText);
        return (int)state[0];
    }

    public int GetStatusUpdateState() throws JposException {
        int state = this.getState();
        int ret = 1001;
        if (state != 1) {
            if (state == 3) {
                ret = 3;
            } else if (state == 4 || state == 1001 || state == 2 || this.getAsyncMode() && !this.bizAsyncDevice.JobQueue.GetIsIdle()) {
                try {
                    if (this.uposprinter == null) {
                        throw new JposException(101, "instance not available!!!");
                    }
                    boolean[] RecEmpty = new boolean[1];
                    boolean[] NoLabelFound = new boolean[1];
                    boolean[] coverOpen = new boolean[1];
                    Object[] errortext = new String[1];
                    int retval = (int)this.uposprinter.getRecEmptyAndCoverOpen(RecEmpty, NoLabelFound, coverOpen, errortext);
                    switch (retval) {
                        case 0: {
                            break;
                        }
                        case 103: 
                        case 112: {
                            return ret;
                        }
                        default: {
                            throw new JposException(retval, (String)errortext[0]);
                        }
                    }
                    if (coverOpen[0]) {
                        ret = 11;
                    } else if (11 == this.laststate) {
                        ret = 12;
                    } else if (RecEmpty[0]) {
                        ret = 24;
                    } else {
                        ret = 26;
                        if (this.getRecNearEnd()) {
                            ret = 25;
                        }
                    }
                    this.laststate = ret;
                }
                catch (JposException ex) {
                    switch (ex.getErrorCode()) {
                        case 103: 
                        case 112: {
                            break;
                        }
                        default: {
                            throw ex;
                        }
                    }
                }
            }
        }
        return ret;
    }

    public void setDeviceEnabled(boolean flag) throws JposException {
        long retVal;
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "setDeviceEnabled() begin", 50327889, 1);
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        Object[] errorText = new String[1];
        if (!flag) {
            this.bizAsyncDevice.JobQueue.TerminateWorkingThread();
        }
        if ((retVal = this.uposprinter.setDeviceEnabled(flag, errorText)) != 0L) {
            throw new JposException((int)retVal, (String)errorText[0]);
        }
        if (flag) {
            this.bizAsyncDevice.JobQueue.GrantWorkingThread();
            this.bizAsyncDevice.DeviceStatus |= 4;
        } else {
            this.bizAsyncDevice.DeviceStatus &= 0xFFFFFFFB;
        }
        this.bizAsyncDevice.FreezeEvents();
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "setDeviceEnabled() end", 50327889, 1);
    }

    public boolean getDeviceEnabled() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        boolean[] enabled = new boolean[1];
        Object[] errorText = new String[1];
        long retVal = this.uposprinter.getDeviceEnabled(enabled, errorText);
        if (retVal != 0L) {
            throw new JposException((int)retVal, (String)errorText[0]);
        }
        return enabled[0];
    }

    public String getFontTypefaceList() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        String[] FontTypefaceList = new String[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getFontTypefaceList(FontTypefaceList, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return FontTypefaceList[0];
    }

    public boolean getRecEmpty() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        boolean[] RecEmpty = new boolean[1];
        boolean[] NoLabelFound = new boolean[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getRecEmpty(RecEmpty, NoLabelFound, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return RecEmpty[0];
    }

    public boolean getRecNearEnd() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        boolean[] RecNearEnd = new boolean[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getRecNearEnd(RecNearEnd, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return RecNearEnd[0];
    }

    public int getRecLineChars() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        long[] lineChars = new long[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getRecLineChars(lineChars, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return (int)lineChars[0];
    }

    public void setRecLineChars(int recLineChars) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.setRecLineChars(recLineChars, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
    }

    public String getRecLineCharsList() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        Object[] charsList = new String[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getRecLineCharsList(charsList, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return charsList[0];
    }

    public void setRecLineHeight(int recLineHeight) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
    }

    public void setRecLineSpacing(int recLineSpacing) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
    }

    public int getPageModeVerticalPosition() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        long[] vpos = new long[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getPageModeVerticalPosition(vpos, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return (int)vpos[0];
    }

    public void setPageModeVerticalPosition(int position) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        long vpos = position;
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.setPageModeVerticalPosition(vpos, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
    }

    public int getRecLinesToPaperCut() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        long[] linesToPapercut = new long[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getRecLinesToPaperCut(linesToPapercut, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return (int)linesToPapercut[0];
    }

    public void setBitmap(int bitmapNumber, int station, String fileName, int width, int alignment) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (fileName == null) {
            throw new JposException(106, "fileName is null!!!");
        }
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.setBitmap(bitmapNumber, fileName, width, alignment, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
    }

    public void setLogo(int location, String data) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (data == null) {
            throw new JposException(106, "data is null!!!");
        }
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.setLogo(location, data, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
    }

    public void validateData(int station, String data) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (data == null) {
            throw new JposException(106, "data is null!!!");
        }
        Object[] errortext = new String[1];
        boolean retVal = this.uposprinter.validateEscString(data, errortext);
        if (!retVal) {
            throw new JposException(106, (String)errortext[0]);
        }
    }

    public void clearPrintArea() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.clearPrintArea(errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
    }

    public void clearOutput() throws JposException {
        this.clearPrintArea();
        this.bizAsyncDevice.JobQueue.ClearQueue();
    }

    public void compareFirmwareVersion(String filename, int[] answer) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (filename == null) {
            throw new JposException(106, "filename is null!!!");
        }
        byte[] result = null;
        result = new byte[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.compareFirmwareVersion(filename, result, errortext);
        if (0L != retVal) {
            if (result[0] == 5) {
                throw new JposException(109, (String)errortext[0]);
            }
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        answer[0] = result[0];
    }

    public void updateFirmware(String filename) throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (filename == null) {
            throw new JposException(106, "filename is null!!!");
        }
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.updateFirmware(filename, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
    }

    public void drawRuledLine(int station, String positionList, int lineDirection, int lineWidth, int lineStyle, int lineColor) throws JposException {
    }

    public void printImmediate(int station, String data) throws JposException {
    }

    public void endInsertion() throws JposException {
    }

    public void endRemoval() throws JposException {
    }

    public void beginInsertion(int timeout) throws JposException {
    }

    public void beginRemoval(int timeout) throws JposException {
    }

    public void changePrintSide(int side) throws JposException {
    }

    public String getSlpBitmapRotationList() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public void setRotateSpecial(int rotateSpecial) throws JposException {
    }

    public String getSlpBarCodeRotationList() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public boolean getSlpEmpty() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public boolean getSlpLetterQuality() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public void setSlpLetterQuality(boolean recLetterQuality) throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpLineChars() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public void setSlpLineChars(int recLineChars) throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public String getSlpLineCharsList() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpLineHeight() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public void setSlpLineHeight(int recLineHeight) throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpLinesNearEndToEnd() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpLineSpacing() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public void setSlpLineSpacing(int recLineSpacing) throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpLineWidth() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpMaxLines() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public boolean getSlpNearEnd() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpSidewaysMaxChars() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpSidewaysMaxLines() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public void setCartridgeNotify(int notify) throws JposException {
    }

    public int getJrnCartridgeState() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public int getJrnCurrentCartridge() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public void setJrnCurrentCartridge(int cartridge) throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public int getSlpCartridgeState() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpCurrentCartridge() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public void setSlpCurrentCartridge(int cartridge) throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public int getSlpPrintSide() throws JposException {
        throw new JposException(106, "Slip print: Not Supported");
    }

    public boolean getJrnEmpty() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public boolean getJrnLetterQuality() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public void setJrnLetterQuality(boolean jrnLetterQuality) throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public int getJrnLineChars() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public void setJrnLineChars(int jrnLineChars) throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public String getJrnLineCharsList() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public int getJrnLineHeight() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public void setJrnLineHeight(int jrnLineHeight) throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public int getJrnLineSpacing() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public void setJrnLineSpacing(int jrnLineSpacing) throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public int getJrnLineWidth() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public boolean getJrnNearEnd() throws JposException {
        throw new JposException(106, "Journal print: Not Supported");
    }

    public int getMapMode() throws JposException {
        return this.mapMode;
    }

    public void setMapMode(int mapMode) throws JposException {
    }

    public int getErrorStation() throws JposException {
        return this.ErrorStation;
    }

    public int getErrorLevel() throws JposException {
        return this.ErrorLevel;
    }

    public boolean getAsyncMode() throws JposException {
        boolean ret = (this.bizAsyncDevice.DeviceStatus & 0x40) == 64;
        return ret;
    }

    public void setAsyncMode(boolean asyncMode) throws JposException {
        boolean[] am = new boolean[]{asyncMode};
        Object[] errortext = new String[1];
        if (asyncMode) {
            this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "setAsyncMode(true) begin", 50327889, 1);
            this.bizAsyncDevice.DeviceStatus |= 0x40;
        } else {
            this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "setAsyncMode(false) begin", 50327889, 1);
            if (this.bizAsyncDevice.JobQueue.GetJobCount() > 0) {
                this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "setAsyncMode throwing: The queue of asynchronous operations is not empty yet", 50327889, 1);
                throw new JposException(113, "The queue of asynchronous operations is not empty yet");
            }
            this.bizAsyncDevice.DeviceStatus &= 0xFFFFFFBF;
        }
        this.uposprinter.AsyncMode(am, errortext);
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "setAsyncMode() end", 50327889, 1);
    }

    public boolean getCoverOpen() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        boolean[] coverOpen = new boolean[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getCoverOpen(coverOpen, errortext);
        if (0L != retVal) {
            throw new JposException((int)retVal, (String)errortext[0]);
        }
        return coverOpen[0];
    }

    public boolean getCapRecEmptySensor() throws JposException {
        return this.CapRecEmptySensor;
    }

    public boolean getCapRec2Color() throws JposException {
        return false;
    }

    public boolean getCapRecBarCode() throws JposException {
        return this.CapRecBarCode;
    }

    public boolean getCapRecBitmap() throws JposException {
        return this.CapRecBitmap;
    }

    public boolean getCapRecBold() throws JposException {
        return this.CapRecBold;
    }

    public boolean getCapRecDhigh() throws JposException {
        return this.CapRecDhigh;
    }

    public boolean getCapRecDwide() throws JposException {
        return this.CapRecDwide;
    }

    public boolean getCapRecDwideDhigh() throws JposException {
        return this.CapRecDwideDhigh;
    }

    public boolean getCapRecItalic() throws JposException {
        return true;
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        return this.CapCompareFirmwareVersion;
    }

    public boolean getCapRecUnderline() throws JposException {
        return this.CapRecUnderline;
    }

    public boolean getCapConcurrentJrnRec() throws JposException {
        return false;
    }

    public boolean getCapConcurrentJrnSlp() throws JposException {
        return false;
    }

    public boolean getCapConcurrentRecSlp() throws JposException {
        return false;
    }

    public boolean getCapCoverSensor() throws JposException {
        return false;
    }

    public boolean getCapJrnPresent() throws JposException {
        return false;
    }

    public boolean getCapRecLeft90() throws JposException {
        return false;
    }

    public boolean getCapRecPapercut() throws JposException {
        return false;
    }

    public boolean getCapRecRight90() throws JposException {
        return false;
    }

    public boolean getCapRecRotate180() throws JposException {
        return false;
    }

    public boolean getCapRecStamp() throws JposException {
        return false;
    }

    public boolean getCapSlpPresent() throws JposException {
        return false;
    }

    public boolean getCapConcurrentPageMode() throws JposException {
        return false;
    }

    public boolean getCapTransaction() throws JposException {
        return this.CapTransaction;
    }

    public boolean getCapRecNearEndSensor() throws JposException {
        return false;
    }

    public boolean getCapRecPresent() throws JposException {
        return this.CapRecPresent;
    }

    public int getCapRecRuledLine() throws JposException {
        return 0;
    }

    public int getCapSlpRuledLine() throws JposException {
        return 0;
    }

    public int getCapRecColor() throws JposException {
        return this.CapRecColor;
    }

    public boolean getRecLetterQuality() throws JposException {
        return this.RecLetterQuality;
    }

    public void setRecLetterQuality(boolean recLetterQuality) throws JposException {
    }

    public int getRotateSpecial() throws JposException {
        return this.RotateSpecial;
    }

    public int getRecLineHeight() throws JposException {
        return 0;
    }

    public int getRecLineSpacing() throws JposException {
        return 0;
    }

    public int getRecLineWidth() throws JposException {
        return 0;
    }

    public int getRecSidewaysMaxChars() throws JposException {
        return 0;
    }

    public int getRecSidewaysMaxLines() throws JposException {
        return 0;
    }

    public int getRecCurrentCartridge() throws JposException {
        return this.RecCurrentCartridge;
    }

    public void setRecCurrentCartridge(int cartridge) throws JposException {
    }

    public boolean getCapRecPageMode() throws JposException {
        return this.CapRecPageMode;
    }

    public int getCapRecCartridgeSensor() throws JposException {
        return 0;
    }

    public int getCapRecMarkFeed() throws JposException {
        return 1;
    }

    public int getCartridgeNotify() throws JposException {
        return this.CartridgeNotify;
    }

    public int getRecCartridgeState() throws JposException {
        return this.RecCartridgeState;
    }

    public int getPageModePrintDirection() throws JposException {
        return this.PageModePrintDirection;
    }

    public void setPageModePrintDirection(int direction) throws JposException {
    }

    public int getPageModeStation() throws JposException {
        return 0;
    }

    public void setPageModeStation(int station) throws JposException {
    }

    public int getPageModeDescriptor() throws JposException {
        return 0;
    }

    public int getPageModeHorizontalPosition() throws JposException {
        return 0;
    }

    public void setPageModeHorizontalPosition(int position) throws JposException {
    }

    public String getPageModePrintArea() throws JposException {
        return this.PageModePrintArea;
    }

    public void setPageModePrintArea(String area) throws JposException {
    }

    public String getPageModeArea() throws JposException {
        return this.PageModeArea;
    }

    public String getRecBitmapRotationList() throws JposException {
        return "0";
    }

    public String getRecBarCodeRotationList() throws JposException {
        return "0";
    }

    public String getErrorString() throws JposException {
        return "";
    }

    public boolean getFlagWhenIdle() throws JposException {
        return this.FlagWhenIdle;
    }

    public void setFlagWhenIdle(boolean flagWhenIdle) throws JposException {
        this.FlagWhenIdle = flagWhenIdle;
        if (flagWhenIdle && this.bizAsyncDevice.JobQueue.GetIsIdle() && !this.getRecEmpty()) {
            this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "Signal Idle Event in setFlagWhenIdle", 50327889, 1);
            BizerbaStatusUpdateEvent evt = new BizerbaStatusUpdateEvent(1001);
            this.bizAsyncDevice.EventQueue.InsertEnd(evt);
            this.FlagWhenIdle = false;
        }
        this.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "FlagWhenIdle=" + flagWhenIdle, 50327889, 1);
    }

    public void resetStatistics(String arg0) throws JposException {
        throw new JposException(106, "Reset statistics functionality not supported");
    }

    public void retrieveStatistics(String[] arg0) throws JposException {
        throw new JposException(106, "Retrieve statistics functionality not supported");
    }

    public void updateStatistics(String arg0) throws JposException {
        throw new JposException(106, "Update statistics functionality not supported");
    }

    public String getDeviceServiceDescription() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        return this.DeviceServiceDescription;
    }

    public int getDeviceServiceVersion() throws JposException {
        return 1013265;
    }

    public String getPhysicalDeviceDescription() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        Object[] realPhysicalDescription = new String[1];
        Object[] errortext = new String[1];
        long retVal = this.uposprinter.getPhysicalDeviceDescription(realPhysicalDescription, errortext);
        if (0L != retVal) {
            return this.PhysicalDeviceDescription;
        }
        return realPhysicalDescription[0];
    }

    public String getPhysicalDeviceName() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        return this.PhysicalDeviceName;
    }

    public boolean getCapJrn2Color() throws JposException {
        return false;
    }

    public boolean getCapJrnBold() throws JposException {
        return false;
    }

    public boolean getCapJrnDhigh() throws JposException {
        return false;
    }

    public boolean getCapJrnDwide() throws JposException {
        return false;
    }

    public boolean getCapJrnDwideDhigh() throws JposException {
        return false;
    }

    public boolean getCapJrnEmptySensor() throws JposException {
        return false;
    }

    public boolean getCapJrnItalic() throws JposException {
        return false;
    }

    public boolean getCapJrnNearEndSensor() throws JposException {
        return false;
    }

    public boolean getCapJrnUnderline() throws JposException {
        return false;
    }

    public boolean getCapSlp2Color() throws JposException {
        return false;
    }

    public boolean getCapSlpBarCode() throws JposException {
        return false;
    }

    public boolean getCapSlpBitmap() throws JposException {
        return false;
    }

    public boolean getCapSlpBold() throws JposException {
        return false;
    }

    public boolean getCapSlpDhigh() throws JposException {
        return false;
    }

    public boolean getCapSlpDwide() throws JposException {
        return false;
    }

    public boolean getCapSlpDwideDhigh() throws JposException {
        return false;
    }

    public boolean getCapSlpEmptySensor() throws JposException {
        return false;
    }

    public boolean getCapSlpFullslip() throws JposException {
        return false;
    }

    public boolean getCapSlpItalic() throws JposException {
        return false;
    }

    public boolean getCapSlpLeft90() throws JposException {
        return false;
    }

    public boolean getCapSlpNearEndSensor() throws JposException {
        return false;
    }

    public boolean getCapSlpRight90() throws JposException {
        return false;
    }

    public boolean getCapSlpRotate180() throws JposException {
        return false;
    }

    public boolean getCapSlpUnderline() throws JposException {
        return false;
    }

    public int getPowerNotify() throws JposException {
        return 0;
    }

    public void setPowerNotify(int powerNotify) throws JposException {
    }

    public int getPowerState() throws JposException {
        return 2000;
    }

    public int getCapPowerReporting() throws JposException {
        return 0;
    }

    public int getCapJrnCartridgeSensor() throws JposException {
        return 0;
    }

    public int getCapJrnColor() throws JposException {
        return 0;
    }

    public boolean getCapSlpBothSidesPrint() throws JposException {
        return false;
    }

    public int getCapSlpCartridgeSensor() throws JposException {
        return 0;
    }

    public int getCapSlpColor() throws JposException {
        return 0;
    }

    public boolean getCapStatisticsReporting() throws JposException {
        return false;
    }

    public boolean getCapUpdateStatistics() throws JposException {
        return false;
    }

    public boolean getCapSlpPageMode() throws JposException {
        return false;
    }

    public boolean getAutoDisable() throws JposException {
        return false;
    }

    public boolean getCapUpdateFirmware() throws JposException {
        return this.CapUpdateFirmware;
    }

    public int getOutputID() throws JposException {
        return this.bizAsyncDevice.JobQueue.GetOutputID();
    }

    public boolean getMapCharacterSet() throws JposException {
        return false;
    }

    public boolean getCapMapCharacterSet() throws JposException {
        return false;
    }

    public void setMapCharacterSet(boolean mapCharacterSet) throws JposException {
        throw new JposException(106, "Not Supported");
    }

    public int getCapCharacterSet() throws JposException {
        return this.CapCharacterSet;
    }

    public int getCharacterSet() throws JposException {
        return this.CharacterSet;
    }

    public void setCharacterSet(int characterSet) throws JposException {
        throw new JposException(106, "Not Supported");
    }

    public String getCharacterSetList() throws JposException {
        return this.CharacterSetList;
    }

    public boolean getFreezeEvents() throws JposException {
        if (this.uposprinter == null) {
            throw new JposException(101, "instance not available!!!");
        }
        boolean ret = false;
        if ((this.bizAsyncDevice.DeviceStatus & 0x80) == 128) {
            ret = true;
        }
        return ret;
    }

    public void setFreezeEvents(boolean flag) throws JposException {
        this.bizAsyncDevice.DeviceStatus = flag ? (this.bizAsyncDevice.DeviceStatus |= 0x80) : (this.bizAsyncDevice.DeviceStatus &= 0xFFFFFF7F);
        this.bizAsyncDevice.FreezeEvents();
    }

    public long GetMsSinceBoot() {
        return this.uposprinter.GetMsSinceBoot();
    }

    public long GetNsSinceBoot() {
        return this.uposprinter.GetNsSinceBoot();
    }

    public long TracePut(UPosPrinter.UposlibTrcSeverityLevel level, String text, int file, int line) {
        if (this.uposprinter == null) {
            return 0L;
        }
        return this.uposprinter.TracePut(level, text, file, line);
    }
}

