/*
 * Decompiled with CFR 0.152.
 */
package com.bizerba.jpos.PosPrinter;

import com.bizerba.jpos.PosPrinter.BizerbaDeviceEvent;
import com.bizerba.jpos.PosPrinter.BizerbaOutputCompleteEvent;
import com.bizerba.jpos.PosPrinter.BizerbaPOSPrinterService113;
import com.bizerba.jpos.PosPrinter.BizerbaStatusUpdateEvent;
import com.bizerba.jpos.PosPrinter.UPOSLib.UPosPrinter;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jpos.JposException;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;

public class BizerbaEventQueue
implements Runnable {
    private Semaphore _signalThread = new Semaphore(1);
    private Deque EventQueue = new LinkedList();
    private final Lock lock = new ReentrantLock();
    private boolean m_signalThreadEnd = false;
    private boolean m_forceThreadTerminate = false;
    private BizerbaPOSPrinterService113 printerRef;
    private EventCallbacks eventCallbacks = null;
    public boolean FreezeEvents = false;
    private Thread m_queueThread;

    public BizerbaEventQueue(BizerbaPOSPrinterService113 serviceObject) {
        this.printerRef = serviceObject;
        try {
            this._signalThread.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.TerminateWorkingThread();
    }

    public void GrantWorkingThread() {
        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "GrantWorkingThread", 50327890, 1);
        if (null == this.m_queueThread) {
            this.m_signalThreadEnd = false;
            this.m_forceThreadTerminate = false;
            this.m_queueThread = new Thread(this);
            this.m_queueThread.setName("EventQueueThread");
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "starting EventQueueThread", 50327890, 1);
            this.m_queueThread.start();
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "EventQueueThread is running, inverified", 50327890, 1);
        } else {
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "ignored, m_queueThread was not null", 50327890, 1);
        }
    }

    public void TerminateWorkingThread() {
        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "TerminateWorkingThread", 50327890, 1);
        if (null != this.m_queueThread) {
            try {
                this.m_signalThreadEnd = true;
                this._signalThread.release();
                this.m_queueThread.join(60000L);
                if (this.m_queueThread.isAlive()) {
                    this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "EventQueueThread still alive, interrupting...", 50327890, 1);
                    this.m_forceThreadTerminate = true;
                    this.m_queueThread.interrupt();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.ClearQueue();
            this.m_queueThread = null;
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "EventQueueThread terminated", 50327890, 1);
        } else {
            this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL1, "m_queueThread already null", 50327890, 1);
        }
    }

    public void ClearQueue() {
        this.lock.lock();
        this.EventQueue.clear();
        this.lock.unlock();
    }

    public void InsertStart(BizerbaDeviceEvent req) {
        this.lock.lock();
        this.EventQueue.addFirst(req);
        this._signalThread.release();
        this.lock.unlock();
    }

    public void InsertEnd(BizerbaDeviceEvent req) {
        this.lock.lock();
        this.EventQueue.addLast(req);
        this._signalThread.release();
        this.lock.unlock();
    }

    BizerbaDeviceEvent PopFirst() {
        this.lock.lock();
        BizerbaDeviceEvent ret = null;
        ret = (BizerbaDeviceEvent)this.EventQueue.pollFirst();
        this.lock.unlock();
        return ret;
    }

    public int GetEventCount() {
        this.lock.lock();
        int ret = 0;
        ret = this.EventQueue.size();
        this.lock.unlock();
        return ret;
    }

    @Override
    public void run() {
        int currentState = 0;
        int currentPaperState = 0;
        long l_thisTick = 0L;
        long lasttick = 0L;
        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "EQT Starting EventQueue Thread", 50327890, 1);
        while (!this.m_signalThreadEnd && !this.m_forceThreadTerminate) {
            try {
                BizerbaDeviceEvent evt;
                while (!this.m_signalThreadEnd && !this.m_forceThreadTerminate && this.GetEventCount() <= 0) {
                    l_thisTick = this.printerRef.GetMsSinceBoot();
                    if (l_thisTick - lasttick >= 2000L) {
                        currentState = this.printerRef.GetStatusUpdateState();
                        lasttick = l_thisTick;
                        if ((26 == currentState || 24 == currentState || 25 == currentState || 11 == currentState || 12 == currentState) && currentPaperState != currentState) {
                            currentPaperState = currentState;
                            evt = new BizerbaStatusUpdateEvent(currentState);
                            this.InsertEnd(evt);
                        }
                    }
                    this._signalThread.tryAcquire(2000L, TimeUnit.MILLISECONDS);
                }
                while (this.GetEventCount() > 0 && !this.m_forceThreadTerminate && !this.FreezeEvents) {
                    StatusUpdateEvent firedEvent;
                    evt = this.PopFirst();
                    if (null == evt) continue;
                    boolean fireEvent = true;
                    if (evt instanceof BizerbaStatusUpdateEvent) {
                        BizerbaStatusUpdateEvent sue = (BizerbaStatusUpdateEvent)evt;
                        firedEvent = new StatusUpdateEvent((Object)this.printerRef, sue.Status);
                        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "EQT firing SUE " + sue.Status, 50327890, 1);
                        this.eventCallbacks.fireStatusUpdateEvent(firedEvent);
                    } else if (evt instanceof BizerbaOutputCompleteEvent) {
                        BizerbaOutputCompleteEvent oce = (BizerbaOutputCompleteEvent)evt;
                        firedEvent = new OutputCompleteEvent((Object)this.printerRef, oce.OutputID);
                        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "EQT firing OCE " + oce.OutputID, 50327890, 1);
                        this.eventCallbacks.fireOutputCompleteEvent((OutputCompleteEvent)firedEvent);
                    }
                    this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "EQT fired.", 50327890, 1);
                }
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (JposException ex) {
            }
        }
        this.printerRef.TracePut(UPosPrinter.UposlibTrcSeverityLevel.LEVEL0, "EQT Exiting EventQueue Thread", 50327890, 1);
    }

    public void SetFreezeEvents(boolean freeze) {
        this.FreezeEvents = freeze;
    }

    public void setEventCallBack(EventCallbacks evtCallBacks) {
        this.eventCallbacks = evtCallBacks;
    }
}

