/*
 * Decompiled with CFR 0.152.
 */
package com.bizerba.jpos.CashDrawer;

import com.bizerba.jpos.CashDrawer.IUposCashDrawer;
import com.bizerba.jpos.CashDrawer.UposCashDrawerProtos;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class UPosCashDrawerZMQClient
implements IUposCashDrawer {
    private static final Logger logger = Logger.getLogger(UPosCashDrawerZMQClient.class.getName());
    public static final int APPROVAL_ID = 0;
    static Process process = null;
    private static final ZContext context = new ZContext(2);
    ZMQ.Poller items = context.createPoller(1);
    ZMQ.Socket socket = null;
    String processPath = "";
    String port = "";

    public UPosCashDrawerZMQClient(String processPath, String port) {
        this.processPath = processPath;
        this.port = port;
        this.InitZMQ();
    }

    protected void InitZMQ() {
        if (process == null) {
            try {
                if (this.processPath.length() > 0) {
                    process = new ProcessBuilder(this.processPath, this.port).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.INHERIT).start();
                    this.lazyConnect();
                } else {
                    this.lazyConnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void lazyConnect() {
        if (this.socket == null) {
            try {
                logger.info("Connect Socket to endpoint");
                this.socket = context.createSocket(3);
                String clientaddr = "tcp://localhost:" + this.port;
                logger.info("Client address: " + clientaddr);
                this.socket.connect(clientaddr);
                this.items.register(this.socket, 1);
            }
            catch (ZMQException e) {
                if (e.getErrorCode() == 156384818) {
                    logger.info("socket was terminated");
                }
                if (e.getErrorCode() == 156384765) {
                    logger.info("context was terminated");
                }
                logger.log(Level.SEVERE, "Exception occured", e);
            }
        }
    }

    protected synchronized UposCashDrawerProtos.Params sendMsg(UposCashDrawerProtos.Params request, long timeout) {
        UposCashDrawerProtos.Params msg = null;
        this.socket.send(request.toByteArray());
        if (this.items.poll(timeout) != -1) {
            if (this.items.pollin(0)) {
                byte[] reply = this.socket.recv(0);
                try {
                    msg = UposCashDrawerProtos.Params.parseFrom(reply);
                }
                catch (InvalidProtocolBufferException e) {
                    logger.log(Level.SEVERE, "Exception occured", e);
                }
            } else {
                msg = UposCashDrawerProtos.Params.newBuilder().setErrorCode(112).build();
            }
        }
        return msg;
    }

    protected synchronized UposCashDrawerProtos.Params sendMsg(UposCashDrawerProtos.Params request) {
        UposCashDrawerProtos.Params msg = null;
        this.socket.send(request.toByteArray());
        byte[] reply = this.socket.recv(0);
        try {
            msg = UposCashDrawerProtos.Params.parseFrom(reply);
        }
        catch (InvalidProtocolBufferException e) {
            logger.log(Level.SEVERE, "Exception occured", e);
        }
        return msg;
    }

    @Override
    public int UPOSlibInit() {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibInit).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibExit() {
        logger.info("Exit!");
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibExit).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        this.items.unregister(this.socket);
        this.socket.close();
        this.socket = null;
        context.destroy();
        process = null;
        return 0;
    }

    @Override
    public int UPOSlibOpen(int[] handle, String logDeviceName, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibOpen).addStrParam(logDeviceName).setInstHdl(handle[0]).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        handle[0] = reply.getInstHdl();
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibClose(int handle, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibClose).setInstHdl(handle).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request, 5000L);
        handle = reply.getInstHdl();
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibClaim(int handle, int timeout, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibClaim).setInstHdl(handle).addUint32Param(timeout).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibGetClaimed(int handle, boolean[] claimed, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibGetClaimed).setInstHdl(handle).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        claimed[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibRelease(int handle, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibRelease).setInstHdl(handle).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibSetDeviceEnabled(int handle, boolean enable, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibSetDeviceEnabled).setInstHdl(handle).addBoolParam(enable).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibGetDeviceEnabled(int handle, boolean[] enabled, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibGetDeviceEnabled).setInstHdl(handle).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        enabled[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibGetState(int handle, int[] state, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibGetState).setInstHdl(handle).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        state[0] = reply.getUint32Param(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibSetAsyncMode(int handle, boolean asyncMode, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibSetAsyncMode).setInstHdl(handle).addBoolParam(asyncMode).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibGetAsyncMode(int handle, boolean[] asyncMode, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibGetAsyncMode).setInstHdl(handle).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        asyncMode[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibDirectIO(int handle, int command, int[] data, String strObj, int objLen, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibDirectIO).setInstHdl(handle).addUint32Param(command).addUint32Param(data[0]).addStrParam(strObj).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        data[0] = reply.getUint32Param(0);
        strObj = reply.getStrParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibOpenDrawer(int handle, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibOpenDrawer).setInstHdl(handle).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibOpened(int handle, boolean[] cashDrawerState, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibOpened).setInstHdl(handle).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        cashDrawerState[0] = reply.getBoolParam(0);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }

    @Override
    public int UPOSlibWaitForDrawerClose(int handle, int timeout, int frequency, int duration, int delay, Object[] errorText) {
        UposCashDrawerProtos.Params request = UposCashDrawerProtos.Params.newBuilder().setCmd(UposCashDrawerProtos.CmdTypeCashDrawer.UPOSlibWaitForDrawerClose).setInstHdl(handle).addUint32Param(timeout).addUint32Param(frequency).addUint32Param(duration).addUint32Param(delay).build();
        UposCashDrawerProtos.Params reply = this.sendMsg(request);
        errorText[0] = reply.getErrorText();
        return reply.getErrorCode();
    }
}

