/*
 * Decompiled with CFR 0.152.
 */
package com.bizerba.jpos.CashDrawer;

import com.bizerba.jpos.CashDrawer.CashDrawerException;
import com.bizerba.jpos.CashDrawer.IUposCashDrawer;
import com.bizerba.jpos.CashDrawer.UPosCashDrawerZMQClient;

public class UPosCashDrawer {
    private static IUposCashDrawer m_jni = null;
    private static int m_refs = 0;
    private int m_handle = 0;

    public static synchronized UPosCashDrawer getInstance(String moduleFileNameZMQServer, String port) throws CashDrawerException {
        if (m_jni == null) {
            m_jni = new UPosCashDrawerZMQClient(moduleFileNameZMQServer, port);
            System.out.println("\nm_jni init\n");
        }
        return new UPosCashDrawer();
    }

    private UPosCashDrawer() throws CashDrawerException {
        int retVal;
        if (m_refs == 0 && (retVal = m_jni.UPOSlibInit()) != 0) {
            String tempStr = "RETURN:[" + retVal + "] cannot create cash drawer object";
            throw new CashDrawerException(tempStr);
        }
        ++m_refs;
    }

    public synchronized void releaseInstance() {
        if (m_refs > 0) {
            --m_refs;
        }
        if (m_refs == 0) {
            m_jni.UPOSlibExit();
            m_jni = null;
            System.out.println("\nm_jni = null\n");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public int init() {
        return m_jni.UPOSlibInit();
    }

    public int exit() {
        return m_jni.UPOSlibExit();
    }

    public int open(String logDeviceName, Object[] errorText) {
        int[] handle = new int[1];
        int retCode = m_jni.UPOSlibOpen(handle, logDeviceName, errorText);
        this.m_handle = retCode != 0 ? 0 : handle[0];
        return retCode;
    }

    public int close(Object[] errorText) {
        return m_jni.UPOSlibClose(this.m_handle, errorText);
    }

    public int claim(int timeout, Object[] errorText) {
        return m_jni.UPOSlibClaim(this.m_handle, timeout, errorText);
    }

    public int getClaimed(boolean[] claimed, Object[] errorText) {
        return m_jni.UPOSlibGetClaimed(this.m_handle, claimed, errorText);
    }

    public int release(Object[] errorText) {
        return m_jni.UPOSlibRelease(this.m_handle, errorText);
    }

    public int setDeviceEnabled(boolean enable, Object[] errorText) {
        return m_jni.UPOSlibSetDeviceEnabled(this.m_handle, enable, errorText);
    }

    public int getDeviceEnabled(boolean[] enable, Object[] errorText) {
        return m_jni.UPOSlibGetDeviceEnabled(this.m_handle, enable, errorText);
    }

    public int getState(int[] state, Object[] errorText) {
        return m_jni.UPOSlibGetState(this.m_handle, state, errorText);
    }

    public int setAsyncMode(boolean asyncMode, Object[] errorText) {
        return m_jni.UPOSlibSetAsyncMode(this.m_handle, asyncMode, errorText);
    }

    public int getAsyncMode(boolean[] asyncMode, Object[] errorText) {
        return m_jni.UPOSlibGetAsyncMode(this.m_handle, asyncMode, errorText);
    }

    public int directIO(int command, int[] data, String strObj, Object[] errorText) {
        return m_jni.UPOSlibDirectIO(this.m_handle, command, data, strObj, strObj.length(), errorText);
    }

    public int openDrawer(Object[] errorText) {
        return m_jni.UPOSlibOpenDrawer(this.m_handle, errorText);
    }

    public synchronized int opened(boolean[] cashDrawerState, Object[] errorText) {
        int ret = 0;
        if (null != m_jni) {
            ret = m_jni.UPOSlibOpened(this.m_handle, cashDrawerState, errorText);
        }
        return ret;
    }

    public int waitForDrawerClose(int timeout, int frequency, int duration, int delay, Object[] errorText) {
        return m_jni.UPOSlibWaitForDrawerClose(this.m_handle, timeout, frequency, duration, delay, errorText);
    }
}

