/*
 * Decompiled with CFR 0.152.
 */
package com.bizerba.jpos.CashDrawer;

import com.bizerba.jpos.CashDrawer.UPosCashDrawer;
import java.util.regex.Pattern;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.events.StatusUpdateEvent;
import jpos.loader.JposServiceLoader;
import jpos.services.CashDrawerService113;
import jpos.services.EventCallbacks;

public class BizerbaCashDrawerService113
implements CashDrawerService113,
Runnable {
    private boolean CapCompareFirmwareVersion = false;
    private int CapPowerReporting = 0;
    private boolean CapStatisticsReporting = false;
    private boolean CapUpdateFirmware = false;
    private boolean CapUpdateStatistics = false;
    private String CheckHealthText = "";
    private boolean FreezeEvents = false;
    private int PowerNotify = 0;
    private int PowerState = 2000;
    private int State = 1;
    private String DeviceServiceDescription = "";
    private int DeviceServiceVersion = 1009116;
    private String PhysicalDeviceDescription = "";
    private String PhysicalDeviceName = "";
    private boolean CapStatus;
    private boolean CapStatusMultiDrawerDetect;
    public static final int VERSION_NUMBER = 1009116;
    public final String PHYSICAL_DEVICE_NAME = "physicalDeviceName";
    public final String PHYSICAL_DEVICE_DESCRIPTION = "physicalDeviceDescription";
    protected final String SERVERFILE = "server_file";
    public static final String DEFAULT_PHYSICAL_DESCRIPTION = "Bizerba Cash drawer";
    public static final String DEFAULT_DEVICE_SERVICE_DESCRIPTION = "Bizerba CashDrawer Service, version {?}, (c) 2007 Bizerba";
    protected String moduleFileNameZMQServer = this.getClass().getProtectionDomain().getCodeSource().toString();
    protected String hostZMQServer = "5561";
    private boolean isOpened;
    private UPosCashDrawer bizcashdrawer;
    private EventCallbacks eventCallbacks = null;
    private Thread updateThread;
    private static final int POLL_CYCLE_TIME_IN_MS = 1000;
    private boolean dorun;

    public BizerbaCashDrawerService113() {
        String REGEX = "file:";
        Pattern p = Pattern.compile(REGEX);
        String[] items = p.split(this.moduleFileNameZMQServer);
        this.moduleFileNameZMQServer = items[items.length - 1];
        int lastIndex = this.moduleFileNameZMQServer.lastIndexOf("com_bizerba_jpos_CashDrawer.jar");
        if (lastIndex > -1) {
            this.moduleFileNameZMQServer = this.moduleFileNameZMQServer.substring(0, lastIndex);
            this.moduleFileNameZMQServer = this.moduleFileNameZMQServer.replaceAll("%20", " ");
            String seperator = System.getProperty("file.separator");
            System.out.println("Seperator:" + seperator);
            if (seperator.charAt(0) == '/') {
                System.out.println("found linux system");
                this.moduleFileNameZMQServer = this.moduleFileNameZMQServer + "linux_x86/protozmqcashdrawer.x";
            } else {
                System.out.println("Found windows system");
                if (this.moduleFileNameZMQServer.charAt(0) == '/') {
                    this.moduleFileNameZMQServer = this.moduleFileNameZMQServer.substring(1);
                }
                this.moduleFileNameZMQServer = this.moduleFileNameZMQServer + "winnt_x86\\protozmqcashdrawer.exe";
            }
        } else {
            this.moduleFileNameZMQServer = "";
        }
        System.out.println("\nset dorun = true create new thread\n");
        this.dorun = true;
        this.updateThread = new Thread(this);
        this.updateThread.start();
    }

    public void checkHealth(int pLevel) throws JposException {
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        switch (pLevel) {
            case 1: {
                this.CheckHealthText = "Internal Health Check: Successful";
                break;
            }
            case 2: {
                this.openDrawer();
                this.waitForDrawerClose(2000, 2000, 500, 500);
                this.CheckHealthText = "External Health Check: Successful";
            }
            case 3: {
                this.CheckHealthText = "Interactive Health Check: Not Supported";
                throw new JposException(106, "Interactive Health Check: Not Supported");
            }
        }
    }

    public void deleteInstance() throws JposException {
        this.dorun = false;
        System.out.println("\nset dorun = false call bizcashdrawer.releaseInstance()\n");
        this.bizcashdrawer.releaseInstance();
        try {
            this.updateThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.updateThread = null;
        this.bizcashdrawer = null;
    }

    public void claim(int pTimeout) throws JposException {
        Object[] errorText = new String[1];
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (pTimeout < 0 && pTimeout != -1) {
            throw new JposException(106, "Invalid timeout parameter");
        }
        int retVal = this.bizcashdrawer.claim(pTimeout, errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
    }

    public void close() throws JposException {
        Object[] errorText = new String[1];
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        int retVal = this.bizcashdrawer.close(errorText);
        this.eventCallbacks = null;
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
        this.State = 1;
    }

    public void directIO(int pCommand, int[] pData, Object pAuxData) throws JposException {
        Object[] errorText = new String[1];
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        int retVal = this.bizcashdrawer.directIO(pCommand, pData, (String)pAuxData, errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
    }

    public void open(String logicalName, EventCallbacks pEventCallbacks) throws JposException {
        Object objValue;
        Object[] errorText = new String[1];
        if (this.isOpened) {
            throw new JposException(106, "PosCashDrawer Device already open");
        }
        JposEntryRegistry entryRegistry = JposServiceLoader.getManager().getEntryRegistry();
        if (entryRegistry == null) {
            throw new JposException(104, "Configuration information not found");
        }
        JposEntry jposEntry = entryRegistry.getJposEntry(logicalName);
        this.isOpened = false;
        this.State = 1;
        if (jposEntry == null) {
            throw new JposException(109, "Device configuration not found");
        }
        this.DeviceServiceDescription = jposEntry.hasPropertyWithName("productDescription") ? ((objValue = jposEntry.getPropertyValue("productDescription")) != null ? (String)objValue : DEFAULT_DEVICE_SERVICE_DESCRIPTION.replaceFirst("{?}", "1009116")) : DEFAULT_DEVICE_SERVICE_DESCRIPTION.replaceFirst("{?}", "1009116");
        if (jposEntry.hasPropertyWithName("physicalDeviceName")) {
            objValue = jposEntry.getPropertyValue("physicalDeviceName");
            this.PhysicalDeviceName = objValue != null ? (String)objValue : DEFAULT_PHYSICAL_DESCRIPTION;
        }
        if (jposEntry.hasPropertyWithName("physicalDeviceDescription")) {
            objValue = jposEntry.getPropertyValue("physicalDeviceDescription");
            this.PhysicalDeviceDescription = objValue != null ? (String)objValue : DEFAULT_PHYSICAL_DESCRIPTION;
        }
        if (jposEntry.hasPropertyWithName("server_file") && (objValue = jposEntry.getPropertyValue("server_file")) != null) {
            String serverFile = ((String)objValue).trim();
            if (serverFile.length() > 0) {
                System.out.println("path to server file: " + serverFile);
                this.moduleFileNameZMQServer = serverFile;
            } else {
                System.out.println("using global configuration");
            }
            System.out.flush();
        }
        this.bizcashdrawer = UPosCashDrawer.getInstance(this.moduleFileNameZMQServer, this.hostZMQServer);
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        this.eventCallbacks = pEventCallbacks;
        int retVal = this.bizcashdrawer.open(this.PhysicalDeviceName, errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
        this.CheckHealthText = "";
        this.FreezeEvents = false;
        this.State = 2;
        this.isOpened = true;
    }

    public void release() throws JposException {
        Object[] errorText = new String[1];
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        int retVal = this.bizcashdrawer.release(errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
    }

    public void resetStatistics(String arg0) throws JposException {
        if (!this.CapStatisticsReporting || !this.CapUpdateStatistics) {
            throw new JposException(106, "Reset statistics functionality not supported");
        }
    }

    public void retrieveStatistics(String[] arg0) throws JposException {
        if (!this.CapStatisticsReporting) {
            throw new JposException(106, "Retrieve statistics functionality not supported");
        }
    }

    public void updateStatistics(String arg0) throws JposException {
        if (!this.CapStatisticsReporting || !this.CapUpdateStatistics) {
            throw new JposException(106, "Update statistics functionality not supported");
        }
    }

    public String getCheckHealthText() throws JposException {
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (this.State != 1) {
            return this.CheckHealthText;
        }
        throw new JposException(101, "Device is closed");
    }

    public boolean getClaimed() throws JposException {
        boolean[] claimed = new boolean[1];
        Object[] errorText = new String[1];
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        int retVal = this.bizcashdrawer.getClaimed(claimed, errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
        return claimed[0];
    }

    public int getDataCount() throws JposException {
        throw new JposException(106, "DataCount functionality not supported");
    }

    public boolean getDeviceEnabled() throws JposException {
        boolean[] enable = new boolean[1];
        Object[] errorText = new String[1];
        enable[0] = false;
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        int retVal = this.bizcashdrawer.getDeviceEnabled(enable, errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
        return enable[0];
    }

    public boolean getDataEventEnabled() throws JposException {
        throw new JposException(106, "DataEventEnabled functionality not supported");
    }

    public String getDeviceServiceDescription() throws JposException {
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (this.State != 1) {
            return this.DeviceServiceDescription;
        }
        throw new JposException(101, "Device is closed");
    }

    public int getDeviceServiceVersion() throws JposException {
        return this.DeviceServiceVersion;
    }

    public boolean getFreezeEvents() throws JposException {
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (this.State != 1) {
            return this.FreezeEvents;
        }
        throw new JposException(101, "Device is closed");
    }

    public String getPhysicalDeviceDescription() throws JposException {
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (this.State != 1) {
            return this.PhysicalDeviceDescription;
        }
        throw new JposException(101, "Device is closed");
    }

    public String getPhysicalDeviceName() throws JposException {
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        if (this.State != 1) {
            return this.PhysicalDeviceName;
        }
        throw new JposException(101, "Device is closed");
    }

    public int getState() throws JposException {
        int[] state = new int[1];
        Object[] errorText = new String[1];
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        int retVal = this.bizcashdrawer.getState(state, errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
        return state[0];
    }

    public void setDeviceEnabled(boolean flag) throws JposException {
        Object[] errorText = new String[1];
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        int retVal = this.bizcashdrawer.setDeviceEnabled(flag, errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
    }

    public void setFreezeEvents(boolean flag) throws JposException {
        this.FreezeEvents = flag;
    }

    public void clearOutput() throws JposException {
        throw new JposException(106, "clearOutput functionality not supported");
    }

    public void compareFirmwareVersion(String arg0, int[] arg1) throws JposException {
        if (!this.CapCompareFirmwareVersion) {
            throw new JposException(106, "Compare firmware version functionality not supported");
        }
    }

    public void updateFirmware(String arg0) throws JposException {
        if (!this.CapUpdateFirmware) {
            throw new JposException(106, "Update firmware functionality not supported");
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        return this.CapCompareFirmwareVersion;
    }

    public boolean getCapUpdateFirmware() throws JposException {
        return this.CapUpdateFirmware;
    }

    public boolean getCapStatisticsReporting() throws JposException {
        return this.CapStatisticsReporting;
    }

    public boolean getCapUpdateStatistics() throws JposException {
        return this.CapUpdateStatistics;
    }

    public boolean getCapStatusMultiDrawerDetect() throws JposException {
        return this.CapStatusMultiDrawerDetect;
    }

    public int getCapPowerReporting() throws JposException {
        return this.CapPowerReporting;
    }

    public int getPowerNotify() throws JposException {
        return this.PowerNotify;
    }

    public int getPowerState() throws JposException {
        return this.PowerState;
    }

    public void setPowerNotify(int arg0) throws JposException {
    }

    public boolean getCapStatus() throws JposException {
        return this.CapStatus;
    }

    public boolean getDrawerOpened() throws JposException {
        boolean[] bCashDrawerState = new boolean[1];
        Object[] errorText = new String[1];
        bCashDrawerState[0] = false;
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        int retVal = this.bizcashdrawer.opened(bCashDrawerState, errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
        return bCashDrawerState[0];
    }

    public void openDrawer() throws JposException {
        int retVal = 0;
        Object[] errorText = new String[1];
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        retVal = this.bizcashdrawer.openDrawer(errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
    }

    public void waitForDrawerClose(int arg0, int arg1, int arg2, int arg3) throws JposException {
        int retVal = 0;
        Object[] errorText = new String[1];
        if (this.bizcashdrawer == null) {
            throw new JposException(101, "instance not available!!!");
        }
        retVal = this.bizcashdrawer.waitForDrawerClose(arg0, arg1, arg2, arg3, errorText);
        if (0 != retVal) {
            throw new JposException(retVal, (String)errorText[0]);
        }
    }

    @Override
    public void run() {
        try {
            boolean lastopenstate = false;
            block7: while (this.dorun) {
                Thread.sleep(1000L);
                try {
                    if (this.eventCallbacks == null) continue;
                    boolean currentdraweropenstate = this.getDrawerOpened();
                    if (currentdraweropenstate != lastopenstate) {
                        lastopenstate = currentdraweropenstate;
                    } else if (this.dorun) continue;
                    while (this.dorun && this.FreezeEvents) {
                        Thread.sleep(1000L);
                    }
                    if (this.dorun) {
                        StatusUpdateEvent updateEvent = currentdraweropenstate ? new StatusUpdateEvent((Object)this, 1) : new StatusUpdateEvent((Object)this, 0);
                        this.eventCallbacks.fireStatusUpdateEvent(updateEvent);
                    }
                    break;
                }
                catch (JposException e) {
                    switch (e.getErrorCode()) {
                        case 101: 
                        case 105: 
                        case 108: {
                            continue block7;
                        }
                    }
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ee) {
            System.out.println(ee.toString());
            ee.printStackTrace();
        }
    }
}

