/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.MotionSensorControl114;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import jpos.services.MotionSensorService110;
import jpos.services.MotionSensorService111;
import jpos.services.MotionSensorService112;
import jpos.services.MotionSensorService113;
import jpos.services.MotionSensorService114;
import jpos.services.MotionSensorService17;
import jpos.services.MotionSensorService18;
import jpos.services.MotionSensorService19;

public class MotionSensor
extends BaseJposControl
implements MotionSensorControl114,
JposConst {
    protected MotionSensorService17 service17;
    protected MotionSensorService18 service18;
    protected MotionSensorService19 service19;
    protected MotionSensorService110 service110;
    protected MotionSensorService111 service111;
    protected MotionSensorService112 service112;
    protected MotionSensorService113 service113;
    protected MotionSensorService114 service114;
    protected Vector directIOListeners;
    protected Vector statusUpdateListeners;

    public MotionSensor() {
        this.deviceControlDescription = "JavaPOS MotionSensor Device Control";
        this.deviceControlVersion = 1014000;
        this.directIOListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service17.getCapPowerReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getMotion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service17.getMotion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service17.getPowerNotify();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPowerNotify(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service17.setPowerNotify(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service17.getPowerState();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getTimeout() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service17.getTimeout();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setTimeout(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service17.setTimeout(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void waitForMotion(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service17.waitForMotion(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void resetStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(stringArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(string, nArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateFirmware(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new MotionSensorCallbacks();
    }

    protected void setDeviceService(BaseService baseService, int n) throws JposException {
        if (baseService == null) {
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
            this.service110 = null;
            this.service111 = null;
            this.service112 = null;
            this.service113 = null;
            this.service114 = null;
        } else {
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (MotionSensorService17)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement MotionSensorService17 interface", exception);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (MotionSensorService18)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement MotionSensorService18 interface", exception);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (MotionSensorService19)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement MotionSensorService19 interface", exception);
                }
            }
            if (this.serviceVersion >= 1010000) {
                try {
                    this.service110 = (MotionSensorService110)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement MotionSensorService110 interface", exception);
                }
            }
            if (this.serviceVersion >= 1011000) {
                try {
                    this.service111 = (MotionSensorService111)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement MotionSensorService111 interface", exception);
                }
            }
            if (this.serviceVersion >= 1012000) {
                try {
                    this.service112 = (MotionSensorService112)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement MotionSensorService112 interface", exception);
                }
            }
            if (this.serviceVersion >= 1013000) {
                try {
                    this.service113 = (MotionSensorService113)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement MotionSensorService113 interface", exception);
                }
            }
            if (this.serviceVersion >= 1014000) {
                try {
                    this.service114 = (MotionSensorService114)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement MotionSensorService114 interface", exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(statusUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(statusUpdateListener);
        }
    }

    protected class MotionSensorCallbacks
    implements EventCallbacks {
        protected MotionSensorCallbacks() {
        }

        public BaseControl getEventSource() {
            return MotionSensor.this;
        }

        public void fireDataEvent(DataEvent dataEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDirectIOEvent(DirectIOEvent directIOEvent) {
            Vector vector = MotionSensor.this.directIOListeners;
            synchronized (vector) {
                int n = 0;
                while (n < MotionSensor.this.directIOListeners.size()) {
                    ((DirectIOListener)MotionSensor.this.directIOListeners.elementAt(n)).directIOOccurred(directIOEvent);
                    ++n;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent errorEvent) {
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent outputCompleteEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStatusUpdateEvent(StatusUpdateEvent statusUpdateEvent) {
            Vector vector = MotionSensor.this.statusUpdateListeners;
            synchronized (vector) {
                int n = 0;
                while (n < MotionSensor.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)MotionSensor.this.statusUpdateListeners.elementAt(n)).statusUpdateOccurred(statusUpdateEvent);
                    ++n;
                }
            }
        }
    }
}

