/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.LightsControl114;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import jpos.services.LightsService112;
import jpos.services.LightsService113;
import jpos.services.LightsService114;

public class Lights
extends BaseJposControl
implements LightsControl114,
JposConst {
    protected LightsService112 service112;
    protected LightsService113 service113;
    protected LightsService114 service114;
    protected Vector directIOListeners;
    protected Vector statusUpdateListeners;

    public Lights() {
        this.deviceControlDescription = "JavaPOS Lights Device Control";
        this.deviceControlVersion = 1014000;
        this.directIOListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    public int getCapAlarm() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapAlarm();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapBlink() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapBlink();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapColor() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapColor();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapCompareFirmwareVersion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapPowerReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapStatisticsReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapUpdateFirmware();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapUpdateStatistics();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getMaxLights() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getMaxLights();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getPowerNotify();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPowerNotify(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setPowerNotify(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getPowerState();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.compareFirmwareVersion(string, nArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void resetStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.resetStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.retrieveStatistics(stringArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void switchOff(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.switchOff(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void switchOn(int n, int n2, int n3, int n4, int n5) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.switchOn(n, n2, n3, n4, n5);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateFirmware(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.updateFirmware(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.updateStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new LightsCallbacks();
    }

    protected void setDeviceService(BaseService baseService, int n) throws JposException {
        if (baseService == null) {
            this.service112 = null;
            this.service113 = null;
            this.service114 = null;
        } else {
            if (this.serviceVersion >= 1012000) {
                try {
                    this.service112 = (LightsService112)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LightsService112 interface", exception);
                }
            }
            if (this.serviceVersion >= 1013000) {
                try {
                    this.service113 = (LightsService113)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LightsService113 interface", exception);
                }
            }
            if (this.serviceVersion >= 1014000) {
                try {
                    this.service114 = (LightsService114)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement LightsService114 interface", exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(statusUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(statusUpdateListener);
        }
    }

    protected class LightsCallbacks
    implements EventCallbacks {
        protected LightsCallbacks() {
        }

        public BaseControl getEventSource() {
            return Lights.this;
        }

        public void fireDataEvent(DataEvent dataEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDirectIOEvent(DirectIOEvent directIOEvent) {
            Vector vector = Lights.this.directIOListeners;
            synchronized (vector) {
                int n = 0;
                while (n < Lights.this.directIOListeners.size()) {
                    ((DirectIOListener)Lights.this.directIOListeners.elementAt(n)).directIOOccurred(directIOEvent);
                    ++n;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent errorEvent) {
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent outputCompleteEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStatusUpdateEvent(StatusUpdateEvent statusUpdateEvent) {
            Vector vector = Lights.this.statusUpdateListeners;
            synchronized (vector) {
                int n = 0;
                while (n < Lights.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)Lights.this.statusUpdateListeners.elementAt(n)).statusUpdateOccurred(statusUpdateEvent);
                    ++n;
                }
            }
        }
    }
}

