/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.ElectronicValueRWControl114;
import jpos.JposConst;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.events.TransitionListener;
import jpos.services.BaseService;
import jpos.services.ElectronicValueRWService112;
import jpos.services.ElectronicValueRWService113;
import jpos.services.ElectronicValueRWService114;
import jpos.services.EventCallbacks;

public class ElectronicValueRW
extends BaseJposControl
implements ElectronicValueRWControl114,
JposConst {
    protected ElectronicValueRWService112 service112;
    protected ElectronicValueRWService113 service113;
    protected ElectronicValueRWService114 service114;
    protected Vector dataListeners;
    protected Vector directIOListeners;
    protected Vector errorListeners;
    protected Vector outputCompleteListeners;
    protected Vector statusUpdateListeners;
    protected Vector transitionListeners;

    public ElectronicValueRW() {
        this.deviceControlDescription = "JavaPOS ElectronicValueRW Device Control";
        this.deviceControlVersion = 1014000;
        this.dataListeners = new Vector();
        this.directIOListeners = new Vector();
        this.errorListeners = new Vector();
        this.outputCompleteListeners = new Vector();
        this.statusUpdateListeners = new Vector();
        this.transitionListeners = new Vector();
    }

    public boolean getCapActivateService() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapActivateService();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapAddValue() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapAddValue();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCancelValue() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapCancelValue();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapCardSensor() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapCardSensor();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapCompareFirmwareVersion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapDetectionControl() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapDetectionControl();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapElectronicMoney() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapElectronicMoney();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapEnumerateCardServices() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapEnumerateCardServices();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapIndirectTransactionLog() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapIndirectTransactionLog();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapLockTerminal() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapLockTerminal();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapLogStatus() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapLogStatus();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapMediumID() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapMediumID();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapPoint() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapPoint();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapPowerReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapRealTimeData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapRealTimeData();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapStatisticsReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapSubtractValue() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapSubtractValue();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapTransaction() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapTransaction();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapTransactionLog() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapTransactionLog();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUnlockTerminal() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapUnlockTerminal();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapUpdateFirmware();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateKey() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapUpdateKey();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapUpdateStatistics();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapVoucher() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapVoucher();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapWriteValue() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCapWriteValue();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getCapPINDevice() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            return this.service114.getCapPINDevice();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean CapTrainingMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            return this.service114.CapTrainingMode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getAccountNumber() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getAccountNumber();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getAdditionalSecurityInformation() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getAdditionalSecurityInformation();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setAdditionalSecurityInformation(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setAdditionalSecurityInformation(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public long getAmount() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getAmount();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setAmount(long l) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setAmount(l);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getApprovalCode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getApprovalCode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setApprovalCode(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setApprovalCode(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getAsyncMode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getAsyncMode();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setAsyncMode(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setAsyncMode(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getAutoDisable() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getAutoDisable();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setAutoDisable(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setAutoDisable(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public long getBalance() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getBalance();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public long getBalanceOfPoint() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getBalanceOfPoint();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getCardServiceList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCardServiceList();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getCurrentService() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getCurrentService();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setCurrentService(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setCurrentService(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDataCount() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getDataCount();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getDataEventEnabled() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getDataEventEnabled();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setDataEventEnabled(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setDataEventEnabled(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getDetectionControl() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getDetectionControl();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setDetectionControl(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setDetectionControl(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDetectionStatus() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getDetectionStatus();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getExpirationDate() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getExpirationDate();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getLastUsedDate() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getLastUsedDate();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getLogStatus() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getLogStatus();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getMediumID() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getMediumID();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setMediumID(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setMediumID(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getOutputID() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getOutputID();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public long getPoint() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getPoint();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPoint(long l) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setPoint(l);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getPowerNotify();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPowerNotify(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setPowerNotify(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getPowerState();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getReaderWriterServiceList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getReaderWriterServiceList();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getSequenceNumber() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getSequenceNumber();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public long getSettledAmount() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getSettledAmount();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public long getSettledPoint() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getSettledPoint();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getTransactionLog() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getTransactionLog();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getVoucherID() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getVoucherID();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setVoucherID(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setVoucherID(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getVoucherIDList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service112.getVoucherIDList();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setVoucherIDList(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.setVoucherIDList(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getPINEntry() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            return this.service114.getPINEntry();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setPINEntry(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            this.service114.setPINEntry(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getTrainingModeState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            return this.service114.getTrainingModeState();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setTrainingModeState(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            this.service114.setTrainingModeState(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void accessLog(int n, int n2, int n3) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.accessLog(n, n2, n3);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void activateService(int[] nArray, Object[] objectArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.activateService(nArray, objectArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void addValue(int n, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.addValue(n, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void beginDetection(int n, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.beginDetection(n, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void beginRemoval(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.beginRemoval(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void cancelValue(int n, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.cancelValue(n, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void captureCard() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.captureCard();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void clearInput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.clearInput();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void clearInputProperties() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.clearInputProperties();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void clearOutput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.clearOutput();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.compareFirmwareVersion(string, nArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void endDetection() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.endDetection();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void endRemoval() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.endRemoval();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void enumerateCardServices() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.enumerateCardServices();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void lockTerminal() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.lockTerminal();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void readValue(int n, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.readValue(n, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void resetStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.resetStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.retrieveStatistics(stringArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void subtractValue(int n, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.subtractValue(n, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void transactionAccess(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.transactionAccess(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void unlockTerminal() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.unlockTerminal();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateFirmware(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.updateFirmware(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateKey(int[] nArray, Object[] objectArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.updateKey(nArray, objectArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void updateStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.updateStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void writeValue(int n, int n2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service112.writeValue(n, n2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void clearParameterInformation() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            this.service114.clearParameterInformation();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void queryLastSuccessfulTransactionResult() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            this.service114.queryLastSuccessfulTransactionResult();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void retrieveResultInformation(String string, String[] stringArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            this.service114.retrieveResultInformation(string, stringArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setParameterInformation(String string, String string2) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1014000) {
            throw new JposException(104, "Device Service is not 1.14.0 compliant.");
        }
        try {
            this.service114.setParameterInformation(string, string2);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    protected EventCallbacks createEventCallbacks() {
        return new ElectronicValueRWCallbacks();
    }

    protected void setDeviceService(BaseService baseService, int n) throws JposException {
        if (baseService == null) {
            this.service112 = null;
            this.service113 = null;
            this.service114 = null;
        } else {
            if (this.serviceVersion >= 1012000) {
                try {
                    this.service112 = (ElectronicValueRWService112)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement ElectronicValueRWService112 interface", exception);
                }
            }
            if (this.serviceVersion >= 1013000) {
                try {
                    this.service113 = (ElectronicValueRWService113)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement ElectronicValueRWService113 interface", exception);
                }
            }
            if (this.serviceVersion >= 1014000) {
                try {
                    this.service114 = (ElectronicValueRWService114)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement ElectronicValueRWService114 interface", exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataListener(DataListener dataListener) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.addElement(dataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListener(DataListener dataListener) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.removeElement(dataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorListener(ErrorListener errorListener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(errorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorListener(ErrorListener errorListener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(errorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputCompleteListener(OutputCompleteListener outputCompleteListener) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.addElement(outputCompleteListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputCompleteListener(OutputCompleteListener outputCompleteListener) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.removeElement(outputCompleteListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(statusUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(statusUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransitionListener(TransitionListener transitionListener) {
        Vector vector = this.transitionListeners;
        synchronized (vector) {
            this.transitionListeners.addElement(transitionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransitionListener(TransitionListener transitionListener) {
        Vector vector = this.transitionListeners;
        synchronized (vector) {
            this.transitionListeners.removeElement(transitionListener);
        }
    }

    protected class ElectronicValueRWCallbacks
    implements EventCallbacks {
        protected ElectronicValueRWCallbacks() {
        }

        public BaseControl getEventSource() {
            return ElectronicValueRW.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataEvent(DataEvent dataEvent) {
            Vector vector = ElectronicValueRW.this.dataListeners;
            synchronized (vector) {
                int n = 0;
                while (n < ElectronicValueRW.this.dataListeners.size()) {
                    ((DataListener)ElectronicValueRW.this.dataListeners.elementAt(n)).dataOccurred(dataEvent);
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDirectIOEvent(DirectIOEvent directIOEvent) {
            Vector vector = ElectronicValueRW.this.directIOListeners;
            synchronized (vector) {
                int n = 0;
                while (n < ElectronicValueRW.this.directIOListeners.size()) {
                    ((DirectIOListener)ElectronicValueRW.this.directIOListeners.elementAt(n)).directIOOccurred(directIOEvent);
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireErrorEvent(ErrorEvent errorEvent) {
            Vector vector = ElectronicValueRW.this.errorListeners;
            synchronized (vector) {
                int n = 0;
                while (n < ElectronicValueRW.this.errorListeners.size()) {
                    ((ErrorListener)ElectronicValueRW.this.errorListeners.elementAt(n)).errorOccurred(errorEvent);
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireOutputCompleteEvent(OutputCompleteEvent outputCompleteEvent) {
            Vector vector = ElectronicValueRW.this.outputCompleteListeners;
            synchronized (vector) {
                int n = 0;
                while (n < ElectronicValueRW.this.outputCompleteListeners.size()) {
                    ((OutputCompleteListener)ElectronicValueRW.this.outputCompleteListeners.elementAt(n)).outputCompleteOccurred(outputCompleteEvent);
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireStatusUpdateEvent(StatusUpdateEvent statusUpdateEvent) {
            Vector vector = ElectronicValueRW.this.statusUpdateListeners;
            synchronized (vector) {
                int n = 0;
                while (n < ElectronicValueRW.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)ElectronicValueRW.this.statusUpdateListeners.elementAt(n)).statusUpdateOccurred(statusUpdateEvent);
                    ++n;
                }
            }
        }
    }
}

